/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.actions;

import com.python.pydev.analysis.additionalinfo.IInfo;
import java.util.List;
import org.eclipse.ui.dialogs.SearchPattern;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.shared_core.callbacks.ICallback2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchHelper {
    public static boolean matchItem(SearchPattern patternMatcher, IInfo info) {
        String declaringModuleName;
        String pattern = patternMatcher.getPattern();
        List split = StringUtils.splitAndRemoveEmptyTrimmed((String)pattern, (char)'.');
        if (split.size() <= 1) {
            if (pattern.endsWith(".")) {
                split.add("");
            } else {
                return patternMatcher.matches(info.getName());
            }
        }
        if ((declaringModuleName = info.getDeclaringModuleName()) == null || declaringModuleName.length() == 0) {
            return false;
        }
        List moduleParts = StringUtils.splitAndRemoveEmptyTrimmed((String)declaringModuleName, (char)'.');
        while (split.size() > 1) {
            String head = (String)split.remove(0);
            SearchPattern headPattern = new SearchPattern();
            headPattern.setPattern(head);
            if (moduleParts.size() == 0) {
                return false;
            }
            if (headPattern.matches((String)moduleParts.remove(0))) continue;
            return false;
        }
        SearchPattern tailPattern = new SearchPattern();
        tailPattern.setPattern((String)split.get(0));
        return tailPattern.matches(info.getName());
    }

    public static boolean equalsFilter(String thisPattern, String otherPattern) {
        return MatchHelper.checkPatternSubparts(thisPattern, otherPattern, new ICallback2<Boolean, SearchPattern, SearchPattern>(){

            public Boolean call(SearchPattern thisP, SearchPattern otherP) {
                if (!thisP.equalsPattern(otherP)) {
                    return false;
                }
                return true;
            }
        });
    }

    public static boolean isSubFilter(String thisPattern, String otherPattern) {
        return MatchHelper.checkPatternSubparts(thisPattern, otherPattern, new ICallback2<Boolean, SearchPattern, SearchPattern>(){

            public Boolean call(SearchPattern thisP, SearchPattern otherP) {
                if (!thisP.isSubPattern(otherP)) {
                    return false;
                }
                return true;
            }
        });
    }

    private static boolean checkPatternSubparts(String thisPattern, String otherPattern, ICallback2<Boolean, SearchPattern, SearchPattern> check) {
        boolean otherEndsWithPoint;
        boolean thisEndsWithPoint = thisPattern.endsWith(".");
        if (thisEndsWithPoint != (otherEndsWithPoint = otherPattern.endsWith("."))) {
            return false;
        }
        List thisSplit = StringUtils.splitAndRemoveEmptyNotTrimmed((String)thisPattern, (char)'.');
        List otherSplit = StringUtils.splitAndRemoveEmptyNotTrimmed((String)otherPattern, (char)'.');
        if (thisEndsWithPoint) {
            thisSplit.add("");
        }
        if (otherEndsWithPoint) {
            otherSplit.add("");
        }
        if (thisSplit.size() != otherSplit.size()) {
            return false;
        }
        int i = 0;
        while (i < thisSplit.size()) {
            String thisStr = (String)thisSplit.get(i);
            String otherStr = (String)otherSplit.get(i);
            SearchPattern thisP = new SearchPattern();
            thisP.setPattern(thisStr);
            SearchPattern otherP = new SearchPattern();
            otherP.setPattern(otherStr);
            if (!((Boolean)check.call((Object)thisP, (Object)otherP)).booleanValue()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

