/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.actions;

import com.python.pydev.analysis.builder.AnalysisBuilderVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IObjectActionDelegate;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.ui.actions.resources.PyResourceAction;
import org.python.pydev.utils.PyFileListing;

public class ForceCodeAnalysisOnTree
extends PyResourceAction
implements IObjectActionDelegate {
    private Set<IFile> filesVisited = new HashSet<IFile>();

    protected boolean confirmRun() {
        return true;
    }

    protected void afterRun(int resourcesAffected) {
        this.filesVisited.clear();
    }

    protected void beforeRun() {
        this.filesVisited.clear();
    }

    protected int doActionOnResource(IResource next, IProgressMonitor monitor) {
        ArrayList<IFile> filesToVisit = new ArrayList<IFile>();
        if (next instanceof IContainer) {
            List l = PyFileListing.getAllIFilesBelow((IContainer)((IContainer)next));
            for (IFile element : l) {
                if (element == null) continue;
                filesToVisit.add(element);
            }
        } else if (next instanceof IFile) {
            filesToVisit.add((IFile)next);
        }
        PythonNature nature = PythonNature.getPythonNature((IResource)next);
        AnalysisBuilderVisitor visitor = new AnalysisBuilderVisitor();
        visitor.visitingWillStart((IProgressMonitor)new NullProgressMonitor(), false, null);
        FastStringBuffer buf = new FastStringBuffer();
        for (IFile f : filesToVisit) {
            String moduleName;
            if (monitor.isCanceled()) break;
            if (this.filesVisited.contains(f)) continue;
            this.filesVisited.add(f);
            monitor.setTaskName(buf.clear().append("Scheduling: ").append(f.getName()).toString());
            IDocument doc = FileUtilsFileBuffer.getDocFromResource((IResource)f);
            visitor.memo = new HashMap();
            visitor.memo.put("IS_FULL_BUILD", false);
            long documentTime = f.getModificationStamp();
            visitor.memo.put("DOCUMENT_TIME", documentTime);
            try {
                moduleName = nature.resolveModule((IResource)f);
            }
            catch (MisconfigurationException e) {
                Log.log((Throwable)e);
                continue;
            }
            if (moduleName == null) continue;
            AnalysisBuilderVisitor.setModuleNameInCache((Map)visitor.memo, (IResource)f, (String)moduleName);
            IModule module = nature.getAstManager().getModule(moduleName, (IPythonNature)nature, true);
            if (module == null) {
                Log.log((int)2, (String)("Unable to get module: " + moduleName + " for resource: " + f), null);
                continue;
            }
            visitor.doVisitChangedResource((IPythonNature)nature, (IResource)f, doc, null, module, (IProgressMonitor)new NullProgressMonitor(), true, 2, documentTime);
        }
        visitor.visitingEnded((IProgressMonitor)new NullProgressMonitor());
        return 1;
    }

    protected boolean needsUIThread() {
        return false;
    }
}

