/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis;

import com.python.pydev.analysis.AbstractAnalysisPreferences;
import com.python.pydev.analysis.AnalysisPlugin;
import com.python.pydev.analysis.IAnalysisPreferences;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisPreferences
extends AbstractAnalysisPreferences {
    private static IAnalysisPreferences analysisPreferences;
    public static final Object lock;
    static final Object[][] completeSeverityMap;
    HashMap<Integer, Integer> severityTypeMapCache = null;

    static {
        lock = new Object();
        completeSeverityMap = new Object[][]{{1, "SEVERITY_UNUSED_IMPORT", 1}, {2, "SEVERITY_UNUSED_VARIABLE", 1}, {3, "SEVERITY_UNDEFINED_VARIABLE", 2}, {4, "SEVERITY_DUPLICATED_SIGNATURE", 2}, {5, "SEVERITY_REIMPORT", 1}, {6, "SEVERITY_UNRESOLVED_IMPORT", 2}, {7, "SEVERITY_NO_SELF", 2}, {8, "SEVERITY_UNUSED_WILD_IMPORT", 1}, {9, "SEVERITY_UNDEFINED_IMPORT_VARIABLE", 2}, {10, "SEVERITY_UNUSED_PARAMETER", 0}, {11, "SEVERITY_NO_EFFECT_STMT", 1}, {12, "SEVERITY_INDENTATION_PROBLEM", 1}, {14, "SEVERITY_ASSIGNMENT_TO_BUILT_IN_SYMBOL", 1}, {15, "SEVERITY_PEP8", 0}, {16, "SEVERITY_ARGUMENTS_MISMATCH", 0}};
    }

    public static IAnalysisPreferences getAnalysisPreferences() {
        if (analysisPreferences == null) {
            analysisPreferences = new AnalysisPreferences();
        }
        return analysisPreferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCaches() {
        Object object = lock;
        synchronized (object) {
            this.severityTypeMapCache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, Integer> getSeverityTypeMap() {
        Object object = lock;
        synchronized (object) {
            if (this.severityTypeMapCache == null) {
                this.severityTypeMapCache = new HashMap();
                Preferences pluginPreferences = AnalysisPlugin.getDefault().getPluginPreferences();
                int i = 0;
                while (i < completeSeverityMap.length) {
                    Object[] s = completeSeverityMap[i];
                    this.severityTypeMapCache.put((Integer)s[0], pluginPreferences.getInt((String)s[1]));
                    ++i;
                }
                this.severityTypeMapCache.put(16, 0);
            }
            return this.severityTypeMapCache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSeverityForType(int type) {
        Object object = lock;
        synchronized (object) {
            Map<Integer, Integer> severityTypeMap = this.getSeverityTypeMap();
            Integer sev = severityTypeMap.get(type);
            if (sev == null) {
                throw new RuntimeException("Unable to get severity for: " + type);
            }
            return sev;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean makeCodeAnalysis() {
        Object object = lock;
        synchronized (object) {
            AnalysisPlugin plugin;
            block4: {
                plugin = AnalysisPlugin.getDefault();
                if (plugin != null) break block4;
                return false;
            }
            Preferences pluginPreferences = plugin.getPluginPreferences();
            return pluginPreferences.getBoolean("DO_CODE_ANALYSIS");
        }
    }

    @Override
    public Set<String> getNamesIgnoredByUnusedVariable() {
        return this.getSetOfNames("NAMES_TO_IGNORE_UNUSED_VARIABLE");
    }

    @Override
    public Set<String> getTokensAlwaysInGlobals() {
        return this.getSetOfNames("NAMES_TO_CONSIDER_GLOBALS");
    }

    private Set<String> getSetOfNames(String preferencesName) {
        HashSet<String> names = new HashSet<String>();
        Preferences pluginPreferences = AnalysisPlugin.getDefault().getPluginPreferences();
        String string = pluginPreferences.getString(preferencesName);
        if (string != null) {
            String[] strings = string.split(",");
            int i = 0;
            while (i < strings.length) {
                names.add(strings[i].trim());
                ++i;
            }
        }
        return names;
    }

    @Override
    public Set<String> getModuleNamePatternsToBeIgnored() {
        Set<String> setOfNames = this.getSetOfNames("NAMES_TO_IGNORE_UNUSED_IMPORT");
        HashSet<String> ret = new HashSet<String>();
        for (String string : setOfNames) {
            ret.add(string.replaceAll("\\*", ".*"));
        }
        return ret;
    }

    @Override
    public int getWhenAnalyze() {
        Preferences pluginPreferences = AnalysisPlugin.getDefault().getPluginPreferences();
        return pluginPreferences.getInt("WHEN_ANALYZE");
    }
}

