/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.markoccurrences;

import com.python.pydev.PydevPlugin;
import com.python.pydev.refactoring.ui.MarkOccurrencesPreferencesPage;
import com.python.pydev.refactoring.wizards.rename.PyRenameEntryPoint;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.refactoring.PyRefactorAction;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkOccurrencesJob
extends Job {
    private static final boolean DEBUG = false;
    private static MarkOccurrencesJob singleton;
    private static volatile long lastRequestTime;
    private WeakReference<PyEdit> editor;
    private long currRequestTime = -1L;
    private TextSelectionUtils ps;

    static {
        lastRequestTime = -1L;
    }

    private MarkOccurrencesJob(WeakReference<PyEdit> editor, TextSelectionUtils ps) {
        super("MarkOccurrencesJob");
        this.setPriority(40);
        this.setSystem(true);
        this.editor = editor;
        this.ps = ps;
        this.currRequestTime = System.currentTimeMillis();
    }

    public IStatus run(IProgressMonitor monitor) {
        if (this.currRequestTime == -1L) {
            return Status.OK_STATUS;
        }
        if (this.currRequestTime == lastRequestTime) {
            return Status.OK_STATUS;
        }
        lastRequestTime = this.currRequestTime;
        try {
            PyEdit pyEdit = (PyEdit)this.editor.get();
            if (pyEdit == null || monitor.isCanceled()) {
                return Status.OK_STATUS;
            }
            try {
                IDocumentProvider documentProvider = pyEdit.getDocumentProvider();
                if (documentProvider == null || monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)pyEdit.getEditorInput());
                if (annotationModel == null || monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                Tuple3<RefactoringRequest, PyRenameEntryPoint, Boolean> ret = this.checkAnnotations(pyEdit, documentProvider, monitor);
                if (pyEdit.cache == null || monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                PySourceViewer viewer = pyEdit.getPySourceViewer();
                if (viewer == null || monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                if (viewer.getIsInToggleCompletionStyle() || monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                if (((Boolean)ret.o3).booleanValue()) {
                    if (!this.addAnnotations(pyEdit, annotationModel, (RefactoringRequest)ret.o1, (PyRenameEntryPoint)((Object)ret.o2))) {
                        this.removeOccurenceAnnotations(annotationModel, pyEdit);
                    }
                } else {
                    this.removeOccurenceAnnotations(annotationModel, pyEdit);
                }
            }
            catch (OperationCanceledException e) {
                throw e;
            }
            catch (AssertionFailedException e) {
                String message = e.getMessage();
                if (message == null || message.indexOf("The file:") == -1 || message.indexOf("does not exist.") == -1) {
                    Log.log((Throwable)e);
                    Log.log((String)("Error while analyzing the file:" + pyEdit.getIFile()));
                }
            }
            catch (Throwable throwable) {
            }
        }
        catch (Throwable throwable) {}
        return Status.OK_STATUS;
    }

    private Tuple3<RefactoringRequest, PyRenameEntryPoint, Boolean> checkAnnotations(PyEdit pyEdit, IDocumentProvider documentProvider, IProgressMonitor monitor) throws BadLocationException, OperationCanceledException, CoreException, MisconfigurationException {
        if (!MarkOccurrencesPreferencesPage.useMarkOccurrences()) {
            return new Tuple3(null, null, (Object)false);
        }
        IEditorInput editorInput = pyEdit.getEditorInput();
        if (editorInput == null) {
            return new Tuple3(null, null, (Object)false);
        }
        if (documentProvider.getDocument((Object)editorInput) == null) {
            return new Tuple3(null, null, (Object)false);
        }
        if (pyEdit.getSelectionProvider() == null) {
            return new Tuple3(null, null, (Object)false);
        }
        PyRefactorAction pyRefactorAction = MarkOccurrencesJob.getRefactorAction(pyEdit);
        RefactoringRequest req = MarkOccurrencesJob.getRefactoringRequest(pyEdit, pyRefactorAction, PySelection.fromTextSelection((TextSelectionUtils)this.ps));
        if (req == null || !req.nature.getRelatedInterpreterManager().isConfigured()) {
            return new Tuple3(null, null, (Object)false);
        }
        PyRenameEntryPoint processor = new PyRenameEntryPoint(req);
        if (this.currRequestTime != lastRequestTime || monitor.isCanceled()) {
            return new Tuple3(null, null, (Object)false);
        }
        try {
            processor.checkInitialConditions(monitor);
            if (this.currRequestTime != lastRequestTime || monitor.isCanceled()) {
                return new Tuple3(null, null, (Object)false);
            }
            processor.checkFinalConditions(monitor, null);
            if (this.currRequestTime != lastRequestTime || monitor.isCanceled()) {
                return new Tuple3(null, null, (Object)false);
            }
            return new Tuple3((Object)req, (Object)processor, (Object)true);
        }
        catch (Throwable e) {
            throw new RuntimeException("Error in occurrences while analyzing modName:" + req.moduleName + " initialName:" + req.initialName + " line (start at 0):" + req.ps.getCursorLine(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean addAnnotations(PyEdit pyEdit, IAnnotationModel annotationModel, RefactoringRequest req, PyRenameEntryPoint processor) throws BadLocationException {
        HashSet<ASTEntry> occurrences = processor.getOccurrences();
        if (occurrences == null) {
            return false;
        }
        Map cache = pyEdit.cache;
        if (cache == null) {
            return false;
        }
        IDocument doc = pyEdit.getDocument();
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        HashMap<Annotation, Position> toAddAsMap = new HashMap<Annotation, Position>();
        boolean markOccurrencesInStrings = MarkOccurrencesPreferencesPage.useMarkOccurrencesInStrings();
        for (ASTEntry entry : occurrences) {
            if (!markOccurrencesInStrings && entry.node instanceof Name) {
                Name name = (Name)entry.node;
                if (name.ctx == 7) continue;
            }
            SimpleNode node = entry.getNameNode();
            IRegion lineInformation = doc.getLineInformation(node.beginLine - 1);
            try {
                Annotation annotation = new Annotation("com.python.pydev.occurrences", false, "occurrence");
                Position position = new Position(lineInformation.getOffset() + node.beginColumn - 1, req.initialName.length());
                toAddAsMap.put(annotation, position);
                annotations.add(annotation);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        List toRemove = PydevPlugin.getOccurrenceAnnotationsInPyEdit((PyEdit)pyEdit);
        Thread.yield();
        Thread thread = Thread.currentThread();
        int initiaThreadlPriority = thread.getPriority();
        try {
            thread.setPriority(5);
            Object object = this.getLockObject(annotationModel);
            synchronized (object) {
                IAnnotationModelExtension ext = (IAnnotationModelExtension)annotationModel;
                ext.replaceAnnotations(toRemove.toArray(new Annotation[0]), toAddAsMap);
            }
        }
        finally {
            thread.setPriority(initiaThreadlPriority);
        }
        cache.put("MarkOccurrencesJob Annotations", annotations);
        return true;
    }

    public static RefactoringRequest getRefactoringRequest(PyEdit pyEdit, PyRefactorAction pyRefactorAction, PySelection ps) throws BadLocationException, MisconfigurationException {
        RefactoringRequest req = pyRefactorAction.getRefactoringRequest();
        req.ps = ps;
        req.fillInitialNameAndOffset();
        req.inputName = "foo";
        req.setAdditionalInfo("findDefinitionInAdditionalInfo", (Object)false);
        req.setAdditionalInfo("findReferencesOnlyOnLocalScope", (Object)true);
        return req;
    }

    public static PyRefactorAction getRefactorAction(PyEdit pyEdit) {
        PyRefactorAction pyRefactorAction = new PyRefactorAction(){

            protected String perform(IAction action, IProgressMonitor monitor) throws Exception {
                throw new RuntimeException("Perform should not be called in this case.");
            }
        };
        pyRefactorAction.setEditor((IEditorPart)pyEdit);
        return pyRefactorAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeOccurenceAnnotations(IAnnotationModel annotationModel, PyEdit pyEdit) {
        Map cache = pyEdit.cache;
        if (cache == null) {
            return;
        }
        Thread.yield();
        Thread thread = Thread.currentThread();
        int initiaThreadlPriority = thread.getPriority();
        thread.setPriority(5);
        try {
            Object object = this.getLockObject(annotationModel);
            synchronized (object) {
                List annotationsToRemove = PydevPlugin.getOccurrenceAnnotationsInPyEdit((PyEdit)pyEdit);
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(annotationsToRemove.toArray(new Annotation[annotationsToRemove.size()]), new HashMap());
                } else {
                    Iterator annotationIterator = annotationsToRemove.iterator();
                    while (annotationIterator.hasNext()) {
                        annotationModel.removeAnnotation((Annotation)annotationIterator.next());
                    }
                }
                cache.put("MarkOccurrencesJob Annotations", null);
            }
        }
        finally {
            thread.setPriority(initiaThreadlPriority);
        }
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        if (annotationModel instanceof ISynchronizable) {
            return ((ISynchronizable)annotationModel).getLockObject();
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void scheduleRequest(WeakReference<PyEdit> editor2, TextSelectionUtils ps) {
        MarkOccurrencesJob j = singleton;
        if (j != null) {
            MarkOccurrencesJob markOccurrencesJob = j;
            synchronized (markOccurrencesJob) {
                j.cancel();
                singleton = null;
            }
        }
        singleton = new MarkOccurrencesJob(editor2, ps);
        singleton.schedule(750L);
    }
}

