/*
 * Decompiled with CFR 0.152.
 */
package org.python.parser;

import java.io.IOException;
import org.python.parser.CharStream;
import org.python.pydev.core.ObjectsPool;
import org.python.pydev.core.log.Log;

public final class ReaderCharStream
implements CharStream {
    private char[] buffer;
    private int[] bufline;
    private int[] bufcolumn;
    private boolean prevCharIsCR = false;
    private boolean prevCharIsLF = false;
    private int column = 0;
    private int line = 1;
    private int bufpos = -1;
    private int updatePos;
    private int tokenBegin;
    private static IOException ioException;
    private static final boolean DEBUG = false;
    private final ObjectsPool.ObjectsPoolMap interned = new ObjectsPool.ObjectsPoolMap();

    public ReaderCharStream(char[] cs) {
        this.buffer = cs;
        this.bufline = new int[cs.length];
        this.bufcolumn = new int[cs.length];
    }

    public int getCurrentPos() {
        return this.bufpos;
    }

    public void restorePos(int pos) {
        this.bufpos = pos;
    }

    /*
     * Unable to fully structure code
     */
    public void restoreLineColPos(int endLine, int endColumn) {
        initialBufPos = this.bufpos;
        currLine = this.getEndLine();
        if (currLine < endLine) {
            Log.log((String)("Cannot backtrack to a later position -- current line: " + this.getEndLine() + " requested line:" + endLine));
            return;
        }
        if (currLine != endLine || this.getEndColumn() >= endColumn) ** GOTO lbl12
        Log.log((String)("Cannot backtrack to a later position -- current col: " + this.getEndColumn() + " requested col:" + endColumn));
        return;
lbl-1000:
        // 1 sources

        {
            --this.bufpos;
lbl12:
            // 2 sources

            ** while ((this.getEndLine() != endLine || this.getEndColumn() != endColumn) && this.bufpos >= 0)
        }
lbl13:
        // 1 sources

        if (this.bufpos < 0 || this.getEndLine() != endLine) {
            this.bufpos = initialBufPos;
            Log.log((String)("Couldn't backtrack to position: line" + endLine + " -- col:" + endColumn));
        }
    }

    public final char readChar() throws IOException {
        try {
            ++this.bufpos;
            char r = this.buffer[this.bufpos];
            if (this.bufpos >= this.updatePos) {
                ++this.updatePos;
                ++this.column;
                if (this.prevCharIsLF) {
                    this.prevCharIsLF = false;
                    this.column = 1;
                    ++this.line;
                } else if (this.prevCharIsCR) {
                    this.prevCharIsCR = false;
                    if (r == '\n') {
                        this.prevCharIsLF = true;
                    } else {
                        this.column = 1;
                        ++this.line;
                    }
                }
                if (r == '\r') {
                    this.prevCharIsCR = true;
                } else if (r == '\n') {
                    this.prevCharIsLF = true;
                }
                this.bufline[this.bufpos] = this.line;
                this.bufcolumn[this.bufpos] = this.column;
            }
            return r;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            --this.bufpos;
            if (ioException == null) {
                ioException = new IOException();
            }
            throw ioException;
        }
    }

    public final int getColumn() {
        return this.bufcolumn[this.bufpos];
    }

    public final int getLine() {
        return this.bufline[this.bufpos];
    }

    public final int getEndColumn() {
        return this.bufcolumn[this.bufpos];
    }

    public final int getEndLine() {
        return this.bufline[this.bufpos];
    }

    public final int getBeginColumn() {
        return this.bufcolumn[this.tokenBegin];
    }

    public final int getBeginLine() {
        return this.bufline[this.tokenBegin];
    }

    public final void backup(int amount) {
        this.bufpos -= amount;
    }

    public final char BeginToken() throws IOException {
        char c = this.readChar();
        this.tokenBegin = this.bufpos;
        return c;
    }

    public final String GetImage() {
        String string = this.bufpos >= this.tokenBegin ? new String(this.buffer, this.tokenBegin, this.bufpos - this.tokenBegin + 1) : new String(this.buffer, this.tokenBegin, this.buffer.length - this.tokenBegin + 1);
        String existing = (String)this.interned.get((Object)string);
        if (existing == null) {
            existing = string;
            this.interned.put((Object)string, (Object)string);
        }
        return existing;
    }

    public final char[] GetSuffix(int len) {
        char[] ret = new char[len];
        if (len > 0) {
            try {
                int initial = this.bufpos - len + 1;
                if (initial < 0) {
                    int initial0 = initial;
                    len += initial;
                    initial = 0;
                    System.arraycopy(this.buffer, initial, ret, -initial0, len);
                } else {
                    System.arraycopy(this.buffer, initial, ret, 0, len);
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return ret;
    }

    public final void Done() {
        this.buffer = null;
        this.bufline = null;
        this.bufcolumn = null;
    }
}

