/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.nature;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.python.pydev.builder.PyDevBuilderPrefPage;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ProjectMisconfiguredException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.ASTManager;
import org.python.pydev.editor.codecompletion.revisited.ModulesManager;
import org.python.pydev.editor.codecompletion.revisited.ProjectModulesManager;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.navigator.elements.ProjectConfigError;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.AbstractPythonNature;
import org.python.pydev.plugin.nature.IPythonNatureStore;
import org.python.pydev.plugin.nature.PythonNatureListenersManager;
import org.python.pydev.plugin.nature.PythonNatureStore;
import org.python.pydev.plugin.nature.PythonPathNature;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.ui.interpreters.IInterpreterObserver;
import org.python.pydev.utils.JobProgressComunicator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonNature
extends AbstractPythonNature
implements IPythonNature {
    private static final List<WeakReference<PythonNature>> createdNatures = new ArrayList<WeakReference<PythonNature>>();
    private final Object initLock = new Object();
    public static final String PYTHON_NATURE_ID = "org.python.pydev.pythonNature";
    public static final String DJANGO_NATURE_ID = "org.python.pydev.django.djangoNature";
    public static final String PYTHON_NATURE_NAME = "pythonNature";
    public static final String BUILDER_ID = "org.python.pydev.PyDevBuilder";
    private IProject project;
    private ICodeCompletionASTManager astManager;
    private boolean initialized;
    private final IPythonPathNature pythonPathNature = new PythonPathNature();
    private final IPythonNatureStore pythonNatureStore = new PythonNatureStore();
    private static QualifiedName pythonProjectVersion = null;
    private static QualifiedName pythonProjectInterpreter = null;
    private static final Object mapLock = new Object();
    private static final Map<IProject, Object> mapLockAddNature = new HashMap<IProject, Object>();
    private final Job checkPythonPathHelperPathsJob = new Job("Check restored pythonpath"){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (PythonNature.this.astManager != null) {
                    String pythonpath = PythonNature.this.pythonPathNature.getOnlyProjectPythonPathStr(true);
                    PythonPathHelper pythonPathHelper = (PythonPathHelper)PythonNature.this.astManager.getModulesManager().getPythonPathHelper();
                    if (!new HashSet<String>(PythonPathHelper.parsePythonPathFromStr(pythonpath, null)).equals(new HashSet<String>(pythonPathHelper.getPythonpath()))) {
                        PythonNature.this.rebuildPath();
                    }
                }
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    };
    private RebuildPythonNatureModules rebuildJob = new RebuildPythonNatureModules();
    private static final Object lockGetNature = new Object();
    private String versionPropertyCache = null;
    private String interpreterPropertyCache = null;
    Integer interpreterType = null;
    public static boolean IN_TESTS = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PythonNature> getInitializedPythonNatures() {
        ArrayList<PythonNature> ret = new ArrayList<PythonNature>();
        List<WeakReference<PythonNature>> list = createdNatures;
        synchronized (list) {
            Iterator<WeakReference<PythonNature>> it = createdNatures.iterator();
            while (it.hasNext()) {
                PythonNature pythonNature = (PythonNature)it.next().get();
                if (pythonNature == null) {
                    it.remove();
                    continue;
                }
                if (pythonNature.getProject() == null) continue;
                ret.add(pythonNature);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PythonNature() {
        List<WeakReference<PythonNature>> list = createdNatures;
        synchronized (list) {
            createdNatures.add(new WeakReference<PythonNature>(this));
        }
    }

    static QualifiedName getPythonProjectVersionQualifiedName() {
        if (pythonProjectVersion == null) {
            pythonProjectVersion = new QualifiedName(PydevPlugin.getPluginID(), "PYTHON_PROJECT_VERSION");
        }
        return pythonProjectVersion;
    }

    static QualifiedName getPythonProjectInterpreterQualifiedName() {
        if (pythonProjectInterpreter == null) {
            pythonProjectInterpreter = new QualifiedName(PydevPlugin.getPluginID(), "PYTHON_PROJECT_INTERPRETER");
        }
        return pythonProjectInterpreter;
    }

    public boolean isResourceInPythonpathProjectSources(IResource resource, boolean addExternal) throws MisconfigurationException, CoreException {
        String resourceOSString = PydevPlugin.getIResourceOSString(resource);
        if (resourceOSString == null) {
            return false;
        }
        return this.isResourceInPythonpathProjectSources(resourceOSString, addExternal);
    }

    public boolean isResourceInPythonpathProjectSources(String absPath, boolean addExternal) throws MisconfigurationException, CoreException {
        return this.resolveModuleOnlyInProjectSources(absPath, addExternal) != null;
    }

    public String resolveModuleOnlyInProjectSources(IResource fileAbsolutePath, boolean addExternal) throws CoreException, MisconfigurationException {
        String resourceOSString = PydevPlugin.getIResourceOSString(fileAbsolutePath);
        if (resourceOSString == null) {
            return null;
        }
        return this.resolveModuleOnlyInProjectSources(resourceOSString, addExternal);
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public synchronized void setProject(IProject project) {
        this.getStore().setProject(project);
        this.project = project;
        this.pythonPathNature.setProject(project, (IPythonNature)this);
        if (project != null) {
            this.init(null, null, null, (IProgressMonitor)new NullProgressMonitor(), null, null);
        } else {
            this.clearCaches(false);
        }
    }

    public static IPythonNature addNature(IEditorInput element) {
        IFile file;
        if (element instanceof FileEditorInput && (file = (IFile)((FileEditorInput)element).getAdapter(IFile.class)) != null) {
            try {
                return PythonNature.addNature(file.getProject(), null, null, null, null, null, null);
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        }
        return null;
    }

    public static synchronized void removeNature(IProject project, IProgressMonitor monitor) throws CoreException {
        PythonNature nature;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((nature = PythonNature.getPythonNature(project)) == null) {
            return;
        }
        try {
            nature.pythonNatureStore.setProject(null);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            nature.pythonPathNature.setProject(null, null);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            PythonNatureListenersManager.notifyPythonPathRebuilt(project, null);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            IResource member = project.findMember(".pydevproject");
            if (member != null) {
                member.delete(true, null);
            }
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        IProjectDescription description = project.getDescription();
        ArrayList<String> natures = new ArrayList<String>(Arrays.asList(description.getNatureIds()));
        natures.remove(PYTHON_NATURE_ID);
        description.setNatureIds(natures.toArray(new String[natures.size()]));
        project.setDescription(description, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPythonNature addNature(IProject project, IProgressMonitor monitor, String version, String projectPythonpath, String externalProjectPythonpath, String projectInterpreter, Map<String, String> variableSubstitution) throws CoreException {
        block24: {
            Object object;
            PythonNature pythonNature;
            if (project == null || !project.isOpen()) {
                return null;
            }
            if (project.hasNature(PYTHON_NATURE_ID)) {
                return PythonNature.getPythonNature(project);
            }
            boolean alreadyLocked = false;
            Object object2 = mapLock;
            synchronized (object2) {
                if (mapLockAddNature.get(project) == null) {
                    mapLockAddNature.put(project, new Object());
                } else {
                    alreadyLocked = true;
                }
            }
            if (alreadyLocked) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                return PythonNature.getPythonNature(project);
            }
            IProjectDescription desc = project.getDescription();
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            if (projectInterpreter == null) {
                projectInterpreter = "Default";
            }
            try {
                String[] natures = desc.getNatureIds();
                String[] newNatures = new String[natures.length + 1];
                System.arraycopy(natures, 0, newNatures, 0, natures.length);
                newNatures[natures.length] = PYTHON_NATURE_ID;
                desc.setNatureIds(newNatures);
                ICommand[] commands = desc.getBuildSpec();
                if (!PythonNature.hasBuilder(commands) && PyDevBuilderPrefPage.usePydevBuilders()) {
                    ICommand command = desc.newCommand();
                    command.setBuilderName(BUILDER_ID);
                    ICommand[] newCommands = new ICommand[commands.length + 1];
                    System.arraycopy(commands, 0, newCommands, 1, commands.length);
                    newCommands[0] = command;
                    desc.setBuildSpec(newCommands);
                }
                project.setDescription(desc, monitor);
                PythonNature n = PythonNature.getPythonNature(project);
                if (!(n instanceof PythonNature)) break block24;
                PythonNature nature = n;
                nature.init(version, projectPythonpath, externalProjectPythonpath, monitor, projectInterpreter, variableSubstitution);
                pythonNature = nature;
                object = mapLock;
            }
            catch (Throwable throwable) {
                Object object3 = mapLock;
                synchronized (object3) {
                    mapLockAddNature.remove(project);
                }
                throw throwable;
            }
            synchronized (object) {
                mapLockAddNature.remove(project);
            }
            return pythonNature;
        }
        Object object = mapLock;
        synchronized (object) {
            mapLockAddNature.remove(project);
        }
        return null;
    }

    private static boolean hasBuilder(ICommand[] commands) {
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(BUILDER_ID)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String version, String projectPythonpath, String externalProjectPythonpath, IProgressMonitor monitor, String interpreter, Map<String, String> variableSubstitution) {
        block34: {
            boolean updatePaths;
            block33: {
                boolean bl = updatePaths = version != null || projectPythonpath != null || externalProjectPythonpath != null || variableSubstitution != null || interpreter != null;
                if (updatePaths) {
                    this.getStore().startInit();
                    try {
                        try {
                            if (variableSubstitution != null) {
                                this.getPythonPathNature().setVariableSubstitution(variableSubstitution);
                            }
                            if (projectPythonpath != null) {
                                this.getPythonPathNature().setProjectSourcePath(projectPythonpath);
                            }
                            if (externalProjectPythonpath != null) {
                                this.getPythonPathNature().setProjectExternalSourcePath(externalProjectPythonpath);
                            }
                            if (version != null || interpreter != null) {
                                this.setVersion(version, interpreter);
                            }
                        }
                        catch (CoreException e) {
                            Log.log((Throwable)e);
                            this.getStore().endInit();
                            break block33;
                        }
                    }
                    catch (Throwable throwable) {
                        this.getStore().endInit();
                        throw throwable;
                    }
                    this.getStore().endInit();
                } else if (this.astManager != null) {
                    return;
                }
            }
            Object e = this.initLock;
            synchronized (e) {
                if (this.initialized && !updatePaths) {
                    return;
                }
                this.initialized = true;
            }
            if (updatePaths) {
                this.rebuildPath();
                return;
            }
            if (monitor.isCanceled()) {
                this.checkPythonPathHelperPathsJob.schedule(500L);
                return;
            }
            try {
                File astOutputFile = this.getAstOutputFile();
                if (astOutputFile == null) {
                    Log.log((int)1, (String)("Not saving ast manager for: " + this.project + ". No write area available."), null);
                    return;
                }
                this.astManager = ASTManager.loadFromFile(astOutputFile);
                if (this.astManager == null) break block34;
                Object object = this.astManager.getLock();
                synchronized (object) {
                    this.astManager.setProject(this.getProject(), (IPythonNature)this, true);
                    if (this.astManager.getModulesManager().getOnlyDirectModules().length < 15) {
                        this.astManager = null;
                    }
                    if (this.astManager != null) {
                        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_interpreter_observer");
                        for (IInterpreterObserver observer : participants) {
                            try {
                                observer.notifyNatureRecreated(this, monitor);
                            }
                            catch (Exception e2) {
                                Log.log((Throwable)e2);
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                this.astManager = null;
            }
        }
        if (this.astManager == null) {
            try {
                this.rebuildPath();
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        } else {
            this.checkPythonPathHelperPathsJob.schedule(500L);
        }
    }

    private File getCompletionsCacheDir(IProject p) {
        IPath path = p.getWorkingLocation(PydevPlugin.getPluginID());
        if (path == null) {
            return null;
        }
        File file = new File(path.toOSString());
        return file;
    }

    public File getCompletionsCacheDir() {
        return this.getCompletionsCacheDir(this.getProject());
    }

    private File getAstOutputFile() {
        File completionsCacheDir = this.getCompletionsCacheDir();
        if (completionsCacheDir == null) {
            return null;
        }
        return new File(completionsCacheDir, "v1_astmanager");
    }

    public void rebuildPath() {
        this.clearCaches(true);
        this.rebuildJob.cancel();
        this.rebuildJob.schedule(20L);
    }

    public ICodeCompletionASTManager getAstManager() {
        return this.astManager;
    }

    public boolean isOkToUse() {
        return this.astManager != null && this.pythonPathNature != null;
    }

    public void setAstManager(ICodeCompletionASTManager astManager) {
        this.astManager = astManager;
    }

    public IPythonPathNature getPythonPathNature() {
        return this.pythonPathNature;
    }

    public static IPythonPathNature getPythonPathNature(IProject project) {
        PythonNature pythonNature = PythonNature.getPythonNature(project);
        if (pythonNature != null) {
            return pythonNature.pythonPathNature;
        }
        return null;
    }

    public static List<IPythonNature> getAllPythonNatures() {
        IProject[] projects;
        ArrayList<IPythonNature> natures = new ArrayList<IPythonNature>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            PythonNature nature = PythonNature.getPythonNature(project);
            if (nature != null) {
                natures.add(nature);
            }
            ++n2;
        }
        return natures;
    }

    public static PythonNature getPythonNature(IResource resource) {
        if (resource == null) {
            return null;
        }
        return PythonNature.getPythonNature(resource.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PythonNature getPythonNature(IProject project) {
        if (project != null && project.isOpen()) {
            try {
                try {
                    Project p;
                    ProjectInfo info;
                    IProjectNature nature;
                    if (project instanceof Project && (nature = (info = (ProjectInfo)(p = (Project)project).getResourceInfo(false, false)).getNature(PYTHON_NATURE_ID)) instanceof PythonNature) {
                        return (PythonNature)nature;
                    }
                }
                catch (Throwable e) {
                    Log.log((Throwable)e);
                }
                Object e = lockGetNature;
                synchronized (e) {
                    IProjectNature n = project.getNature(PYTHON_NATURE_ID);
                    if (n instanceof PythonNature) {
                        return (PythonNature)n;
                    }
                }
            }
            catch (CoreException e) {
                Log.logInfo((Throwable)e);
            }
        }
        return null;
    }

    public String getVersion() throws CoreException {
        return (String)this.getVersionAndError().o1;
    }

    private Tuple<String, String> getVersionAndError() throws CoreException {
        String msg;
        if (this.project != null) {
            if (this.versionPropertyCache == null) {
                String storeVersion = this.getStore().getPropertyFromXml(PythonNature.getPythonProjectVersionQualifiedName());
                if (storeVersion == null) {
                    this.setVersion(this.getDefaultVersion(), null);
                } else if (!IPythonNature.Versions.ALL_VERSIONS_ANY_FLAVOR.contains(storeVersion)) {
                    Log.log((String)("The stored version is invalid (" + storeVersion + "). Setting default."));
                    this.setVersion(this.getDefaultVersion(), null);
                } else {
                    this.versionPropertyCache = storeVersion;
                }
            }
        } else {
            String msg2 = "Trying to get version without project set. Returning default.";
            Log.log((String)msg2);
            return new Tuple((Object)this.getDefaultVersion(), (Object)msg2);
        }
        if (this.versionPropertyCache == null) {
            msg = "The cached version is null. Returning default.";
            Log.log((String)msg);
            return new Tuple((Object)this.getDefaultVersion(), (Object)msg);
        }
        if (!IPythonNature.Versions.ALL_VERSIONS_ANY_FLAVOR.contains(this.versionPropertyCache)) {
            msg = "The cached version (" + this.versionPropertyCache + ") is invalid. Returning default.";
            Log.log((String)msg);
            return new Tuple((Object)this.getDefaultVersion(), (Object)msg);
        }
        return new Tuple((Object)this.versionPropertyCache, null);
    }

    public void setVersion(String version, String interpreter) throws CoreException {
        this.clearCaches(false);
        if (version != null) {
            this.versionPropertyCache = version;
        }
        if (interpreter != null) {
            this.interpreterPropertyCache = interpreter;
        }
        if (this.project != null) {
            QualifiedName pythonProjectInterpreterQualifiedName;
            QualifiedName pythonProjectVersionQualifiedName;
            IPythonNatureStore store;
            String current;
            boolean notify = false;
            if (!(version == null || (current = (store = this.getStore()).getPropertyFromXml(pythonProjectVersionQualifiedName = PythonNature.getPythonProjectVersionQualifiedName())) != null && current.equals(version))) {
                store.setPropertyToXml(pythonProjectVersionQualifiedName, version, true);
                notify = true;
            }
            if (!(interpreter == null || (current = (store = this.getStore()).getPropertyFromXml(pythonProjectInterpreterQualifiedName = PythonNature.getPythonProjectInterpreterQualifiedName())) != null && current.equals(interpreter))) {
                store.setPropertyToXml(pythonProjectInterpreterQualifiedName, interpreter, true);
                notify = true;
            }
            if (notify) {
                PythonNatureListenersManager.notifyPythonPathRebuilt(this.project, this);
            }
        }
    }

    public String getDefaultVersion() {
        return "python 2.7";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAstManager() {
        File astOutputFile = this.getAstOutputFile();
        if (astOutputFile == null) {
            Log.log((int)1, (String)("Not saving ast manager for: " + this.project + ". No write area available."), null);
            return;
        }
        if (this.astManager == null) {
            return;
        }
        Object object = this.astManager.getLock();
        synchronized (object) {
            this.astManager.saveToFile(astOutputFile);
        }
    }

    public int getInterpreterType() throws CoreException {
        if (this.interpreterType == null) {
            String version = this.getVersion();
            this.interpreterType = PythonNature.getInterpreterTypeFromVersion(version);
        }
        return this.interpreterType;
    }

    public static int getInterpreterTypeFromVersion(String version) throws CoreException {
        int interpreterType = IPythonNature.Versions.ALL_JYTHON_VERSIONS.contains(version) ? 1 : (IPythonNature.Versions.ALL_IRONPYTHON_VERSIONS.contains(version) ? 2 : 0);
        return interpreterType;
    }

    public String resolveModule(String fileAbsolutePath) {
        String moduleName = null;
        if (this.astManager != null) {
            moduleName = this.astManager.getModulesManager().resolveModule(fileAbsolutePath);
        }
        return moduleName;
    }

    public String resolveModuleOnlyInProjectSources(String fileAbsolutePath, boolean addExternal) throws CoreException {
        IModulesManager modulesManager;
        String moduleName = null;
        if (this.astManager != null && (modulesManager = this.astManager.getModulesManager()) instanceof ProjectModulesManager) {
            moduleName = ((ProjectModulesManager)modulesManager).resolveModuleOnlyInProjectSources(fileAbsolutePath, addExternal);
        }
        return moduleName;
    }

    public static String[] getStrAsStrItems(String str) {
        return str.split("\\|");
    }

    public IInterpreterManager getRelatedInterpreterManager() {
        try {
            int interpreterType = this.getInterpreterType();
            switch (interpreterType) {
                case 0: {
                    return PydevPlugin.getPythonInterpreterManager();
                }
                case 1: {
                    return PydevPlugin.getJythonInterpreterManager();
                }
                case 2: {
                    return PydevPlugin.getIronpythonInterpreterManager();
                }
            }
            throw new RuntimeException("Unable to find the related interpreter manager for type: " + interpreterType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void clearCaches(boolean clearGlobalModulesCache) {
        this.interpreterType = null;
        this.versionPropertyCache = null;
        this.interpreterPropertyCache = null;
        this.pythonPathNature.clearCaches();
        if (clearGlobalModulesCache) {
            ModulesManager.clearCache();
        }
    }

    public void clearBuiltinCompletions() {
        try {
            this.getRelatedInterpreterManager().clearBuiltinCompletions(this.getProjectInterpreterName());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public IToken[] getBuiltinCompletions() {
        try {
            return this.getRelatedInterpreterManager().getBuiltinCompletions(this.getProjectInterpreterName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IModule getBuiltinMod() {
        try {
            return this.getRelatedInterpreterManager().getBuiltinMod(this.getProjectInterpreterName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void clearBuiltinMod() {
        try {
            this.getRelatedInterpreterManager().clearBuiltinMod(this.getProjectInterpreterName());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<IPythonNature> getPythonNaturesRelatedTo(int relatedTo) {
        IProject[] projects;
        ArrayList<IPythonNature> ret = new ArrayList<IPythonNature>();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            PythonNature nature = PythonNature.getPythonNature(project);
            try {
                if (nature != null && nature.getInterpreterType() == relatedTo) {
                    ret.add(nature);
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            ++n2;
        }
        return ret;
    }

    public int getGrammarVersion() {
        List splitted;
        block7: {
            String storeVersion;
            String version;
            block6: {
                try {
                    version = this.getVersion();
                    if (version != null) break block6;
                    Log.log((String)"Found null version. Returning default.");
                    return 13;
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
            }
            splitted = StringUtils.split((String)version, (char)' ');
            if (splitted.size() == 2) break block7;
            try {
                storeVersion = this.getStore().getPropertyFromXml(PythonNature.getPythonProjectVersionQualifiedName());
            }
            catch (Exception e) {
                storeVersion = "Unable to get storeVersion. Reason: " + e.getMessage();
            }
            Log.log((String)("Found invalid version: " + version + "\n" + "Returning default\n" + "Project: " + this.project + "\n" + "versionPropertyCache: " + this.versionPropertyCache + "\n" + "storeVersion:" + storeVersion));
            return 13;
        }
        String grammarVersion = (String)splitted.get(1);
        return PythonNature.getGrammarVersionFromStr(grammarVersion);
    }

    public static int getGrammarVersionFromStr(String grammarVersion) {
        if ("2.1".equals(grammarVersion)) {
            return 10;
        }
        if ("2.2".equals(grammarVersion)) {
            return 10;
        }
        if ("2.3".equals(grammarVersion)) {
            return 10;
        }
        if ("2.4".equals(grammarVersion)) {
            return 10;
        }
        if ("2.5".equals(grammarVersion)) {
            return 11;
        }
        if ("2.6".equals(grammarVersion)) {
            return 12;
        }
        if ("2.7".equals(grammarVersion)) {
            return 13;
        }
        if ("3.0".equals(grammarVersion)) {
            return 99;
        }
        if (grammarVersion != null) {
            if (grammarVersion.startsWith("3")) {
                return 99;
            }
            if (grammarVersion.startsWith("2")) {
                return 13;
            }
        }
        Log.log((String)("Unable to recognize version: " + grammarVersion + " returning default."));
        return 13;
    }

    protected IPythonNatureStore getStore() {
        return this.pythonNatureStore;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IInterpreterInfo getProjectInterpreter() throws MisconfigurationException, PythonNatureWithoutProjectException {
        if (this.project == null) {
            throw new PythonNatureWithoutProjectException("Project is not set.");
        }
        try {
            String projectInterpreterName = this.getProjectInterpreterName();
            IInterpreterManager relatedInterpreterManager = this.getRelatedInterpreterManager();
            if (relatedInterpreterManager == null) {
                if (IN_TESTS) {
                    return null;
                }
                throw new ProjectMisconfiguredException("Did not expect the interpreter manager to be null.");
            }
            IInterpreterInfo ret = "Default".equals(projectInterpreterName) ? relatedInterpreterManager.getDefaultInterpreterInfo(true) : relatedInterpreterManager.getInterpreterInfo(projectInterpreterName, null);
            if (ret != null) {
                return ret;
            }
            IProject p = this.getProject();
            String projectName = p != null ? p.getName() : "null";
            String msg = "Invalid interpreter: " + projectInterpreterName + " configured for project: " + projectName + ".";
            ProjectMisconfiguredException e = new ProjectMisconfiguredException(msg);
            Log.log((Throwable)e);
            throw e;
        }
        catch (CoreException e) {
            throw new ProjectMisconfiguredException((Throwable)e);
        }
    }

    public String getProjectInterpreterName() throws CoreException {
        if (this.project != null && this.interpreterPropertyCache == null) {
            String storeInterpreter = this.getStore().getPropertyFromXml(PythonNature.getPythonProjectInterpreterQualifiedName());
            if (storeInterpreter == null) {
                this.setVersion(null, "Default");
            } else {
                this.interpreterPropertyCache = storeInterpreter;
            }
        }
        return this.interpreterPropertyCache;
    }

    public Tuple<List<ProjectConfigError>, IInterpreterInfo> getConfigErrorsAndInfo(IProject relatedToProject) throws PythonNatureWithoutProjectException {
        if (IN_TESTS) {
            return new Tuple(new ArrayList(), null);
        }
        ArrayList<ProjectConfigError> lst = new ArrayList<ProjectConfigError>();
        if (this.project == null) {
            lst.add(new ProjectConfigError(relatedToProject, "The configured nature has no associated project."));
        }
        IInterpreterInfo info = null;
        try {
            info = this.getProjectInterpreter();
            String executableOrJar = info.getExecutableOrJar();
            if (!new File(executableOrJar).exists()) {
                lst.add(new ProjectConfigError(relatedToProject, "The interpreter configured does not exist in the filesystem: " + executableOrJar));
            }
            ArrayList projectSourcePathSet = new ArrayList(this.getPythonPathNature().getProjectSourcePathSet(true));
            Collections.sort(projectSourcePathSet);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            for (String path : projectSourcePathSet) {
                if (path.trim().length() <= 0) continue;
                Path p = new Path(path);
                IResource resource = root.findMember((IPath)p);
                if (resource == null) {
                    relatedToProject.refreshLocal(p.segmentCount(), null);
                    resource = root.findMember((IPath)p);
                }
                if (resource != null && resource.exists()) continue;
                lst.add(new ProjectConfigError(relatedToProject, "Source folder: " + path + " not found"));
            }
            List externalPaths = this.getPythonPathNature().getProjectExternalSourcePathAsList(true);
            Collections.sort(externalPaths);
            for (String path : externalPaths) {
                if (new File(path).exists()) continue;
                lst.add(new ProjectConfigError(relatedToProject, "Invalid external source folder specified: " + path));
            }
            Tuple<String, String> versionAndError = this.getVersionAndError();
            if (versionAndError.o2 != null) {
                lst.add(new ProjectConfigError(relatedToProject, org.python.pydev.shared_core.string.StringUtils.replaceNewLines((String)((String)versionAndError.o2), (String)" ")));
            }
        }
        catch (MisconfigurationException e) {
            lst.add(new ProjectConfigError(relatedToProject, org.python.pydev.shared_core.string.StringUtils.replaceNewLines((String)e.getMessage(), (String)" ")));
        }
        catch (Throwable e) {
            lst.add(new ProjectConfigError(relatedToProject, org.python.pydev.shared_core.string.StringUtils.replaceNewLines((String)("Unexpected error:" + e.getMessage()), (String)" ")));
        }
        return new Tuple(lst, (Object)info);
    }

    public String toString() {
        return "PythonNature: " + this.project;
    }

    protected class RebuildPythonNatureModules
    extends Job {
        protected RebuildPythonNatureModules() {
            super("Python Nature: rebuilding modules");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            String paths;
            try {
                paths = PythonNature.this.pythonPathNature.getOnlyProjectPythonPathStr(true);
            }
            catch (CoreException e1) {
                Log.log((Throwable)e1);
                return Status.OK_STATUS;
            }
            try {
                if (monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                JobProgressComunicator jobProgressComunicator = new JobProgressComunicator(monitor, "Rebuilding modules", -1, this);
                PythonNature nature = PythonNature.this;
                try {
                    ICodeCompletionASTManager tempAstManager = PythonNature.this.astManager;
                    if (tempAstManager == null) {
                        tempAstManager = new ASTManager();
                    }
                    if (monitor.isCanceled()) {
                        return Status.OK_STATUS;
                    }
                    Object object = tempAstManager.getLock();
                    synchronized (object) {
                        PythonNature.this.astManager = tempAstManager;
                        tempAstManager.setProject(PythonNature.this.getProject(), (IPythonNature)nature, false);
                        tempAstManager.changePythonPath(paths, PythonNature.this.project, (IProgressMonitor)jobProgressComunicator);
                        if (monitor.isCanceled()) {
                            return Status.OK_STATUS;
                        }
                        PythonNature.this.saveAstManager();
                        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_interpreter_observer");
                        for (IInterpreterObserver observer : participants) {
                            if (monitor.isCanceled()) {
                                return Status.OK_STATUS;
                            }
                            try {
                                observer.notifyProjectPythonpathRestored(nature, jobProgressComunicator);
                            }
                            catch (Exception e) {
                                Log.log((Throwable)e);
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    Log.log((Throwable)e);
                }
                if (monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                PythonNatureListenersManager.notifyPythonPathRebuilt(PythonNature.this.project, nature);
                jobProgressComunicator.done();
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }
}

