/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.navigator.LabelAndImage;
import org.python.pydev.navigator.elements.IWrappedResource;
import org.python.pydev.navigator.elements.ProjectConfigError;
import org.python.pydev.navigator.elements.PythonFolder;
import org.python.pydev.navigator.elements.PythonNode;
import org.python.pydev.navigator.elements.PythonProjectSourceFolder;
import org.python.pydev.navigator.elements.PythonSourceFolder;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PyTitlePreferencesPage;
import org.python.pydev.shared_core.structure.TreeNode;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

public class PythonLabelProvider
implements ILabelProvider {
    private WorkbenchLabelProvider provider;
    private volatile Image projectWithError = null;
    private Object lock = new Object();

    public PythonLabelProvider() {
        this.provider = new WorkbenchLabelProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(Object element) {
        IFile iFile;
        String name;
        if (element instanceof PythonProjectSourceFolder) {
            return PydevPlugin.getImageCache().get("icons/project_source_folder.gif");
        }
        if (element instanceof PythonSourceFolder) {
            return PydevPlugin.getImageCache().get("icons/packagefolder_obj.gif");
        }
        if (element instanceof PythonFolder) {
            PythonFolder folder = (PythonFolder)element;
            IFolder actualObject = (IFolder)folder.getActualObject();
            if (actualObject != null) {
                String[] validInitFiles;
                String[] stringArray = validInitFiles = FileTypesPreferencesPage.getValidInitFiles();
                int n = validInitFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String init = stringArray[n2];
                    if (actualObject.getFile(init).exists()) {
                        if (!this.checkParentsHaveInit(folder, validInitFiles)) break;
                        return PydevPlugin.getImageCache().get("icons/package_obj.gif");
                    }
                    ++n2;
                }
            }
            return this.provider.getImage((Object)actualObject);
        }
        if (element instanceof PythonNode) {
            PythonNode node = (PythonNode)element;
            return node.entry.getImage();
        }
        if (element instanceof IWrappedResource) {
            IWrappedResource resource = (IWrappedResource)element;
            Object actualObject = resource.getActualObject();
            if (actualObject instanceof IFile) {
                IFile iFile2 = (IFile)actualObject;
                String name2 = iFile2.getName();
                if (name2.indexOf(46) == -1) {
                    try {
                        if (PythonPathHelper.markAsPyDevFileIfDetected(iFile2)) {
                            if (FileTypesPreferencesPage.isCythonFile(name2)) {
                                return PydevPlugin.getImageCache().get("icons/cython_file.png");
                            }
                            return PydevPlugin.getImageCache().get("icons/python_file.gif");
                        }
                    }
                    catch (Exception exception) {}
                }
                if (FileTypesPreferencesPage.isCythonFile(name2)) {
                    return PydevPlugin.getImageCache().get("icons/cython_file.png");
                }
                if (name2.startsWith("__init__.") && PythonPathHelper.isValidSourceFile(name2)) {
                    return PyTitlePreferencesPage.getInitIcon();
                }
                IProject project = iFile2.getProject();
                try {
                    String djangoModulesHandling;
                    if (project.hasNature("org.python.pydev.django.djangoNature") && ((djangoModulesHandling = PyTitlePreferencesPage.getDjangoModulesHandling()) == "TITLE_EDITOR_DJANGO_MODULES_SHOW_PARENT_AND_DECORATE" || djangoModulesHandling == "TITLE_EDITOR_DJANGO_MODULES_DECORATE") && PyTitlePreferencesPage.isDjangoModuleToDecorate(name2)) {
                        return PyTitlePreferencesPage.getDjangoModuleIcon(name2);
                    }
                }
                catch (CoreException e) {
                    Log.log((Throwable)e);
                }
            }
            return this.provider.getImage(actualObject);
        }
        if (element instanceof ProjectConfigError) {
            return PydevPlugin.getImageCache().get("icons/showerr_tsk.gif");
        }
        if (element instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)element;
            LabelAndImage data = (LabelAndImage)treeNode.getData();
            return data.image;
        }
        if (element instanceof IFile && FileTypesPreferencesPage.isCythonFile(name = (iFile = (IFile)element).getName())) {
            return PydevPlugin.getImageCache().get("icons/cython_file.png");
        }
        if (element instanceof IProject) {
            IMarker[] markers;
            IProject project = (IProject)element;
            if (!project.isOpen()) {
                return null;
            }
            try {
                markers = project.findMarkers("org.python.pydev.PydevProjectErrorMarkers", true, 0);
            }
            catch (CoreException e1) {
                Log.log((Throwable)e1);
                return null;
            }
            if (markers == null || markers.length == 0) {
                return null;
            }
            if (this.projectWithError == null) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.projectWithError == null) {
                        Image image = this.provider.getImage(element);
                        try {
                            DecorationOverlayIcon decorationOverlayIcon = new DecorationOverlayIcon(image, PydevPlugin.getImageCache().getDescriptor("icons/error_small.gif"), 2);
                            this.projectWithError = decorationOverlayIcon.createImage();
                        }
                        catch (Exception e) {
                            Log.log((String)"Unable to create error decoration for project icon.", (Throwable)e);
                            this.projectWithError = image;
                        }
                    }
                }
            }
            return this.projectWithError;
        }
        return null;
    }

    private final boolean checkParentsHaveInit(PythonFolder pythonFolder, String[] validInitFiles) {
        IWrappedResource parentElement = pythonFolder.getParentElement();
        while (parentElement != null) {
            Object tempParent;
            if (parentElement instanceof PythonSourceFolder) {
                return true;
            }
            Object actualObject = parentElement.getActualObject();
            if (actualObject instanceof IFolder) {
                IFolder folder = (IFolder)actualObject;
                boolean foundInit = false;
                String[] stringArray = validInitFiles;
                int n = validInitFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String init = stringArray[n2];
                    IFile file = folder.getFile(init);
                    if (file.exists()) {
                        foundInit = true;
                        break;
                    }
                    ++n2;
                }
                if (!foundInit) {
                    return false;
                }
            }
            if (!((tempParent = parentElement.getParentElement()) instanceof IWrappedResource)) break;
            parentElement = (IWrappedResource)tempParent;
        }
        return true;
    }

    public String getText(Object element) {
        if (element instanceof PythonNode) {
            PythonNode node = (PythonNode)element;
            return node.entry.toString();
        }
        if (element instanceof PythonSourceFolder) {
            PythonSourceFolder sourceFolder = (PythonSourceFolder)element;
            return this.provider.getText((Object)sourceFolder.container);
        }
        if (element instanceof IWrappedResource) {
            IWrappedResource resource = (IWrappedResource)element;
            return this.provider.getText(resource.getActualObject());
        }
        if (element instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)element;
            LabelAndImage data = (LabelAndImage)treeNode.getData();
            return data.label;
        }
        if (element instanceof ProjectConfigError) {
            return ((ProjectConfigError)element).getLabel();
        }
        return this.provider.getText(element);
    }

    public void addListener(ILabelProviderListener listener) {
        this.provider.addListener(listener);
    }

    public void dispose() {
        this.provider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.provider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.provider.removeListener(listener);
    }
}

