/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codefolding;

import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class FoldingEntry {
    public static final int TYPE_IMPORT = 1;
    public static final int TYPE_DEF = 2;
    public static final int TYPE_COMMENT = 3;
    public static final int TYPE_STR = 4;
    public static final int TYPE_STATEMENT = 5;
    public static final int TYPE_ELSE = 6;
    public static final int TYPE_EXCEPT = 7;
    public static final int TYPE_FINALLY = 8;
    public int type;
    public int startLine;
    public int endLine;
    public ASTEntry astEntry;

    public FoldingEntry(int type, int startLine, int endLine, ASTEntry astEntry) {
        if (endLine < startLine) {
            endLine = startLine;
        }
        this.type = type;
        this.startLine = startLine;
        this.endLine = endLine;
        this.astEntry = astEntry;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.endLine;
        result = 31 * result + this.startLine;
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FoldingEntry other = (FoldingEntry)obj;
        if (this.endLine != other.endLine) {
            return false;
        }
        if (this.startLine != other.startLine) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        FastStringBuffer buf = new FastStringBuffer();
        buf.append("FoldingEntry<");
        buf.append("type:");
        buf.append(this.type);
        buf.append(" startLine:");
        buf.append(this.startLine);
        buf.append(" endLine:");
        buf.append(this.endLine);
        buf.append(">");
        return buf.toString();
    }

    public ASTEntry getAstEntry() {
        return this.astEntry;
    }
}

