/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.FileUtilsFileBuffer;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.ModulesKeyForZip;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.ModulesFoundStructure;
import org.python.pydev.editor.codecompletion.revisited.ModulesManagerCache;
import org.python.pydev.editor.codecompletion.revisited.PyPublicTreeMap;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.JythonModulesManagerUtils;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.CompiledModule;
import org.python.pydev.editor.codecompletion.revisited.modules.EmptyModule;
import org.python.pydev.editor.codecompletion.revisited.modules.EmptyModuleForZip;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModulesManager
implements IModulesManager {
    private static final String MODULES_MANAGER_V2 = "MODULES_MANAGER_V2\n";
    private static final boolean DEBUG_BUILD = false;
    private static final boolean DEBUG_TEMPORARY_MODULES = false;
    private static final boolean DEBUG_ZIP = false;
    private static final double ONE_MINUTE_IN_MILLIS = 60000.0;
    protected volatile CompletionCache completionCache = null;
    protected final Object lockCompletionCache = new Object();
    private volatile int completionCacheI = 0;
    protected final PyPublicTreeMap<ModulesKey, ModulesKey> modulesKeys = new PyPublicTreeMap();
    protected final Object modulesKeysLock = new Object();
    protected static final ModulesManagerCache cache = new ModulesManagerCache();
    protected final PythonPathHelper pythonPathHelper = new PythonPathHelper();
    public final Map<String, SortedMap<Integer, IModule>> temporaryModules = new HashMap<String, SortedMap<Integer, IModule>>();
    private final Object lockTemporaryModules = new Object();
    private int nextHandle = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startCompletionCache() {
        Object object = this.lockCompletionCache;
        synchronized (object) {
            if (this.completionCache == null) {
                this.completionCache = new CompletionCache();
            }
            ++this.completionCacheI;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCompletionCache() {
        Object object = this.lockCompletionCache;
        synchronized (object) {
            --this.completionCacheI;
            if (this.completionCacheI == 0) {
                this.completionCache = null;
            } else if (this.completionCacheI < 0) {
                throw new RuntimeException("Completion cache negative (request unsynched)");
            }
        }
    }

    public PythonPathHelper getPythonPathHelper() {
        return this.pythonPathHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File workspaceMetadataFile) {
        FastStringBuffer buf;
        if (workspaceMetadataFile.exists() && !workspaceMetadataFile.isDirectory()) {
            try {
                FileUtils.deleteFile((File)workspaceMetadataFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!workspaceMetadataFile.exists()) {
            workspaceMetadataFile.mkdirs();
        }
        File modulesKeysFile = new File(workspaceMetadataFile, "modulesKeys");
        File pythonpatHelperFile = new File(workspaceMetadataFile, "pythonpath");
        HashMap<String, Integer> commonTokens = new HashMap<String, Integer>();
        Object object = this.modulesKeysLock;
        synchronized (object) {
            buf = new FastStringBuffer(this.modulesKeys.size() * 50);
            buf.append(MODULES_MANAGER_V2);
            for (ModulesKey next : this.modulesKeys.keySet()) {
                buf.append(next.name);
                if (next.file != null) {
                    buf.append("|");
                    if (next instanceof ModulesKeyForZip) {
                        ModulesKeyForZip modulesKeyForZip = (ModulesKeyForZip)next;
                        if (modulesKeyForZip.zipModulePath != null) {
                            String fileStr = next.file.toString();
                            Integer t = (Integer)commonTokens.get(fileStr);
                            if (t == null) {
                                t = commonTokens.size();
                                commonTokens.put(fileStr, t);
                            }
                            buf.append(t.intValue());
                            buf.append("|");
                            buf.append(modulesKeyForZip.zipModulePath);
                            buf.append("|");
                            buf.append(modulesKeyForZip.isFile ? (char)'1' : '0');
                        }
                    } else {
                        buf.append(next.file.toString());
                    }
                }
                buf.append('\n');
            }
        }
        if (commonTokens.size() > 0) {
            FastStringBuffer header = new FastStringBuffer(buf.length() + commonTokens.size() * 50);
            header.append(MODULES_MANAGER_V2);
            header.append("--COMMON--\n");
            for (Map.Entry entries : commonTokens.entrySet()) {
                header.append(((Integer)entries.getValue()).intValue());
                header.append('=');
                header.append((String)entries.getKey());
                header.append('\n');
            }
            header.append("--END-COMMON--\n");
            header.append(buf);
            buf = header;
        }
        FileUtils.writeStrToFile((String)buf.toString(), (File)modulesKeysFile);
        this.pythonPathHelper.saveToFile(pythonpatHelperFile);
    }

    public static void loadFromFile(ModulesManager modulesManager, File workspaceMetadataFile) throws IOException {
        if (workspaceMetadataFile.exists() && !workspaceMetadataFile.isDirectory()) {
            throw new IOException("Expecting: " + workspaceMetadataFile + " to be a directory.");
        }
        File modulesKeysFile = new File(workspaceMetadataFile, "modulesKeys");
        File pythonpatHelperFile = new File(workspaceMetadataFile, "pythonpath");
        if (!modulesKeysFile.isFile()) {
            throw new IOException("Expecting: " + modulesKeysFile + " to exist (and be a file).");
        }
        if (!pythonpatHelperFile.isFile()) {
            throw new IOException("Expecting: " + pythonpatHelperFile + " to exist (and be a file).");
        }
        String fileContents = FileUtils.getFileContents((File)modulesKeysFile);
        if (!fileContents.startsWith(MODULES_MANAGER_V2)) {
            throw new RuntimeException("Could not load modules manager from " + modulesKeysFile + " (version changed).");
        }
        HashMap<Integer, String> intToString = new HashMap<Integer, String>();
        if ((fileContents = fileContents.substring(MODULES_MANAGER_V2.length())).startsWith("--COMMON--\n")) {
            String header = fileContents.substring("--COMMON--\n".length());
            header = header.substring(0, header.indexOf("--END-COMMON--\n"));
            fileContents = fileContents.substring(fileContents.indexOf("--END-COMMON--\n") + "--END-COMMON--\n".length());
            for (String line : StringUtils.iterLines((String)header)) {
                List split = StringUtils.split((String)(line = line.trim()), (char)'=');
                if (split.size() != 2) continue;
                try {
                    int i = Integer.parseInt((String)split.get(0));
                    intToString.put(i, (String)split.get(1));
                }
                catch (NumberFormatException e) {
                    Log.log((Throwable)e);
                }
            }
            if (fileContents.startsWith(MODULES_MANAGER_V2)) {
                fileContents = fileContents.substring(MODULES_MANAGER_V2.length());
            }
        }
        ModulesManager.handleFileContents(modulesManager, fileContents, intToString);
        if (modulesManager.pythonPathHelper == null) {
            throw new IOException("Pythonpath helper not properly restored. " + modulesManager.getClass().getName() + " dir:" + workspaceMetadataFile);
        }
        modulesManager.pythonPathHelper.loadFromFile(pythonpatHelperFile);
        if (modulesManager.pythonPathHelper.getPythonpath() == null) {
            throw new IOException("Pythonpath helper pythonpath not properly restored. " + modulesManager.getClass().getName() + " dir:" + workspaceMetadataFile);
        }
        if (modulesManager.pythonPathHelper.getPythonpath().size() == 0) {
            throw new IOException("Pythonpath helper pythonpath restored with no contents. " + modulesManager.getClass().getName() + " dir:" + workspaceMetadataFile);
        }
        if (modulesManager.modulesKeys.size() < 2) {
            throw new IOException("Only " + modulesManager.modulesKeys.size() + " modules restored in I/O. " + modulesManager.getClass().getName() + " dir:" + workspaceMetadataFile);
        }
    }

    static void handleFileContents(ModulesManager modulesManager, String fileContents, HashMap<Integer, String> intToString) {
        String trimmed;
        String string = fileContents;
        int len = string.length();
        final ArrayList<ModulesKey> lst = new ArrayList<ModulesKey>();
        int start = 0;
        int i = 0;
        String[] parts = new String[4];
        int partsFound = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == '\r') {
                trimmed = string.substring(start, i).trim();
                if (trimmed.length() > 0) {
                    parts[partsFound] = trimmed;
                    ++partsFound;
                }
                ModulesManager.handleLineParts(modulesManager, intToString, parts, partsFound, lst);
                partsFound = 0;
                if (i < len - 1 && string.charAt(i + 1) == '\n') {
                    ++i;
                }
                start = i + 1;
            } else if (c == '\n') {
                trimmed = string.substring(start, i).trim();
                if (trimmed.length() > 0) {
                    parts[partsFound] = trimmed;
                    ++partsFound;
                }
                ModulesManager.handleLineParts(modulesManager, intToString, parts, partsFound, lst);
                partsFound = 0;
                start = i + 1;
            } else if (c == '|') {
                trimmed = string.substring(start, i).trim();
                if (trimmed.length() > 0) {
                    parts[partsFound] = trimmed;
                    ++partsFound;
                }
                start = i + 1;
            }
            ++i;
        }
        if (start < len && start != i) {
            trimmed = string.substring(start, i).trim();
            if (trimmed.length() > 0) {
                parts[partsFound] = trimmed;
                ++partsFound;
            }
            ModulesManager.handleLineParts(modulesManager, intToString, parts, partsFound, lst);
        }
        try {
            final int size = lst.size();
            modulesManager.modulesKeys.buildFromSorted(size, new Iterator(){
                private int i = 0;

                public boolean hasNext() {
                    return this.i < size;
                }

                public Object next() {
                    final ModulesKey next = (ModulesKey)lst.get(this.i);
                    ++this.i;
                    return new Map.Entry(){

                        public Object getKey() {
                            return next;
                        }

                        public Object getValue() {
                            return next;
                        }

                        public Object setValue(Object value) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }, null, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void handleLineParts(ModulesManager modulesManager, HashMap<Integer, String> intToString, String[] split, int size, ArrayList<ModulesKey> lst) {
        if (size > 0 && split[0].length() > 0) {
            if (size == 1) {
                ModulesKey key = new ModulesKey(split[0], null);
                lst.add(key);
            } else if (size == 2) {
                ModulesKey key = new ModulesKey(split[0], new File(split[1]));
                lst.add(key);
            } else if (size == 4) {
                try {
                    ModulesKeyForZip key = new ModulesKeyForZip(split[0], new File(intToString.get(Integer.parseInt(split[1]))), split[2], split[3].equals("1"));
                    lst.add((ModulesKey)key);
                }
                catch (NumberFormatException e) {
                    Log.log((Throwable)e);
                }
            }
        }
    }

    protected Map<ModulesKey, AbstractModule> getModules() {
        throw new RuntimeException("Deprecated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePythonPath(String pythonpath, IProject project, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.pythonPathHelper.setPythonPath(pythonpath);
        ModulesFoundStructure modulesFound = this.pythonPathHelper.getModulesFoundStructure(monitor);
        PyPublicTreeMap<ModulesKey, ModulesKey> keys = this.buildKeysFromModulesFound(monitor, modulesFound);
        Object object = this.modulesKeysLock;
        synchronized (object) {
            this.modulesKeys.clear();
            this.modulesKeys.putAll(keys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuple<List<ModulesKey>, List<ModulesKey>> diffModules(PyPublicTreeMap<ModulesKey, ModulesKey> keysFound) {
        ArrayList<ModulesKey> newKeys = new ArrayList<ModulesKey>();
        ArrayList<ModulesKey> removedKeys = new ArrayList<ModulesKey>();
        Iterator<ModulesKey> it = keysFound.keySet().iterator();
        Object object = this.modulesKeysLock;
        synchronized (object) {
            ModulesKey modulesKey;
            while (it.hasNext()) {
                ModulesKey next = it.next();
                modulesKey = this.modulesKeys.get(next);
                if (modulesKey != null && modulesKey.getClass() == next.getClass()) continue;
                newKeys.add(next);
            }
            for (ModulesKey next : this.modulesKeys.keySet()) {
                modulesKey = this.modulesKeys.get(next);
                if (modulesKey != null && modulesKey.getClass() == next.getClass()) continue;
                removedKeys.add(next);
            }
        }
        return new Tuple(newKeys, removedKeys);
    }

    public PyPublicTreeMap<ModulesKey, ModulesKey> buildKeysFromModulesFound(IProgressMonitor monitor, ModulesFoundStructure modulesFound) {
        PyPublicTreeMap<ModulesKey, ModulesKey> keys = new PyPublicTreeMap<ModulesKey, ModulesKey>();
        int j = 0;
        FastStringBuffer buffer = new FastStringBuffer();
        Iterator<Map.Entry<File, String>> iterator = modulesFound.regularModules.entrySet().iterator();
        while (iterator.hasNext() && !monitor.isCanceled()) {
            Map.Entry<File, String> entry = iterator.next();
            File f = entry.getKey();
            String m = entry.getValue();
            if (j % 20 == 0) {
                buffer.clear();
                monitor.setTaskName(buffer.append("Module resolved: ").append(m).toString());
                monitor.worked(1);
            }
            if (m != null) {
                ModulesKey modulesKey = new ModulesKey(m, f);
                if (!keys.containsKey(modulesKey)) {
                    keys.put(modulesKey, modulesKey);
                } else if (PythonPathHelper.isValidSourceFile(f.getName())) {
                    keys.put(modulesKey, modulesKey);
                }
            }
            ++j;
        }
        for (ModulesFoundStructure.ZipContents zipContents : modulesFound.zipContents) {
            if (monitor.isCanceled()) break;
            for (String filePathInZip : zipContents.foundFileZipPaths) {
                String modName = StringUtils.stripExtension((String)filePathInZip).replace('/', '.');
                ModulesKeyForZip k = new ModulesKeyForZip(modName, zipContents.zipFile, filePathInZip, true);
                keys.put((ModulesKey)k, (ModulesKey)k);
                if (zipContents.zipContentsType != ModulesFoundStructure.ZipContents.ZIP_CONTENTS_TYPE_JAR) continue;
                for (String s : new FullRepIterable(FullRepIterable.getWithoutLastPart((String)modName))) {
                    k = new ModulesKeyForZip(s, zipContents.zipFile, s.replace('.', '/'), false);
                    keys.put((ModulesKey)k, (ModulesKey)k);
                }
            }
        }
        this.onChangePythonpath(keys);
        return keys;
    }

    protected void onChangePythonpath(SortedMap<ModulesKey, ModulesKey> keys) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemoveSingleModule(ModulesKey key) {
        Object object = this.modulesKeysLock;
        synchronized (object) {
            this.modulesKeys.remove(key);
            cache.remove(key, this);
        }
    }

    protected void removeThem(Collection<ModulesKey> toRem) {
        Iterator<ModulesKey> iter = toRem.iterator();
        while (iter.hasNext()) {
            this.doRemoveSingleModule(iter.next());
        }
    }

    public void removeModules(Collection<ModulesKey> toRem) {
        this.removeThem(toRem);
    }

    public IModule addModule(ModulesKey key) {
        AbstractModule ret = AbstractModule.createEmptyModule(key);
        this.doAddSingleModule(key, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAddSingleModule(ModulesKey key, AbstractModule n) {
        Object object = this.modulesKeysLock;
        synchronized (object) {
            this.modulesKeys.put(key, key);
            cache.add(key, n, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllModuleNames(boolean addDependencies, String partStartingWithLowerCase) {
        HashSet<String> s = new HashSet<String>();
        Object object = this.modulesKeysLock;
        synchronized (object) {
            for (ModulesKey key : this.modulesKeys.keySet()) {
                if (!key.hasPartStartingWith(partStartingWithLowerCase)) continue;
                s.add(key.name);
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap<ModulesKey, ModulesKey> getAllDirectModulesStartingWith(String strStartingWith) {
        if (strStartingWith.length() == 0) {
            Object object = this.modulesKeysLock;
            synchronized (object) {
                return new PyPublicTreeMap<ModulesKey, ModulesKey>((SortedMap<ModulesKey, ModulesKey>)this.modulesKeys);
            }
        }
        ModulesKey startingWith = new ModulesKey(strStartingWith, null);
        ModulesKey endingWith = new ModulesKey(startingWith + "z", null);
        Object object = this.modulesKeysLock;
        synchronized (object) {
            return new PyPublicTreeMap<ModulesKey, ModulesKey>(this.modulesKeys.subMap(startingWith, endingWith));
        }
    }

    public SortedMap<ModulesKey, ModulesKey> getAllModulesStartingWith(String strStartingWith) {
        return this.getAllDirectModulesStartingWith(strStartingWith);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModulesKey[] getOnlyDirectModules() {
        Object object = this.modulesKeysLock;
        synchronized (object) {
            return this.modulesKeys.keySet().toArray(new ModulesKey[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize(boolean addDependenciesSize) {
        Object object = this.modulesKeysLock;
        synchronized (object) {
            return this.modulesKeys.size();
        }
    }

    public IModule getModule(String name, IPythonNature nature, boolean dontSearchInit) {
        return this.getModule(true, name, nature, dontSearchInit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pushTemporaryModule(String moduleName, IModule module) {
        Object object = this.lockTemporaryModules;
        synchronized (object) {
            SortedMap<Integer, IModule> map = this.temporaryModules.get(moduleName);
            if (map == null) {
                map = new TreeMap<Integer, IModule>();
                this.temporaryModules.put(moduleName, map);
            }
            if (module instanceof AbstractModule) {
                module = this.decorateModule((AbstractModule)module, null);
            }
            ++this.nextHandle;
            map.put(this.nextHandle, module);
            return this.nextHandle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popTemporaryModule(String moduleName, int handle) {
        Object object = this.lockTemporaryModules;
        synchronized (object) {
            SortedMap<Integer, IModule> stack = this.temporaryModules.get(moduleName);
            try {
                if (stack != null) {
                    stack.remove(handle);
                    if (stack.size() == 0) {
                        this.temporaryModules.remove(moduleName);
                    }
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IModule getModule(boolean acceptCompiledModule, String name, IPythonNature nature, boolean dontSearchInit) {
        SourceModule sourceModule;
        SourceModule s;
        Object object = this.lockTemporaryModules;
        synchronized (object) {
            SortedMap<Integer, IModule> map = this.temporaryModules.get(name);
            if (map != null && map.size() > 0) {
                return (IModule)map.get(map.lastKey());
            }
        }
        AbstractModule n = null;
        ModulesKey keyForCacheAccess = new ModulesKey(null, null);
        if (!dontSearchInit && n == null) {
            keyForCacheAccess.name = new StringBuffer(name).append(".__init__").toString();
            n = cache.getObj(keyForCacheAccess, this);
            if (n != null) {
                name = String.valueOf(name) + ".__init__";
            }
        }
        if (n == null) {
            keyForCacheAccess.name = name;
            n = cache.getObj(keyForCacheAccess, this);
        }
        if (n instanceof SourceModule && !(s = (SourceModule)n).isSynched()) {
            n = (AbstractModule)this.addModule(this.createModulesKey(s.getName(), s.getFile()));
        }
        if (n instanceof EmptyModule) {
            EmptyModule e = (EmptyModule)n;
            boolean found = false;
            if (!found && e.f != null) {
                if (!e.f.exists()) {
                    keyForCacheAccess.name = name;
                    keyForCacheAccess.file = e.f;
                    this.doRemoveSingleModule(keyForCacheAccess);
                    n = null;
                } else if ((n = this.checkOverride(name, nature, n)) instanceof EmptyModule) {
                    if (e instanceof EmptyModuleForZip) {
                        EmptyModuleForZip emptyModuleForZip = (EmptyModuleForZip)e;
                        if (emptyModuleForZip.pathInZip.endsWith(".class") || !emptyModuleForZip.isFile) {
                            n = JythonModulesManagerUtils.createModuleFromJar(emptyModuleForZip);
                            n = this.decorateModule(n, nature);
                        } else if (FileTypesPreferencesPage.isValidDll(emptyModuleForZip.pathInZip)) {
                            n = new CompiledModule(name, this);
                            n = this.decorateModule(n, nature);
                        } else if (PythonPathHelper.isValidSourceFile(emptyModuleForZip.pathInZip)) {
                            try {
                                IDocument doc = FileUtilsFileBuffer.getDocFromZip((File)emptyModuleForZip.f, (String)emptyModuleForZip.pathInZip);
                                n = AbstractModule.createModuleFromDoc(name, emptyModuleForZip.f, doc, (IGrammarVersionProvider)this.getNature(), false);
                                SourceModule zipModule = (SourceModule)n;
                                zipModule.zipFilePath = emptyModuleForZip.pathInZip;
                                n = this.decorateModule(n, nature);
                            }
                            catch (Exception exc1) {
                                Log.log((Throwable)exc1);
                                n = null;
                            }
                        }
                    } else {
                        try {
                            n = AbstractModule.createModule(name, e.f, this.getNature(), true);
                            n = this.decorateModule(n, nature);
                        }
                        catch (IOException iOException) {
                            keyForCacheAccess.name = name;
                            keyForCacheAccess.file = e.f;
                            this.doRemoveSingleModule(keyForCacheAccess);
                            n = null;
                        }
                        catch (MisconfigurationException exc) {
                            Log.log((Throwable)exc);
                            n = null;
                        }
                    }
                }
            } else if ((n = this.checkOverride(name, nature, n)) instanceof EmptyModule) {
                if (acceptCompiledModule) {
                    n = new CompiledModule(name, this);
                    n = this.decorateModule(n, nature);
                } else {
                    return null;
                }
            }
            if (n != null) {
                this.doAddSingleModule(this.createModulesKey(name, e.f), n);
            } else {
                Log.log((String)("The module " + name + " could not be found nor created!"));
            }
        }
        if (n instanceof EmptyModule) {
            throw new RuntimeException("Should not be an empty module anymore: " + n);
        }
        if (n instanceof SourceModule && (sourceModule = (SourceModule)n).isBootstrapModule()) {
            n = new CompiledModule(name, this);
            n = this.decorateModule(n, nature);
        }
        return n;
    }

    private AbstractModule decorateModule(AbstractModule n, IPythonNature nature) {
        if (n instanceof SourceModule && "django.db.models.base".equals(n.getName())) {
            SourceModule sourceModule = (SourceModule)n;
            SimpleNode ast = sourceModule.getAst();
            stmtType[] stmtTypeArray = ((Module)ast).body;
            int n2 = ((Module)ast).body.length;
            int n3 = 0;
            while (n3 < n2) {
                stmtType node = stmtTypeArray[n3];
                if (node instanceof ClassDef && "Model".equals(NodeUtils.getRepresentationString((SimpleNode)node))) {
                    Object[][] metaclassAttrs = new Object[][]{{"objects", NodeUtils.makeAttribute((String)"django.db.models.manager.Manager()")}, {"DoesNotExist", new Name("Exception", 1, false)}, {"MultipleObjectsReturned", new Name("Exception", 1, false)}};
                    ClassDef classDef = (ClassDef)node;
                    stmtType[] newBody = new stmtType[classDef.body.length + metaclassAttrs.length];
                    System.arraycopy(classDef.body, 0, newBody, metaclassAttrs.length, classDef.body.length);
                    int i = 0;
                    Object[][] objectArrayArray = metaclassAttrs;
                    int n4 = metaclassAttrs.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        Object[] objAndType = objectArrayArray[n5];
                        Name name = new Name((String)objAndType[0], 2, false);
                        name.beginColumn = classDef.beginColumn + 4;
                        name.beginLine = classDef.beginLine + 1;
                        newBody[i] = new Assign(new exprType[]{name}, (exprType)objAndType[1]);
                        newBody[i].beginColumn = classDef.beginColumn + 4;
                        newBody[i].beginLine = classDef.beginLine + 1;
                        ++i;
                        ++n5;
                    }
                    classDef.body = newBody;
                    break;
                }
                ++n3;
            }
        }
        return n;
    }

    private AbstractModule checkOverride(String name, IPythonNature nature, AbstractModule emptyModule) {
        return emptyModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModulesKey createModulesKey(String name, File f) {
        ModulesKey newEntry = new ModulesKey(name, f);
        Object object = this.modulesKeysLock;
        synchronized (object) {
            PyPublicTreeMap.Entry<ModulesKey, ModulesKey> oldEntry = this.modulesKeys.getEntry(newEntry);
            if (oldEntry != null) {
                return oldEntry.getKey();
            }
            return newEntry;
        }
    }

    public static void clearCache() {
        cache.clear();
    }

    public boolean isInPythonPath(IResource member, IProject container) {
        return this.resolveModule(member, container) != null;
    }

    public String resolveModule(IResource member, IProject container) {
        File inOs = member.getRawLocation().toFile();
        return this.resolveModule(FileUtils.getFileAbsolutePath((File)inOs));
    }

    protected String getResolveModuleErr(IResource member) {
        return "Unable to find the path " + member + " in the project were it\n" + "is added as a source folder for pydev." + this.getClass();
    }

    public String resolveModule(String full) {
        return this.pythonPathHelper.resolveModule(full, false);
    }

    protected static class CompletionCache {
        public IModulesManager[] referencedManagers;
        public IModulesManager[] referredManagers;
        private long creationTime;
        private int calls = 0;

        protected CompletionCache() {
        }

        public IModulesManager[] getManagers(boolean referenced) {
            long diff;
            ++this.calls;
            if (this.calls % 30 == 0 && (double)(diff = System.currentTimeMillis() - this.creationTime) > 60000.0) {
                String msg = String.format("Warning: the cache related to project dependencies is the same for %.2f minutes.", (double)diff / 60000.0);
                Log.logInfo((String)msg);
            }
            if (referenced) {
                return this.referencedManagers;
            }
            return this.referredManagers;
        }

        public void setManagers(IModulesManager[] ret, boolean referenced) {
            if (this.creationTime == 0L) {
                this.creationTime = System.currentTimeMillis();
            }
            if (referenced) {
                this.referencedManagers = ret;
            } else {
                this.referredManagers = ret;
            }
        }
    }
}

