/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.model.Location;
import org.python.pydev.editorinput.PyOpenEditor;
import org.python.pydev.shared_core.io.FileUtils;

public class PyOpenAction
extends Action {
    public IEditorPart editor;

    public void showInEditor(ITextEditor textEdit, Location start, Location end) {
        try {
            IDocument doc = textEdit.getDocumentProvider().getDocument((Object)textEdit.getEditorInput());
            int s = start.toOffset(doc);
            int e = end == null ? s : end.toOffset(doc);
            TextSelection sel = new TextSelection(s, e - s);
            textEdit.getSelectionProvider().setSelection((ISelection)sel);
        }
        catch (BadLocationException e1) {
            if (textEdit instanceof PyEdit) {
                PyEdit p = (PyEdit)textEdit;
                Log.log((int)4, (String)("Error setting selection:" + start + " - " + end + " - " + p.getEditorFile()), (Throwable)e1);
            }
            Log.log((int)4, (String)("Error setting selection:" + start + " - " + end), (Throwable)e1);
        }
    }

    public void run(ItemPointer p) {
        this.editor = null;
        Object file = p.file;
        String zipFilePath = p.zipFilePath;
        if (zipFilePath != null) {
            this.editor = PyOpenEditor.doOpenEditor((File)file, zipFilePath);
        } else if (file instanceof IFile) {
            IFile f = (IFile)file;
            this.editor = PyOpenEditor.doOpenEditor(f);
        } else if (file instanceof IPath) {
            IPath path = (IPath)file;
            this.editor = PyOpenEditor.doOpenEditor(path);
        } else if (file instanceof File) {
            String absPath = FileUtils.getFileAbsolutePath((File)((File)file));
            IPath path = Path.fromOSString((String)absPath);
            this.editor = PyOpenEditor.doOpenEditor(path);
        }
        if (this.editor instanceof ITextEditor && p.start.line >= 0) {
            this.showInEditor((ITextEditor)this.editor, p.start, p.end);
        }
    }
}

