/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.lang.ref.WeakReference;
import java.util.ListResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.python.pydev.editor.ICodeScannerKeywords;
import org.python.pydev.editor.PyCodeScanner;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.shared_core.callbacks.CallbackWithListeners;
import org.python.pydev.shared_ui.editor.BaseEditor;
import org.python.pydev.shared_ui.editor.IPyEditListener;
import org.python.pydev.shared_ui.editor.IPyEditListener3;

public class PyEditBasedCodeScannerKeywords
implements ICodeScannerKeywords {
    private WeakReference<PyEdit> edit;
    private final CallbackWithListeners callbackWithListeners = new CallbackWithListeners();

    public PyEditBasedCodeScannerKeywords(PyEdit pyEdit) {
        this.edit = new WeakReference<PyEdit>(pyEdit);
        pyEdit.addPyeditListener(new CythonStatusChangeNotifier(this));
    }

    public CallbackWithListeners getOnChangeCallbackWithListeners() {
        return this.callbackWithListeners;
    }

    public String[] getKeywords() {
        PyEdit pyEdit = (PyEdit)this.edit.get();
        if (pyEdit == null) {
            return PyCodeScanner.DEFAULT_KEYWORDS;
        }
        if (pyEdit.isCythonFile()) {
            return PyCodeScanner.CYTHON_KEYWORDS;
        }
        return PyCodeScanner.DEFAULT_KEYWORDS;
    }

    private static class CythonStatusChangeNotifier
    implements IPyEditListener,
    IPyEditListener3 {
        private WeakReference<CallbackWithListeners> ref;
        private boolean currentIsCythonFile;

        public CythonStatusChangeNotifier(PyEditBasedCodeScannerKeywords pyEditBasedCodeScannerKeywords) {
            this.ref = new WeakReference<CallbackWithListeners>(pyEditBasedCodeScannerKeywords.callbackWithListeners);
            PyEdit pyEdit = (PyEdit)pyEditBasedCodeScannerKeywords.edit.get();
            this.currentIsCythonFile = pyEdit == null ? false : pyEdit.isCythonFile();
        }

        public void onInputChanged(BaseEditor baseEditor, IEditorInput oldInput, IEditorInput input, IProgressMonitor monitor) {
            PyEdit edit = (PyEdit)baseEditor;
            boolean cythonFile = edit.isCythonFile();
            if (cythonFile != this.currentIsCythonFile) {
                this.currentIsCythonFile = cythonFile;
                CallbackWithListeners callbackWithListeners = (CallbackWithListeners)this.ref.get();
                if (callbackWithListeners != null) {
                    callbackWithListeners.call(null);
                } else {
                    edit.removePyeditListener(this);
                }
            }
        }

        public void onSave(BaseEditor baseEditor, IProgressMonitor monitor) {
        }

        public void onCreateActions(ListResourceBundle resources, BaseEditor baseEditor, IProgressMonitor monitor) {
        }

        public void onDispose(BaseEditor baseEditor, IProgressMonitor monitor) {
        }

        public void onSetDocument(IDocument document, BaseEditor baseEditor, IProgressMonitor monitor) {
        }
    }
}

