/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.overview_ruler;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;
import org.python.pydev.overview_ruler.CopiedOverviewRuler;
import org.python.pydev.overview_ruler.MinimapOverviewRulerPreferencesPage;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.structure.FastStack;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public class MinimapOverviewRuler
extends CopiedOverviewRuler {
    private static final Object lockStackedParameters = new Object();
    private WeakReference<StyledText> styledText;
    private final PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            if (!MinimapOverviewRuler.this.fCanvas.isDisposed()) {
                MinimapOverviewRuler.this.redraw();
            }
        }
    };
    private volatile Image baseImage;
    private volatile Image lastImage;
    private Object[] cacheKey;
    private final RedrawJob redrawJob = new RedrawJob("Redraw overview ruler");
    MouseEvent lastMouseDown = null;

    public static String rightTrim(String input) {
        int len = input.length();
        int st = 0;
        int off = 0;
        while (st < len && input.charAt(off + len - 1) <= ' ') {
            --len;
        }
        return input.substring(0, len);
    }

    public static int getFirstCharPosition(String src) {
        int i = 0;
        boolean breaked = false;
        while (i < src.length()) {
            if (!Character.isWhitespace(src.charAt(i)) && src.charAt(i) != '\t') {
                ++i;
                breaked = true;
                break;
            }
            ++i;
        }
        if (!breaked) {
            ++i;
        }
        return i - 1;
    }

    public MinimapOverviewRuler(IAnnotationAccess annotationAccess, ISharedTextColors sharedColors) {
        super(annotationAccess, MinimapOverviewRulerPreferencesPage.getMinimapWidth(), sharedColors);
        SharedUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("MINIMAP_WIDTH".equals(event.getProperty())) {
                    MinimapOverviewRuler.this.updateWidth();
                }
            }
        });
    }

    private void updateWidth() {
        this.fWidth = MinimapOverviewRulerPreferencesPage.getMinimapWidth();
    }

    protected void doubleBufferPaint(GC dest) {
        if (this.fTextViewer != null) {
            StyledText textWidget = this.fTextViewer.getTextWidget();
            this.fCanvas.setBackground(textWidget.getBackground());
            this.fCanvas.setForeground(textWidget.getForeground());
        }
        super.doubleBufferPaint(dest);
    }

    public Control createControl(Composite parent, ITextViewer textViewer) {
        Control ret = super.createControl(parent, textViewer);
        this.fCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                MinimapOverviewRuler.this.onMouseMove(event);
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                MinimapOverviewRuler.this.onDispose();
            }
        });
        StyledText textWidget = textViewer.getTextWidget();
        if (!textWidget.isDisposed()) {
            this.styledText = new WeakReference<StyledText>(textWidget);
            textWidget.addPaintListener(this.paintListener);
        }
        return ret;
    }

    private void onMouseMove(MouseEvent event) {
        if ((event.stateMask & 0x80000) != 0) {
            this.handleDrag(event);
        }
    }

    private void onDispose() {
        try {
            StyledText textWidget;
            if (this.baseImage != null && !this.baseImage.isDisposed()) {
                this.baseImage.dispose();
                this.baseImage = null;
            }
            if (this.lastImage != null && !this.lastImage.isDisposed()) {
                this.lastImage.dispose();
                this.lastImage = null;
            }
            if (this.styledText != null && (textWidget = (StyledText)this.styledText.get()) != null && !textWidget.isDisposed()) {
                textWidget.removePaintListener(this.paintListener);
            }
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
        try {
            this.redrawJob.cancel();
            this.redrawJob.disposeStackedParameters();
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }

    protected void doPaint1(GC paintGc) {
        IDocumentExtension4 document;
        if (this.fTextViewer != null && (document = (IDocumentExtension4)this.fTextViewer.getDocument()) != null) {
            StyledText styledText = this.fTextViewer.getTextWidget();
            Point size = this.fCanvas.getSize();
            if (size.x != 0 && size.y != 0) {
                StyledTextContent styledTextContent = styledText.getContent();
                int styledLineCount = styledTextContent.getLineCount();
                ArrayList<String> content = new ArrayList<String>(styledLineCount);
                int i = 0;
                while (i < styledLineCount) {
                    try {
                        content.add(styledTextContent.getLine(i));
                    }
                    catch (Exception exception) {
                        break;
                    }
                    ++i;
                }
                int lineCount = super.getLineCount(styledText);
                IPreferenceStore preferenceStore = EditorsUI.getPreferenceStore();
                int marginCols = preferenceStore.getInt("printMarginColumn");
                String strColor = preferenceStore.getString("printMarginColor");
                RGB marginRgb = StringConverter.asRGB((String)strColor);
                Color marginColor = new Color((Device)Display.getCurrent(), marginRgb);
                Color gray = new Color((Device)Display.getCurrent(), new RGB(127, 127, 127));
                int maxChars = (int)((double)marginCols + (double)marginCols * 0.1);
                int imageHeight = lineCount * 1;
                int imageWidth = maxChars;
                Color background = styledText.getBackground();
                boolean isDark = (double)background.getRed() * 0.21 + (double)background.getGreen() * 0.71 + (double)background.getBlue() * 0.07 <= 128.0;
                Object[] currCacheKey = new Object[]{document.getModificationStamp(), size.x, size.y, styledText.getForeground(), background, marginCols, marginRgb};
                double scaleX = (double)size.x / (double)imageWidth;
                double scaleY = (double)size.y / (double)imageHeight;
                Transform transform = new Transform((Device)Display.getCurrent());
                transform.scale((float)scaleX, (float)scaleY);
                if (this.baseImage == null || !Arrays.equals(this.cacheKey, currCacheKey)) {
                    this.cacheKey = currCacheKey;
                    Image tmpImage = new Image((Device)Display.getCurrent(), size.x, size.y);
                    GC gc = new GC((Drawable)tmpImage);
                    gc.setAdvanced(true);
                    gc.setAntialias(1);
                    gc.setBackground(background);
                    gc.setForeground(background);
                    gc.fillRectangle(0, 0, size.x, size.y);
                    Color styledTextForeground = styledText.getForeground();
                    Color marginColor2 = new Color((Device)Display.getCurrent(), marginRgb);
                    this.redrawJob.cancel();
                    this.redrawJob.setParameters(gc, styledTextForeground, size, content, lineCount, marginCols, marginColor2, 1, imageHeight, transform, tmpImage);
                    this.redrawJob.schedule();
                }
                try {
                    if (this.baseImage != null && !this.baseImage.isDisposed()) {
                        if (this.lastImage != null && !this.lastImage.isDisposed()) {
                            this.lastImage.dispose();
                        }
                        Image image = new Image((Device)Display.getCurrent(), size.x, size.y);
                        GC gc2 = new GC((Drawable)image);
                        gc2.setAntialias(1);
                        try {
                            gc2.drawImage(this.baseImage, 0, 0);
                            Rectangle clientArea = styledText.getClientArea();
                            int top = styledText.getLineIndex(0);
                            int bottom = styledText.getLineIndex(clientArea.height) + 1;
                            float[] rect = new float[]{0.0f, top * 1, imageWidth, bottom * 1 - top * 1};
                            transform.transform(rect);
                            gc2.setLineWidth(3);
                            if (!isDark) {
                                gc2.setAlpha(30);
                            } else {
                                gc2.setAlpha(80);
                            }
                            gc2.setForeground(gray);
                            gc2.setBackground(gray);
                            gc2.fillRectangle(Math.round(rect[0]), Math.round(rect[1]), Math.round(rect[2]), Math.round(rect[3]));
                            gc2.drawLine(0, 0, 0, size.y);
                            gc2.setAlpha(255);
                            gc2.setLineWidth(1);
                            gc2.drawRectangle(Math.round(rect[0]), Math.round(rect[1]), Math.round(rect[2]) - 1, Math.round(rect[3]));
                        }
                        finally {
                            gc2.dispose();
                        }
                        this.lastImage = image;
                    }
                    if (this.lastImage != null && !this.lastImage.isDisposed()) {
                        paintGc.drawImage(this.lastImage, 0, 0);
                    }
                }
                finally {
                    marginColor.dispose();
                    gray.dispose();
                }
            }
        }
        super.doPaint1(paintGc);
    }

    protected void handleMouseDown(MouseEvent event) {
        this.handleDrag(event);
        this.lastMouseDown = event;
    }

    protected void handleMouseUp(MouseEvent event) {
        if (this.lastMouseDown != null) {
            int diff = Math.abs(this.lastMouseDown.x - event.x);
            if (diff > 3) {
                return;
            }
            diff = Math.abs(this.lastMouseDown.y - event.y);
            if (diff > 3) {
                return;
            }
            if (this.lastMouseDown.time - event.time < 1000) {
                super.handleMouseDown(event);
            }
        }
        this.lastMouseDown = null;
    }

    private void handleDrag(MouseEvent event) {
        if (this.fTextViewer != null) {
            int[] lines = this.toLineNumbers(event.y);
            int selectedLine = lines[0];
            Position p = null;
            try {
                IDocument document = this.fTextViewer.getDocument();
                IRegion lineInformation = document.getLineInformation(selectedLine);
                p = new Position(lineInformation.getOffset(), 0);
                if (p != null) {
                    StyledText styledText = this.fTextViewer.getTextWidget();
                    Rectangle clientArea = styledText.getClientArea();
                    int top = styledText.getLineIndex(0);
                    int bottom = styledText.getLineIndex(clientArea.height) + 1;
                    int middle = (int)((double)(bottom - top) / 2.0);
                    if (selectedLine < middle) {
                        this.fTextViewer.setTopIndex(0);
                    } else {
                        this.fTextViewer.setTopIndex(selectedLine - middle);
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
            this.fTextViewer.getTextWidget().setFocus();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RedrawJob
    extends Job {
        private FastStack<Object[]> stackedParameters;

        private RedrawJob(String name) {
            super(name);
            this.stackedParameters = new FastStack(20);
            this.setPriority(20);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setParameters(GC gc, Color styledTextForeground, Point size, List<String> content, int lineCount, int marginCols, Color marginColor, int spacing, int imageHeight, Transform transform, Image tmpImage) {
            Object object = lockStackedParameters;
            synchronized (object) {
                this.stackedParameters.push((Object)new Object[]{gc, styledTextForeground, size, content, lineCount, marginCols, marginColor, spacing, imageHeight, transform, tmpImage});
            }
        }

        private void redrawBaseImage(GC gc, Color styledTextForeground, Point size, List<String> content, int lineCount, int marginCols, Color marginColor, int spacing, int imageHeight, Transform transform, IProgressMonitor monitor) {
            if (MinimapOverviewRulerPreferencesPage.getShowMinimapContents()) {
                gc.setForeground(styledTextForeground);
                gc.setAlpha(200);
                gc.setTransform(transform);
                int x1 = 0;
                int y1 = 0;
                int x2 = 0;
                int y2 = 0;
                int mergeLevels = (int)((double)lineCount / 200.0);
                int nextDrawMax = -1;
                int nextDrawMin = Integer.MAX_VALUE;
                int i = 0;
                while (i < lineCount) {
                    String line;
                    if (monitor.isCanceled()) {
                        return;
                    }
                    try {
                        line = MinimapOverviewRuler.rightTrim(content.get(i));
                    }
                    catch (Exception exception) {
                        break;
                    }
                    x1 = MinimapOverviewRuler.getFirstCharPosition(line);
                    x2 = line.length();
                    if (mergeLevels > 0) {
                        if (x2 > nextDrawMax) {
                            nextDrawMax = x2;
                        }
                        if (x1 < nextDrawMax) {
                            nextDrawMin = x1;
                        }
                        if (i % mergeLevels == 0) {
                            if (nextDrawMax > 0 && nextDrawMin < nextDrawMax) {
                                gc.drawLine(nextDrawMin, y1, nextDrawMax, y2);
                            }
                            nextDrawMax = -1;
                            nextDrawMin = Integer.MAX_VALUE;
                        }
                    } else if (x2 > 0) {
                        gc.drawLine(x1, y1, x2, y2);
                    }
                    y1 = y2 = y1 + spacing;
                    ++i;
                }
                if (monitor.isCanceled()) {
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Image image;
            block16: {
                Object[] parameters;
                Object object = lockStackedParameters;
                synchronized (object) {
                    parameters = (Object[])this.stackedParameters.pop();
                    this.disposeStackedParameters();
                }
                GC gc = (GC)parameters[0];
                if (gc.isDisposed()) {
                    return Status.OK_STATUS;
                }
                Color styledTextForeground = (Color)parameters[1];
                Point size = (Point)parameters[2];
                List content = (List)parameters[3];
                int lineCount = (Integer)parameters[4];
                int marginCols = (Integer)parameters[5];
                Color marginColor = (Color)parameters[6];
                if (marginColor.isDisposed()) {
                    return Status.OK_STATUS;
                }
                int spacing = (Integer)parameters[7];
                int imageHeight = (Integer)parameters[8];
                Transform transform = (Transform)parameters[9];
                image = (Image)parameters[10];
                if (image.isDisposed()) {
                    return Status.OK_STATUS;
                }
                try {
                    try {
                        this.redrawBaseImage(gc, styledTextForeground, size, content, lineCount, marginCols, marginColor, spacing, imageHeight, transform, monitor);
                    }
                    catch (Throwable e) {
                        Log.log((Throwable)e);
                        gc.dispose();
                        marginColor.dispose();
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    gc.dispose();
                    marginColor.dispose();
                    throw throwable;
                }
                gc.dispose();
                marginColor.dispose();
            }
            boolean disposeOfImage = true;
            try {
                Canvas c;
                if (!monitor.isCanceled() && (c = MinimapOverviewRuler.this.fCanvas) != null && !c.isDisposed()) {
                    disposeOfImage = false;
                    RunInUiThread.async(new Runnable(){

                        public void run() {
                            if (MinimapOverviewRuler.this.baseImage != null && !MinimapOverviewRuler.this.baseImage.isDisposed()) {
                                MinimapOverviewRuler.this.baseImage.dispose();
                            }
                            if (c != null && !c.isDisposed()) {
                                MinimapOverviewRuler.this.baseImage = image;
                                MinimapOverviewRuler.this.redraw();
                            } else {
                                image.dispose();
                            }
                        }
                    });
                }
            }
            finally {
                if (disposeOfImage) {
                    image.dispose();
                }
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disposeStackedParameters() {
            Object object = lockStackedParameters;
            synchronized (object) {
                while (this.stackedParameters.size() > 0) {
                    Object[] disposeOfParameters = (Object[])this.stackedParameters.pop();
                    GC gc = (GC)disposeOfParameters[0];
                    Color marginColor = (Color)disposeOfParameters[6];
                    Transform transform = (Transform)disposeOfParameters[9];
                    gc.dispose();
                    marginColor.dispose();
                    transform.dispose();
                }
            }
        }
    }
}

