/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_interactive_console.console.ui.internal;

import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_interactive_console.console.ScriptConsoleHistory;
import org.python.pydev.shared_interactive_console.console.codegen.IScriptConsoleCodeGenerator;
import org.python.pydev.shared_interactive_console.console.codegen.PythonSnippetUtils;
import org.python.pydev.shared_interactive_console.console.codegen.SafeScriptConsoleCodeGenerator;
import org.python.pydev.shared_interactive_console.console.ui.IConsoleStyleProvider;
import org.python.pydev.shared_interactive_console.console.ui.IScriptConsoleViewer;
import org.python.pydev.shared_interactive_console.console.ui.ScriptConsole;
import org.python.pydev.shared_interactive_console.console.ui.internal.ClipboardHandler;
import org.python.pydev.shared_interactive_console.console.ui.internal.IHandleScriptAutoEditStrategy;
import org.python.pydev.shared_interactive_console.console.ui.internal.IScriptConsoleContentHandler;
import org.python.pydev.shared_interactive_console.console.ui.internal.IScriptConsoleViewer2ForDocumentListener;
import org.python.pydev.shared_interactive_console.console.ui.internal.ScriptConsoleDocumentListener;
import org.python.pydev.shared_interactive_console.console.ui.internal.ScriptConsoleHistorySelector;
import org.python.pydev.shared_interactive_console.console.ui.internal.actions.AbstractHandleBackspaceAction;
import org.python.pydev.shared_interactive_console.console.ui.internal.actions.HandleDeletePreviousWord;
import org.python.pydev.shared_interactive_console.console.ui.internal.actions.HandleLineStartAction;
import org.python.pydev.shared_ui.bindings.KeyBindingHelper;

public class ScriptConsoleViewer
extends TextConsoleViewer
implements IScriptConsoleViewer,
IScriptConsoleViewer2ForDocumentListener {
    private boolean inCompletion = false;
    private ScriptConsoleHistory history;
    private ScriptConsoleDocumentListener listener;
    IConsoleStyleProvider styleProvider;
    protected ScriptConsole console;
    private boolean isMainViewer;
    volatile int inHistoryRequests = 0;
    volatile boolean changedAfterLastHistoryRequest = false;
    private final boolean focusOnStart;
    private AbstractHandleBackspaceAction handleBackspaceAction;

    public IConsoleStyleProvider getStyleProvider() {
        return this.styleProvider;
    }

    public int getCaretOffset() {
        return this.getTextWidget().getCaretOffset();
    }

    public Object getInterpreterInfo() {
        return this.console.getInterpreterInfo();
    }

    public void setCaretOffset(final int offset, boolean async) {
        final StyledText textWidget = this.getTextWidget();
        if (textWidget != null) {
            if (async) {
                Display display = textWidget.getDisplay();
                if (display != null) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            textWidget.setCaretOffset(offset);
                        }
                    });
                }
            } else {
                textWidget.setCaretOffset(offset);
            }
        }
    }

    protected boolean isSelectedRangeEditable() {
        Point range = this.getSelectedRange();
        int commandLineOffset = this.getCommandLineOffset();
        if (range.x < commandLineOffset) {
            return false;
        }
        return range.x + range.y >= commandLineOffset;
    }

    protected boolean isCaretInLastLine() throws BadLocationException {
        return this.getTextWidget().getCaretOffset() >= this.listener.getLastLineOffset();
    }

    protected boolean isCaretInEditableRange() {
        return this.getTextWidget().getCaretOffset() >= this.getCommandLineOffset();
    }

    protected StyledText createTextWidget(Composite parent, int styles) {
        return new ScriptConsoleStyledText(parent, styles);
    }

    public ScriptConsoleViewer(Composite parent, ScriptConsole console, final IScriptConsoleContentHandler contentHandler, IConsoleStyleProvider styleProvider, String initialCommands, boolean focusOnStart, AbstractHandleBackspaceAction handleBackspaceAction, IHandleScriptAutoEditStrategy strategy) {
        super(parent, (TextConsole)console);
        this.handleBackspaceAction = handleBackspaceAction;
        this.focusOnStart = focusOnStart;
        this.console = console;
        this.getTextWidget().setBackground(console.getPydevConsoleBackground());
        ScriptConsoleViewer existingViewer = this.console.getViewer();
        if (existingViewer == null) {
            this.isMainViewer = true;
            this.console.setViewer(this);
            this.styleProvider = styleProvider;
            this.history = console.getHistory();
            this.listener = new ScriptConsoleDocumentListener(this, console, console.getPrompt(), console.getHistory(), console.getLineTrackers(), initialCommands, strategy);
            this.listener.setDocument(this.getDocument());
        } else {
            this.isMainViewer = false;
            this.styleProvider = existingViewer.styleProvider;
            this.history = existingViewer.history;
            this.listener = existingViewer.listener;
            this.listener.addViewer(this);
        }
        final StyledText styledText = this.getTextWidget();
        styledText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    e.doit = false;
                }
            }
        });
        this.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (ScriptConsoleViewer.this.inHistoryRequests == 0) {
                    ScriptConsoleViewer.this.changedAfterLastHistoryRequest = true;
                }
            }
        });
        styledText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ScriptConsoleViewer.this.setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength(), true);
                styledText.removeFocusListener((FocusListener)this);
            }

            public void focusLost(FocusEvent e) {
            }
        });
        styledText.addVerifyKeyListener((VerifyKeyListener)new KeyChecker());
        styledText.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (KeyBindingHelper.matchesContentAssistKeybinding((KeyEvent)event) || KeyBindingHelper.matchesQuickAssistKeybinding((KeyEvent)event)) {
                    event.doit = false;
                    return;
                }
            }
        });
        styledText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (ScriptConsoleViewer.this.getCaretOffset() >= ScriptConsoleViewer.this.getCommandLineOffset()) {
                    if (KeyBindingHelper.matchesContentAssistKeybinding((KeyEvent)e)) {
                        contentHandler.contentAssistRequired();
                    } else if (KeyBindingHelper.matchesQuickAssistKeybinding((KeyEvent)e)) {
                        contentHandler.quickAssistRequired();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public ScriptConsole getConsole() {
        return this.console;
    }

    public void configure(SourceViewerConfiguration configuration) {
        super.configure(configuration);
        ICompletionListener completionListener = new ICompletionListener(){

            public void assistSessionStarted(ContentAssistEvent event) {
                ScriptConsoleViewer.this.inCompletion = true;
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                ScriptConsoleViewer.this.inCompletion = false;
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }
        };
        if (this.fContentAssistant != null) {
            ((IContentAssistantExtension2)this.fContentAssistant).addCompletionListener(completionListener);
        }
        if (this.fQuickAssistAssistant != null) {
            this.fQuickAssistAssistant.addCompletionListener(completionListener);
        }
        if (this.isMainViewer) {
            this.clear(true);
        }
        if (this.focusOnStart) {
            this.getTextWidget().setFocus();
        }
    }

    public String getCommandLine() {
        return this.listener.getCommandLine();
    }

    public int getCommandLineOffset() {
        try {
            return this.listener.getCommandLineOffset();
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public int getLastLineOffset() {
        try {
            return this.listener.getLastLineOffset();
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public void clear(boolean addInitialCommands) {
        this.listener.clear(addInitialCommands);
    }

    public long getLastChangeMillis() {
        return this.listener.getLastChangeMillis();
    }

    public void revealEndOfDocument() {
        super.revealEndOfDocument();
    }

    private final class KeyChecker
    implements VerifyKeyListener {
        private Method fHideMethod;

        private KeyChecker() {
        }

        private Method getHideMethod() {
            if (this.fHideMethod == null) {
                try {
                    this.fHideMethod = ScriptConsoleViewer.this.fContentAssistant.getClass().getDeclaredMethod("hide", new Class[0]);
                    this.fHideMethod.setAccessible(true);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
            return this.fHideMethod;
        }

        public void verifyKey(VerifyEvent event) {
            try {
                if (event.character != '\u0000') {
                    if ((Character.isLetter(event.character) && (event.stateMask == 0 || (event.stateMask & 0x20000) != 0) || Character.isWhitespace(event.character)) && !ScriptConsoleViewer.this.isSelectedRangeEditable()) {
                        ScriptConsoleViewer.this.getTextWidget().setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength());
                    }
                    if (!ScriptConsoleViewer.this.isSelectedRangeEditable()) {
                        event.doit = false;
                        return;
                    }
                    if (event.character == '\r' || event.character == '\n') {
                        Method hideMethod;
                        if (ScriptConsoleViewer.this.inCompletion && (event.stateMask & 0x20000) != 0 && (hideMethod = this.getHideMethod()) != null) {
                            hideMethod.invoke((Object)ScriptConsoleViewer.this.fContentAssistant, new Object[0]);
                        }
                        if (!ScriptConsoleViewer.this.inCompletion) {
                            ScriptConsoleViewer.this.getTextWidget().setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength());
                        }
                        return;
                    }
                    if (event.character == '\u001b') {
                        if (!ScriptConsoleViewer.this.inCompletion) {
                            ScriptConsoleViewer.this.listener.setCommandLine("");
                        }
                        return;
                    }
                } else if (ScriptConsoleViewer.this.isCaretInEditableRange() && !ScriptConsoleViewer.this.inCompletion && event.keyCode == 0x1000005) {
                    event.doit = false;
                    List<String> commands = ScriptConsoleViewer.this.history.getAsList();
                    List<String> commandsToExecute = ScriptConsoleHistorySelector.select(commands);
                    if (commandsToExecute != null) {
                        ScriptConsoleViewer.this.listener.setCommandLine("");
                        IDocument d = ScriptConsoleViewer.this.getDocument();
                        d.replace(d.getLength(), 0, String.valueOf(StringUtils.join((String)"\n", commandsToExecute)) + "\n");
                    }
                    return;
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    private class ScriptConsoleStyledText
    extends StyledText {
        private HandleDeletePreviousWord handleDeletePreviousWord;
        private HandleLineStartAction handleLineStartAction;
        private volatile int internalCaretSet;
        private boolean thisConsoleInitiatedDrag;

        public ScriptConsoleStyledText(Composite parent, int style) {
            super(parent, style);
            this.internalCaretSet = -1;
            this.thisConsoleInitiatedDrag = false;
            this.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    ScriptConsoleStyledText.this.internalCaretSet = -1;
                }
            });
            this.addExtendedModifyListener(new ExtendedModifyListener(){

                public void modifyText(ExtendedModifyEvent event) {
                    if (ScriptConsoleStyledText.this.internalCaretSet != -1) {
                        if (ScriptConsoleStyledText.this.internalCaretSet != ScriptConsoleStyledText.this.getCaretOffset()) {
                            ScriptConsoleStyledText.this.setCaretOffset(ScriptConsoleStyledText.this.internalCaretSet);
                        }
                        ScriptConsoleStyledText.this.internalCaretSet = -1;
                    }
                }
            });
            this.initDragDrop();
            this.handleDeletePreviousWord = new HandleDeletePreviousWord();
            this.handleLineStartAction = new HandleLineStartAction();
        }

        private void initDragDrop() {
            DragSource dragSource = new DragSource((Control)this, 3);
            dragSource.addDragListener((DragSourceListener)new DragSourceAdapter());
            dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
            DropTarget dropTarget = new DropTarget((Control)this, 3);
            dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance()});
            dropTarget.addDropListener((DropTargetListener)new DragTargetAdapter());
        }

        public void setCaretOffset(int offset) {
            this.internalCaretSet = offset;
            super.setCaretOffset(offset);
        }

        public void invokeAction(int action) {
            switch (action) {
                case 0x1000007: {
                    if (this.handleLineStartAction.execute(ScriptConsoleViewer.this.getDocument(), this.getCaretOffset(), ScriptConsoleViewer.this.getCommandLineOffset(), ScriptConsoleViewer.this)) {
                        return;
                    }
                    super.invokeAction(action);
                }
            }
            if (ScriptConsoleViewer.this.isSelectedRangeEditable()) {
                block19: {
                    try {
                        boolean didChange;
                        int historyChange = 0;
                        switch (action) {
                            case 0x1000001: {
                                historyChange = 1;
                                break;
                            }
                            case 0x1000002: {
                                historyChange = 2;
                                break;
                            }
                            case 8: {
                                ScriptConsoleViewer.this.handleBackspaceAction.execute(ScriptConsoleViewer.this.getDocument(), (ITextSelection)ScriptConsoleViewer.this.getSelection(), ScriptConsoleViewer.this.getCommandLineOffset());
                                return;
                            }
                            case 262152: {
                                this.handleDeletePreviousWord.execute(ScriptConsoleViewer.this.getDocument(), this.getCaretOffset(), ScriptConsoleViewer.this.getCommandLineOffset());
                                return;
                            }
                        }
                        if (historyChange == 0) break block19;
                        if (ScriptConsoleViewer.this.changedAfterLastHistoryRequest) {
                            ScriptConsoleViewer.this.history.setMatchStart(ScriptConsoleViewer.this.getCommandLine());
                        }
                        if (didChange = historyChange == 1 ? ScriptConsoleViewer.this.history.prev() : ScriptConsoleViewer.this.history.next()) {
                            ++ScriptConsoleViewer.this.inHistoryRequests;
                            try {
                                ScriptConsoleViewer.this.listener.setCommandLine(ScriptConsoleViewer.this.history.get());
                                this.setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength());
                            }
                            finally {
                                --ScriptConsoleViewer.this.inHistoryRequests;
                            }
                        }
                        ScriptConsoleViewer.this.changedAfterLastHistoryRequest = false;
                        return;
                    }
                    catch (BadLocationException e) {
                        Log.log((Throwable)e);
                        return;
                    }
                }
                super.invokeAction(action);
            } else {
                super.invokeAction(action);
            }
        }

        public void cut() {
            this.changeSelectionToEditableRange();
            super.cut();
        }

        public void paste() {
            this.changeSelectionToEditableRange();
            super.paste();
        }

        public void copy() {
            this.copy(1);
        }

        public void copy(int clipboardType) {
            this.checkWidget();
            Point selectedRange = ScriptConsoleViewer.this.getSelectedRange();
            if (selectedRange.y > 0) {
                IDocument doc = ScriptConsoleViewer.this.getDocument();
                new ClipboardHandler().putIntoClipboard(doc, selectedRange, clipboardType, this.getDisplay());
            }
        }

        protected void changeSelectionToEditableRange() {
            Point range = ScriptConsoleViewer.this.getSelectedRange();
            int commandLineOffset = ScriptConsoleViewer.this.getCommandLineOffset();
            int minOffset = range.x;
            int maxOffset = range.x + range.y;
            boolean changed = false;
            boolean goToEnd = false;
            if (minOffset < commandLineOffset) {
                minOffset = commandLineOffset;
                changed = true;
            }
            if (maxOffset < commandLineOffset) {
                maxOffset = commandLineOffset;
                changed = true;
                goToEnd = true;
            }
            if (changed) {
                ScriptConsoleViewer.this.setSelectedRange(minOffset, maxOffset - minOffset);
            }
            if (goToEnd) {
                this.setCaretOffset(ScriptConsoleViewer.this.getDocument().getLength());
            }
        }

        private final class DragSourceAdapter
        implements DragSourceListener {
            private Point selection;
            private String selectionText = null;
            private boolean selectionIsEditable;

            private DragSourceAdapter() {
            }

            public void dragStart(DragSourceEvent event) {
                String temp_selection;
                ScriptConsoleStyledText.this.thisConsoleInitiatedDrag = false;
                this.selectionText = null;
                event.doit = false;
                if (((ScriptConsoleStyledText)ScriptConsoleStyledText.this).ScriptConsoleViewer.this.getSelectedRange().y > 0 && (temp_selection = new ClipboardHandler().getPlainText(ScriptConsoleViewer.this.getDocument(), ScriptConsoleViewer.this.getSelectedRange())) != null && temp_selection.length() > 0) {
                    event.doit = true;
                    this.selectionText = temp_selection;
                    this.selection = ScriptConsoleStyledText.this.getSelection();
                    this.selectionIsEditable = ScriptConsoleViewer.this.isSelectedRangeEditable();
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = this.selectionText;
                    ScriptConsoleStyledText.this.thisConsoleInitiatedDrag = true;
                }
            }

            public void dragFinished(DragSourceEvent event) {
                try {
                    if (event.detail == 2 && this.selectionIsEditable) {
                        Point newSelection = ScriptConsoleStyledText.this.getSelection();
                        int length = this.selection.y - this.selection.x;
                        int delta = 0;
                        if (newSelection.x < this.selection.x) {
                            delta = length;
                        }
                        ScriptConsoleStyledText.this.replaceTextRange(this.selection.x + delta, length, "");
                    }
                }
                finally {
                    ScriptConsoleStyledText.this.thisConsoleInitiatedDrag = false;
                }
            }
        }

        private final class DragTargetAdapter
        implements DropTargetListener {
            private DragTargetAdapter() {
            }

            private SafeScriptConsoleCodeGenerator getSafeGenerator() {
                ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                IScriptConsoleCodeGenerator codeGenerator = PythonSnippetUtils.getScriptConsoleCodeGeneratorAdapter(selection);
                return new SafeScriptConsoleCodeGenerator(codeGenerator);
            }

            private boolean forceDropNone(DropTargetEvent event) {
                SafeScriptConsoleCodeGenerator codeGenerator;
                return LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) && ((codeGenerator = this.getSafeGenerator()) == null || !codeGenerator.hasPyCode());
            }

            private void adjustEventDetail(DropTargetEvent event) {
                event.detail = this.forceDropNone(event) ? 0 : (!ScriptConsoleStyledText.this.thisConsoleInitiatedDrag && (event.operations & 1) != 0 ? 1 : ((event.operations & 2) != 0 ? 2 : ((event.operations & 1) != 0 ? 1 : 0)));
            }

            public void dragEnter(DropTargetEvent event) {
                ScriptConsoleStyledText.this.thisConsoleInitiatedDrag = false;
                this.adjustEventDetail(event);
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback |= 8;
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.adjustEventDetail(event);
            }

            public void dropAccept(DropTargetEvent event) {
                this.adjustEventDetail(event);
            }

            public void drop(DropTargetEvent event) {
                SafeScriptConsoleCodeGenerator codeGenerator;
                if (event.operations == 0) {
                    return;
                }
                String text = null;
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    text = (String)event.data;
                } else if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) && (codeGenerator = this.getSafeGenerator()) != null) {
                    text = codeGenerator.getPyCode();
                }
                if (text != null && text.length() > 0) {
                    Point selectedRange = ScriptConsoleViewer.this.getSelectedRange();
                    if (selectedRange.x < ScriptConsoleViewer.this.getLastLineOffset()) {
                        ScriptConsoleStyledText.this.changeSelectionToEditableRange();
                    } else {
                        int commandLineOffset = ScriptConsoleViewer.this.getCommandLineOffset();
                        if (selectedRange.x < commandLineOffset) {
                            ScriptConsoleViewer.this.setSelectedRange(commandLineOffset, 0);
                        }
                    }
                    Point newSelection = ScriptConsoleStyledText.this.getSelection();
                    try {
                        ScriptConsoleViewer.this.getDocument().replace(newSelection.x, 0, text);
                    }
                    catch (BadLocationException badLocationException) {
                        return;
                    }
                    ScriptConsoleStyledText.this.setSelectionRange(newSelection.x, text.length());
                    ScriptConsoleStyledText.this.changeSelectionToEditableRange();
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }
        }
    }
}

