/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.interactiveconsole;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ListResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.newconsole.PydevConsole;
import org.python.pydev.debug.newconsole.PydevConsoleFactory;
import org.python.pydev.debug.newconsole.prefs.InteractiveConsolePrefs;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.shared_interactive_console.console.codegen.PythonSnippetUtils;
import org.python.pydev.shared_interactive_console.console.ui.ScriptConsole;
import org.python.pydev.shared_interactive_console.console.ui.internal.ScriptConsoleViewer;
import org.python.pydev.shared_ui.editor.BaseEditor;
import org.python.pydev.shared_ui.editor.IPyEditListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluateActionSetter
implements IPyEditListener {
    private static void sendCommandToConsole(PySelection selection, ScriptConsole console, PyEdit edit) throws BadLocationException {
        PydevConsole pydevConsole = (PydevConsole)console;
        IDocument document = pydevConsole.getDocument();
        String cmd = EvaluateActionSetter.getCommandToSend(edit, selection);
        if (cmd != null) {
            document.replace(document.getLength(), 0, cmd);
        }
        if (InteractiveConsolePrefs.getFocusConsoleOnSendCommand()) {
            ScriptConsoleViewer viewer = pydevConsole.getViewer();
            if (viewer == null) {
                return;
            }
            StyledText textWidget = viewer.getTextWidget();
            if (textWidget == null) {
                return;
            }
            textWidget.setFocus();
        }
    }

    private static String getCommandToSend(PyEdit edit, PySelection selection) {
        String cmd = null;
        String code = selection.getTextSelection().getText();
        if (code.length() != 0) {
            cmd = String.valueOf(code) + "\n";
        } else {
            File editorFile = edit.getEditorFile();
            if (editorFile != null) {
                cmd = PythonSnippetUtils.getExecfileCommand((File)editorFile);
            }
        }
        return cmd;
    }

    private ScriptConsole getActiveScriptConsole(String consoleType) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            List<IViewPart> consoleParts = this.getConsoleParts(page, false);
            if (consoleParts.size() == 0) {
                consoleParts = this.getConsoleParts(page, true);
            }
            if (consoleParts.size() > 0) {
                IConsole console;
                IConsoleView view = null;
                long lastChangeMillis = Long.MIN_VALUE;
                if (consoleParts.size() == 1) {
                    view = (IConsoleView)consoleParts.get(0);
                } else {
                    int i = 0;
                    while (i < consoleParts.size()) {
                        PydevConsole tempConsole;
                        ScriptConsoleViewer viewer;
                        long tempLastChangeMillis;
                        IConsoleView temp = (IConsoleView)consoleParts.get(i);
                        IConsole console2 = temp.getConsole();
                        if (console2 instanceof PydevConsole && (tempLastChangeMillis = (viewer = (tempConsole = (PydevConsole)console2).getViewer()).getLastChangeMillis()) > lastChangeMillis) {
                            lastChangeMillis = tempLastChangeMillis;
                            view = temp;
                        }
                        ++i;
                    }
                }
                if (view != null && (console = view.getConsole()) instanceof ScriptConsole && console.getType().equals(consoleType)) {
                    return (ScriptConsole)console;
                }
            }
        }
        return null;
    }

    private List<IViewPart> getConsoleParts(IWorkbenchPage page, boolean restore) {
        IViewReference[] viewReferences;
        ArrayList<IViewPart> consoleParts = new ArrayList<IViewPart>();
        IViewReference[] iViewReferenceArray = viewReferences = page.getViewReferences();
        int n = viewReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IViewPart part;
            IViewReference ref = iViewReferenceArray[n2];
            if (ref.getId().equals("org.eclipse.ui.console.ConsoleView") && (part = ref.getView(restore)) != null) {
                consoleParts.add(part);
                if (restore) {
                    return consoleParts;
                }
            }
            ++n2;
        }
        return consoleParts;
    }

    public void onCreateActions(ListResourceBundle resources, BaseEditor baseEditor, IProgressMonitor monitor) {
        final PyEdit edit = (PyEdit)baseEditor;
        final EvaluateAction evaluateAction = new EvaluateAction(edit);
        evaluateAction.setActionDefinitionId("org.python.pydev.interactiveconsole.evaluateActionSetter");
        evaluateAction.setId("org.python.pydev.interactiveconsole.evaluateActionSetter");
        Runnable runnable = new Runnable(){

            public void run() {
                if (!edit.isDisposed()) {
                    edit.setAction("org.python.pydev.interactiveconsole.evaluateActionSetter", (IAction)evaluateAction);
                }
            }
        };
        Display.getDefault().syncExec(runnable);
    }

    public void onSave(BaseEditor baseEditor, IProgressMonitor monitor) {
    }

    public void onDispose(BaseEditor baseEditor, IProgressMonitor monitor) {
    }

    public void onSetDocument(IDocument document, BaseEditor baseEditor, IProgressMonitor monitor) {
    }

    private class EvaluateAction
    extends Action {
        private final PyEdit edit;

        private EvaluateAction(PyEdit edit) {
            this.edit = edit;
        }

        public void run() {
            try {
                PySelection selection = new PySelection((ITextEditor)this.edit);
                ScriptConsole console = EvaluateActionSetter.this.getActiveScriptConsole("org.python.pydev.debug.newconsole.PydevConsole");
                if (console == null) {
                    PydevConsoleFactory factory = new PydevConsoleFactory();
                    String cmd = null;
                    if (InteractiveConsolePrefs.getSendCommandOnCreationFromEditor() && (cmd = EvaluateActionSetter.getCommandToSend(this.edit, selection)) != null) {
                        cmd = "\n" + cmd;
                    }
                    factory.createConsole(cmd);
                } else if (console instanceof PydevConsole) {
                    EvaluateActionSetter.sendCommandToConsole(selection, console, this.edit);
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }
}

