/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.shared_core.net.SocketUtil;

public class ListenConnector
implements Runnable {
    protected int timeout;
    protected ServerSocket serverSocket;
    protected Socket socket;
    protected Exception e;

    public ListenConnector(int timeout) throws IOException {
        this.timeout = timeout;
        try {
            this.serverSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            Log.log((String)"Error when creating server socket.", (Throwable)e);
            throw e;
        }
    }

    Exception getException() {
        return this.e;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void stopListening() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                PydevDebugPlugin.log(2, "Error closing pydevd socket", e);
            }
            this.serverSocket = null;
        }
    }

    public void run() {
        try {
            this.serverSocket.setSoTimeout(this.timeout);
            this.socket = this.serverSocket.accept();
        }
        catch (IOException e) {
            this.e = e;
        }
    }

    public int getLocalPort() throws IOException {
        int localPort = this.serverSocket.getLocalPort();
        SocketUtil.checkValidPort((int)localPort);
        return localPort;
    }

    protected void finalize() throws Throwable {
        try {
            this.stopListening();
        }
        catch (Throwable e) {
            PydevDebugPlugin.log(2, "Error finalizing ListenConnector", e);
        }
    }
}

