/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.codecoverage;

import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.python.pydev.debug.core.PydevDebugPlugin;

public class PyCoveragePreferences {
    private static boolean internalAllRunsDoCoverage = false;
    private static boolean clearCoverageInfoOnNextLaunch = true;
    private static boolean refreshAfterNextLaunch = true;
    private static IContainer lastChosenDir;
    private static int DEFAULT_NUMBER_OF_COLUMNS_FOR_NAME;

    static {
        DEFAULT_NUMBER_OF_COLUMNS_FOR_NAME = 40;
    }

    public static boolean getAllRunsDoCoverage() {
        return PyCoveragePreferences.getInternalAllRunsDoCoverage() && lastChosenDir != null && lastChosenDir.exists();
    }

    static boolean getInternalAllRunsDoCoverage() {
        return internalAllRunsDoCoverage;
    }

    static void setInternalAllRunsDoCoverage(boolean selection) {
        internalAllRunsDoCoverage = selection;
    }

    static void setRefreshAfterNextLaunch(boolean selection) {
        refreshAfterNextLaunch = selection;
    }

    public static boolean getRefreshAfterNextLaunch() {
        return refreshAfterNextLaunch;
    }

    static void setClearCoverageInfoOnNextLaunch(boolean selection) {
        clearCoverageInfoOnNextLaunch = selection;
    }

    public static boolean getClearCoverageInfoOnNextLaunch() {
        return clearCoverageInfoOnNextLaunch;
    }

    static void setLastChosenDir(IContainer container) {
        lastChosenDir = container;
    }

    public static IContainer getLastChosenDir() {
        return lastChosenDir;
    }

    public static void setNameNumberOfColumns(int columns) {
        IPreferenceStore preferenceStore = PydevDebugPlugin.getDefault().getPreferenceStore();
        preferenceStore.setValue("PY_COVERAGE_NAME_COLUMNS_TO_USE", columns);
    }

    public static int getNameNumberOfColumns() {
        PydevDebugPlugin plugin = PydevDebugPlugin.getDefault();
        if (plugin == null) {
            return DEFAULT_NUMBER_OF_COLUMNS_FOR_NAME;
        }
        IPreferenceStore preferenceStore = plugin.getPreferenceStore();
        int i = preferenceStore.getInt("PY_COVERAGE_NAME_COLUMNS_TO_USE");
        if (i <= 5) {
            return DEFAULT_NUMBER_OF_COLUMNS_FOR_NAME;
        }
        if (i > 256) {
            i = 256;
        }
        return i;
    }
}

