/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.structure;

import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.python.pydev.core.structure.FastStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FastStack<E>
implements Iterable<E> {
    private E[] elementData;
    private int size;

    public FastStack(int initialCapacity) {
        this.elementData = new Object[initialCapacity];
    }

    public E push(E item) {
        if (this.elementData.length < this.size + 1) {
            this.ensureCapacity(this.size + 1);
        }
        this.elementData[this.size] = item;
        ++this.size;
        return item;
    }

    public E pop() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        --this.size;
        E item = this.elementData[this.size];
        this.elementData[this.size] = null;
        return item;
    }

    public E peek() {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.elementData[this.size - 1];
    }

    public boolean empty() {
        return this.size == 0;
    }

    public Iterator<E> topDownIterator() {
        final ListItr l = new ListItr(this.size);
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return l.hasPrevious();
            }

            @Override
            public E next() {
                return l.previous();
            }

            @Override
            public void remove() {
                throw new RuntimeException("Not Impl");
            }
        };
    }

    public int size() {
        return this.size;
    }

    @Override
    public ListIterator<E> iterator() {
        return new ListItr(0);
    }

    public E get(int i) {
        if (i >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.elementData[i];
    }

    public void addAll(FastStack<? extends E> items) {
        this.ensureCapacity(this.size + items.size);
        System.arraycopy(items.elementData, 0, this.elementData, this.size, items.size);
        this.size += items.size;
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            E[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public E getFirst() {
        return this.elementData[0];
    }

    public FastStack<E> createCopy() {
        FastStack<E> ret = new FastStack<E>(this.size + 15);
        System.arraycopy(this.elementData, 0, ret.elementData, 0, this.size);
        ret.size = this.size;
        return ret;
    }

    public void clear() {
        this.size = 0;
    }

    public void removeAllElements() {
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public String toString() {
        FastStringBuffer buf = new FastStringBuffer("FastStack [\n", 25 * this.size);
        for (Object element : this) {
            buf.append("    ");
            buf.append(element.toString());
            buf.append("\n");
        }
        buf.append("]");
        return buf.toString();
    }

    public int hashCode() {
        throw new RuntimeException("Not hashable");
    }

    public boolean equals(Object o) {
        throw new RuntimeException("Not comparable");
    }

    public E peek(int i) {
        return this.elementData[this.size - 1 - i];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListItr
    implements ListIterator<E> {
        int cursor = 0;
        int lastRet = -1;

        @Override
        public boolean hasNext() {
            return this.cursor != FastStack.this.size();
        }

        @Override
        public E next() {
            try {
                Object next = FastStack.this.get(this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not implemented");
        }

        @Override
        public void add(E o) {
            throw new RuntimeException("Not implemented");
        }

        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            try {
                int i = this.cursor - 1;
                Object previous = FastStack.this.get(i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E o) {
            throw new RuntimeException("Not implemented");
        }
    }
}

