/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.dialogs;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.interpreters.AbstractInterpreterManager;

public class PyDialogHelpers {
    public static final int INTERPRETER_AUTO_CONFIG = 0;
    public static final int INTERPRETER_MANUAL_CONFIG = 1;
    public static final int INTERPRETER_DONT_ASK_CONFIG = 2;
    public static final int INTERPRETER_CANCEL_CONFIG = -1;
    private static final String DONT_ASK_AGAIN_PREFERENCE_VALUE = "DONT_ASK";

    public static void openWarning(String title, String message) {
        Shell shell = PyAction.getShell();
        MessageDialog.openWarning((Shell)shell, (String)title, (String)message);
    }

    public static void openCritical(String title, String message) {
        Shell shell = PyAction.getShell();
        MessageDialog.openError((Shell)shell, (String)title, (String)message);
    }

    public static boolean openQuestion(String title, String message) {
        Shell shell = PyAction.getShell();
        return MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
    }

    public static int openWarningWithIgnoreToggle(String title, String message, String key) {
        Shell shell = PyAction.getShell();
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        String val = store.getString(key);
        if (val.trim().length() == 0) {
            val = "prompt";
        }
        if (!val.equals("always")) {
            MessageDialogWithToggle.openWarning((Shell)shell, (String)title, (String)message, (String)"Don't show this message again", (boolean)false, (IPreferenceStore)store, (String)key);
        }
        return 0;
    }

    public static int openCriticalWithChoices(String title, String message, String[] choices) {
        Shell shell = PyAction.getShell();
        MessageDialog dialog = new MessageDialog(shell, title, null, message, 1, choices, 0);
        return dialog.open();
    }

    public static int openQuestionConfigureInterpreter(AbstractInterpreterManager m) {
        String title = String.valueOf(m.getInterpreterUIName()) + " not configured";
        String message = "It seems that the " + m.getInterpreterUIName() + " interpreter is not currently configured.\n\nHow do you want to proceed?";
        String key = "INTERPRETER_CONFIGURATION_" + m.getInterpreterType();
        Shell shell = PyAction.getShell();
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        String val = store.getString(key);
        if (!val.equals(DONT_ASK_AGAIN_PREFERENCE_VALUE)) {
            MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, new String[]{"Auto config", "Manual config", "Don't ask again"}, 0);
            int open = dialog.open();
            switch (open) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    store.putValue(key, DONT_ASK_AGAIN_PREFERENCE_VALUE);
                    return 2;
                }
            }
        }
        return -1;
    }

    public static boolean getAskAgainInterpreter(AbstractInterpreterManager m) {
        String key = "INTERPRETER_CONFIGURATION_" + m.getInterpreterType();
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        String val = store.getString(key);
        return !val.equals(DONT_ASK_AGAIN_PREFERENCE_VALUE);
    }
}

