/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.actions.container;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.REF;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.uiutils.RunInUiThread;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.actions.PyFormatStd;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.parser.prettyprinterv2.IFormatter;
import org.python.pydev.ui.actions.container.PyContainerAction;

public class PySourceFormatAction
extends PyContainerAction {
    private IFormatter formatter;
    private Set<IFile> openFiles;

    protected boolean needsUIThread() {
        return false;
    }

    protected void beforeRun() {
        this.openFiles = PyAction.getOpenFiles();
        PyFormatStd std = new PyFormatStd();
        this.formatter = std.getFormatter();
    }

    protected int doActionOnContainer(IContainer container, IProgressMonitor monitor) {
        int formatted = 0;
        try {
            IResource[] members;
            IResource[] iResourceArray = members = container.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                String name;
                IResource c = iResourceArray[n2];
                if (monitor.isCanceled()) break;
                monitor.worked(1);
                if (c instanceof IContainer) {
                    formatted += this.doActionOnContainer((IContainer)c, monitor);
                } else if (c instanceof IFile && (name = c.getName()) != null) {
                    monitor.setTaskName("Formatting: " + name);
                    if (PythonPathHelper.isValidSourceFile(name)) {
                        IFile file = (IFile)c;
                        final IDocument doc = REF.getDocFromResource((IResource)c);
                        final boolean isOpenedFile = this.openFiles.contains(file);
                        try {
                            if (isOpenedFile) {
                                RunInUiThread.async((Runnable)new Runnable(){

                                    public void run() {
                                        try {
                                            PySourceFormatAction.this.formatter.formatAll(doc, null, isOpenedFile, true);
                                        }
                                        catch (SyntaxErrorException e) {
                                            Log.log((int)4, (String)("Could not source-format file: " + name + " (invalid syntax)."), (Throwable)e);
                                        }
                                    }
                                });
                            } else {
                                this.formatter.formatAll(doc, null, isOpenedFile, true);
                            }
                        }
                        catch (SyntaxErrorException e) {
                            Log.log((int)4, (String)("Could not source-format file: " + name + " (invalid syntax)."), (Throwable)e);
                        }
                        ++formatted;
                        if (!isOpenedFile) {
                            file.setContents((InputStream)new ByteArrayInputStream(doc.get().getBytes()), true, true, monitor);
                        }
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        return formatted;
    }

    protected void afterRun(int formatted) {
        this.openFiles = null;
        this.formatter = null;
        MessageDialog.openInformation(null, (String)"Files formatted", (String)StringUtils.format((String)"Formatted %s files.", (Object[])new Object[]{formatted}));
    }

    protected boolean confirmRun() {
        return MessageDialog.openConfirm(null, (String)"Confirm source formatting", (String)"Are you sure that you want to recursively apply the source formatting to python files from the selected folder(s)?\n\nIt'll be applied to all the file-types specified in the preferences: pydev > code style > file types.\n\nThis action cannot be undone.");
    }
}

