/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.navigator.actions.copied.CopyAction;

public class PyCopyResourceAction
extends CopyAction {
    private ISelectionProvider provider;
    private ArrayList<IResource> selected;

    public PyCopyResourceAction(Shell shell, ISelectionProvider selectionProvider, Clipboard clipboard) {
        super(shell, clipboard);
        this.provider = selectionProvider;
    }

    public boolean isEnabled() {
        this.fillSelection();
        return this.selected != null && this.selected.size() > 0;
    }

    private boolean fillSelection() {
        IStructuredSelection sSelection;
        this.selected = new ArrayList();
        ISelection selection = this.provider.getSelection();
        if (!selection.isEmpty() && (sSelection = (IStructuredSelection)selection).size() >= 1) {
            for (Object element : sSelection) {
                IAdaptable adaptable;
                IResource resource;
                if (element instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)element).getAdapter(IResource.class)) != null) {
                    this.selected.add(resource);
                    continue;
                }
                this.selected = null;
                return false;
            }
        }
        return true;
    }

    protected List getSelectedResources() {
        return this.selected;
    }

    public IStructuredSelection getStructuredSelection() {
        return new StructuredSelection(this.selected);
    }

    public void run() {
        if (!this.fillSelection()) {
            return;
        }
        super.run();
    }
}

