/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.Tuple3;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateWrapper;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompletionState
implements ICompletionState {
    private String activationToken;
    private int line = -1;
    private int col = -1;
    private IPythonNature nature;
    private String qualifier;
    private final Memo<String> memory = new Memo();
    private final Memo<Definition> definitionMemory = new Memo();
    private final Memo<IModule> wildImportMemory = new Memo();
    private final Memo<String> importedModsCalled = new Memo();
    private final Memo<String> findMemory = new Memo();
    private final Memo<String> resolveImportMemory = new Memo();
    private final Memo<String> findDefinitionMemory = new Memo();
    private final Memo<String> findLocalDefinedDefinitionMemory = new Memo();
    private Stack<Memo<IToken>> findResolveImportMemory = new Stack();
    private final Memo<String> findModuleCompletionsMemory = new Memo();
    private final Memo<String> findSourceFromCompiledMemory = new Memo(1);
    private boolean builtinsGotten = false;
    private boolean localImportsGotten = false;
    private boolean isInCalltip = false;
    private int lookingForInstance = 0;
    private List<IToken> tokenImportedModules;
    private ICompletionCache completionCache;
    private String fullActivationToken;
    Set<Tuple3<Integer, Integer, IModule>> foundSameDefinitionMemory = new HashSet<Tuple3<Integer, Integer, IModule>>();

    public ICompletionState getCopy() {
        return new CompletionStateWrapper(this);
    }

    public ICompletionState getCopyForResolveImportWithActTok(String actTok) {
        CompletionState state = (CompletionState)CompletionStateFactory.getEmptyCompletionState(actTok, this.nature, this.completionCache);
        state.nature = this.nature;
        state.findResolveImportMemory = this.findResolveImportMemory;
        return state;
    }

    public CompletionState(int line2, int col2, String token, IPythonNature nature2, String qualifier) {
        this(line2, col2, token, nature2, qualifier, new CompletionCache());
    }

    public CompletionState(int line2, int col2, String token, IPythonNature nature2, String qualifier, ICompletionCache completionCache) {
        this.line = line2;
        this.col = col2;
        this.activationToken = token;
        this.nature = nature2;
        this.qualifier = qualifier;
        Assert.isNotNull((Object)completionCache);
        this.completionCache = completionCache;
    }

    public CompletionState() {
    }

    public void checkWildImportInMemory(IModule caller, IModule wild) throws CompletionRecursionException {
        if (this.wildImportMemory.isInRecursion(caller, wild)) {
            throw new CompletionRecursionException("Possible recursion found -- probably programming error -- (caller: " + caller.getName() + ", import: " + wild.getName() + " ) - stopping analysis.");
        }
    }

    public void checkDefinitionMemory(IModule module, IDefinition definition) throws CompletionRecursionException {
        if (this.definitionMemory.isInRecursion(module, (Definition)definition)) {
            throw new CompletionRecursionException("Possible recursion found -- probably programming error --  (module: " + module.getName() + ", token: " + definition + ") - stopping analysis.");
        }
    }

    public void checkFindMemory(IModule module, String value) throws CompletionRecursionException {
        if (this.findMemory.isInRecursion(module, value)) {
            throw new CompletionRecursionException("Possible recursion found -- probably programming error --  (module: " + module.getName() + ", value: " + value + ") - stopping analysis.");
        }
    }

    public void checkResolveImportMemory(IModule module, String value) throws CompletionRecursionException {
        if (this.resolveImportMemory.isInRecursion(module, value)) {
            throw new CompletionRecursionException("Possible recursion found -- probably programming error --  (module: " + module.getName() + ", value: " + value + ") - stopping analysis.");
        }
    }

    public void checkFindDefinitionMemory(IModule mod, String tok) throws CompletionRecursionException {
        if (this.findDefinitionMemory.isInRecursion(mod, tok)) {
            throw new CompletionRecursionException("Possible recursion found -- probably programming error --  (module: " + mod.getName() + ", value: " + tok + ") - stopping analysis.");
        }
    }

    public void checkFindLocalDefinedDefinitionMemory(IModule mod, String tok) throws CompletionRecursionException {
        if (this.findLocalDefinedDefinitionMemory.isInRecursion(mod, tok)) {
            throw new CompletionRecursionException("Possible recursion found -- probably programming error --  (module: " + mod.getName() + ", value: " + tok + ") - stopping analysis.");
        }
    }

    public void checkMemory(IModule module, String base) throws CompletionRecursionException {
        if (this.memory.isInRecursion(module, base)) {
            throw new CompletionRecursionException("Possible recursion found -- probably programming error --  (module: " + module.getName() + ", token: " + base + ") - stopping analysis.");
        }
    }

    public boolean checkFoudSameDefinition(int line, int col, IModule mod) {
        Tuple3 key = new Tuple3((Object)line, (Object)col, (Object)mod);
        if (this.foundSameDefinitionMemory.contains(key)) {
            return true;
        }
        this.foundSameDefinitionMemory.add((Tuple3<Integer, Integer, IModule>)key);
        return false;
    }

    public boolean canStillCheckFindSourceFromCompiled(IModule mod, String tok) {
        return !this.findSourceFromCompiledMemory.isInRecursion(mod, tok);
    }

    public void checkFindResolveImportMemory(IToken token) throws CompletionRecursionException {
        for (Memo memo : this.findResolveImportMemory) {
            if (!memo.isInRecursion(null, token)) continue;
            throw new CompletionRecursionException("Possible recursion found -- probably programming error --  (token: " + token + ") - stopping analysis.");
        }
    }

    public void popFindResolveImportMemoryCtx() {
        this.findResolveImportMemory.pop();
    }

    public void pushFindResolveImportMemoryCtx() {
        this.findResolveImportMemory.push(new Memo());
    }

    public void checkFindModuleCompletionsMemory(IModule mod, String tok) throws CompletionRecursionException {
        if (this.findModuleCompletionsMemory.isInRecursion(mod, tok)) {
            throw new CompletionRecursionException("Possible recursion found -- probably programming error --  (module: " + mod.getName() + ", token: " + tok + ") - stopping analysis.");
        }
    }

    public String getActivationToken() {
        return this.activationToken;
    }

    public IPythonNature getNature() {
        return this.nature;
    }

    public void setActivationToken(String string) {
        this.activationToken = string;
    }

    public String getFullActivationToken() {
        return this.fullActivationToken;
    }

    public void setFullActivationToken(String act) {
        this.fullActivationToken = act;
    }

    public void setBuiltinsGotten(boolean b) {
        this.builtinsGotten = b;
    }

    public void setCol(int i) {
        this.col = i;
    }

    public void setLine(int i) {
        this.line = i;
    }

    public void setLocalImportsGotten(boolean b) {
        this.localImportsGotten = b;
    }

    public boolean getLocalImportsGotten() {
        return this.localImportsGotten;
    }

    public int getLine() {
        return this.line;
    }

    public int getCol() {
        return this.col;
    }

    public boolean getBuiltinsGotten() {
        return this.builtinsGotten;
    }

    public void raiseNFindTokensOnImportedModsCalled(IModule mod, String tok) throws CompletionRecursionException {
        if (this.importedModsCalled.isInRecursion(mod, tok)) {
            throw new CompletionRecursionException("Possible recursion found (mod: " + mod.getName() + ", tok: " + tok + " ) - stopping analysis.");
        }
    }

    public boolean getIsInCalltip() {
        return this.isInCalltip;
    }

    public void setLookingFor(int b) {
        this.setLookingFor(b, false);
    }

    public void setLookingFor(int b, boolean force) {
        if (this.lookingForInstance == 0 || force) {
            this.lookingForInstance = b;
        }
    }

    public int getLookingFor() {
        return this.lookingForInstance;
    }

    public ICompletionState getCopyWithActTok(String value) {
        ICompletionState copy = this.getCopy();
        copy.setActivationToken(value);
        return copy;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setIsInCalltip(boolean isInCalltip) {
        this.isInCalltip = isInCalltip;
    }

    public void setTokenImportedModules(List<IToken> tokenImportedModules) {
        if (tokenImportedModules != null && this.tokenImportedModules == null) {
            this.tokenImportedModules = new ArrayList<IToken>(tokenImportedModules);
        }
    }

    public List<IToken> getTokenImportedModules() {
        return this.tokenImportedModules;
    }

    public void add(Object key, Object n) {
        this.completionCache.add(key, n);
    }

    public Object getObj(Object o) {
        return this.completionCache.getObj(o);
    }

    public void remove(Object key) {
        this.completionCache.remove(key);
    }

    public void removeStaleEntries() {
        this.completionCache.removeStaleEntries();
    }

    public void clear() {
        this.completionCache.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Memo<E> {
        private int max;
        private static final int MAX_NUMBER_OF_OCURRENCES = 5;
        public Map<IModule, Map<E, Integer>> memo = new HashMap<IModule, Map<E, Integer>>();

        public Memo() {
            this.max = 5;
        }

        public Memo(int max) {
            this.max = max;
        }

        public boolean isInRecursion(IModule caller, E def) {
            Integer numberOfOccurences;
            Map<Object, Object> val;
            boolean occuredMoreThanMax = false;
            if (!this.memo.containsKey(caller)) {
                val = new HashMap();
                this.memo.put(caller, val);
            } else {
                val = this.memo.get(caller);
                if (val.containsKey(def) && (numberOfOccurences = (Integer)val.get(def)) > this.max) {
                    occuredMoreThanMax = true;
                }
            }
            numberOfOccurences = (Integer)val.get(def);
            if (numberOfOccurences == null) {
                val.put(def, 1);
            } else {
                val.put(def, numberOfOccurences + 1);
            }
            return occuredMoreThanMax;
        }
    }
}

