/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionRequest;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.ImmutableTuple;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.Tuple3;
import org.python.pydev.core.TupleN;
import org.python.pydev.core.callbacks.ICallback0;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codecompletion.revisited.AssignAnalysis;
import org.python.pydev.editor.codecompletion.revisited.AssignCompletionInfo;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.CompletionParticipantsHelper;
import org.python.pydev.editor.codecompletion.revisited.CompletionState;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.ConcreteToken;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.codecompletion.revisited.visitors.GlobalModelVisitor;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.visitors.NodeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractASTManager
implements ICodeCompletionASTManager {
    private static final IToken[] EMPTY_ITOKEN_ARRAY = new IToken[0];
    private static final boolean DEBUG_CACHE = false;
    private final AssignAnalysis assignAnalysis = new AssignAnalysis();
    private final Object lock = new Object();
    public volatile IModulesManager modulesManager;

    public Object getLock() {
        return this.lock;
    }

    public IModulesManager getModulesManager() {
        return this.modulesManager;
    }

    public void setNature(IPythonNature nature) {
        this.getModulesManager().setPythonNature(nature);
    }

    public IPythonNature getNature() {
        return this.getModulesManager().getNature();
    }

    public abstract void setProject(IProject var1, IPythonNature var2, boolean var3);

    public abstract void rebuildModule(File var1, ICallback0<IDocument> var2, IProject var3, IProgressMonitor var4, IPythonNature var5);

    public abstract void removeModule(File var1, IProject var2, IProgressMonitor var3);

    public IToken[] getCompletionsForImport(ICodeCompletionASTManager.ImportInfo importInfo, ICompletionRequest r, boolean onlyGetDirectModules) throws CompletionRecursionException, MisconfigurationException {
        String original = importInfo.importsTipperStr;
        String afterDots = null;
        int level = 0;
        boolean onlyDots = true;
        if (original.startsWith(".")) {
            int i = 0;
            while (i < original.length()) {
                if (original.charAt(i) != '.') {
                    onlyDots = false;
                    afterDots = original.substring(i);
                    break;
                }
                ++level;
                ++i;
            }
        }
        ICompletionRequest request = r;
        IPythonNature nature = request.getNature();
        String relative = null;
        String moduleName = null;
        if (request.getEditorFile() != null && (moduleName = this.modulesManager.resolveModule(REF.getFileAbsolutePath((File)request.getEditorFile()))) != null) {
            if (level > 0) {
                List moduleParts = StringUtils.dotSplit((String)moduleName);
                if (moduleParts.size() > level) {
                    relative = FullRepIterable.joinParts((List)moduleParts, (int)(moduleParts.size() - level));
                }
                if (!onlyDots) {
                    relative = String.valueOf(relative) + "." + afterDots;
                }
            } else {
                boolean isAbsoluteImportEnabled = this.isAbsoluteImportEnabled(request, nature);
                if (!isAbsoluteImportEnabled) {
                    String tail = FullRepIterable.headAndTail((String)moduleName)[0];
                    relative = original.length() > 0 ? String.valueOf(tail) + "." + original : tail;
                }
            }
        }
        HashSet<IToken> set = new HashSet<IToken>();
        String absoluteModule = original;
        if (absoluteModule.endsWith(".")) {
            absoluteModule = absoluteModule.substring(0, absoluteModule.length() - 1);
        }
        if (relative != null && !relative.equals(absoluteModule)) {
            this.getAbsoluteImportTokens(relative, set, 7, false, importInfo, onlyGetDirectModules);
            if (importInfo.hasImportSubstring) {
                this.getTokensForModule(relative, nature, relative, set);
            }
        }
        if ((set.size() == 0 || absoluteModule.length() == 0) && level == 0) {
            this.getAbsoluteImportTokens(absoluteModule, set, 0, false, importInfo, onlyGetDirectModules);
            this.getTokensForModule(original, nature, absoluteModule, set);
        }
        if (level == 1 && moduleName != null) {
            String strToRemove = FullRepIterable.getLastPart((String)moduleName);
            Iterator it = set.iterator();
            while (it.hasNext()) {
                IToken o = (IToken)it.next();
                if (!o.getRepresentation().equals(strToRemove)) continue;
                it.remove();
            }
        }
        return set.toArray(EMPTY_ITOKEN_ARRAY);
    }

    private boolean isAbsoluteImportEnabled(IModule module, IPythonNature nature) throws MisconfigurationException {
        boolean isAbsoluteImportEnabled = false;
        try {
            isAbsoluteImportEnabled = nature.getGrammarVersion() >= 99;
        }
        catch (MisconfigurationException e) {
            Log.log((Throwable)e);
        }
        if (!isAbsoluteImportEnabled && module != null) {
            isAbsoluteImportEnabled = module.hasFutureImportAbsoluteImportDeclared();
        }
        return isAbsoluteImportEnabled;
    }

    private boolean isAbsoluteImportEnabled(ICompletionRequest request, IPythonNature nature) throws MisconfigurationException {
        IModule module;
        boolean isAbsoluteImportEnabled = false;
        try {
            isAbsoluteImportEnabled = nature.getGrammarVersion() >= 99;
        }
        catch (MisconfigurationException e) {
            Log.log((Throwable)e);
        }
        if (!isAbsoluteImportEnabled && (module = request.getModule()) != null) {
            isAbsoluteImportEnabled = module.hasFutureImportAbsoluteImportDeclared();
        }
        return isAbsoluteImportEnabled;
    }

    public void getAbsoluteImportTokens(String moduleToGetTokensFrom, Set<IToken> inputOutput, int type, boolean onlyFilesOnSameLevel, ICodeCompletionASTManager.ImportInfo importInfo, boolean onlyGetDirectModules) {
        HashMap<String, ConcreteToken> temp = new HashMap<String, ConcreteToken>();
        SortedMap modulesStartingWith = onlyGetDirectModules ? this.modulesManager.getAllDirectModulesStartingWith(moduleToGetTokensFrom) : this.modulesManager.getAllModulesStartingWith(moduleToGetTokensFrom);
        for (ModulesKey key : modulesStartingWith.keySet()) {
            List splitted;
            String element = key.name;
            if (onlyFilesOnSameLevel && key.file != null && key.file.isDirectory()) continue;
            element = element.substring(moduleToGetTokensFrom.length());
            if (onlyFilesOnSameLevel && PyAction.countChars('.', element) > 1) continue;
            boolean goForIt = false;
            if (moduleToGetTokensFrom.length() != 0) {
                if (element.length() > 0 && element.charAt(0) == '.') {
                    element = element.substring(1);
                    goForIt = true;
                }
            } else {
                goForIt = true;
            }
            if (element.length() <= 0 || !goForIt || (splitted = StringUtils.dotSplit((String)element)).size() <= 0) continue;
            String strToAdd = (String)splitted.get(0);
            temp.put(strToAdd, new ConcreteToken(strToAdd, "", "", moduleToGetTokensFrom, type));
        }
        inputOutput.addAll(temp.values());
    }

    protected void getTokensForModule(String original, IPythonNature nature, String moduleToGetTokensFrom, Set<IToken> set) throws CompletionRecursionException {
        if (moduleToGetTokensFrom.length() > 0) {
            IToken[] globalTokens;
            CompletionState state2;
            if (original.endsWith(".")) {
                original = original.substring(0, original.length() - 1);
            }
            Tuple<IModule, String> modTok = this.findModuleFromPath(original, nature, false, null);
            IModule m = (IModule)modTok.o1;
            String tok = (String)modTok.o2;
            if (m == null) {
                return;
            }
            if (tok != null && tok.length() > 0) {
                state2 = new CompletionState(-1, -1, tok, nature, "");
                state2.setBuiltinsGotten(true);
                globalTokens = m.getGlobalTokens((ICompletionState)state2, (ICodeCompletionASTManager)this);
            } else {
                state2 = new CompletionState(-1, -1, "", nature, "");
                state2.setBuiltinsGotten(true);
                globalTokens = this.getCompletionsForModule(m, state2);
            }
            int i = 0;
            while (i < globalTokens.length) {
                IToken element = globalTokens[i];
                set.add(element);
                ++i;
            }
        }
    }

    public static IModule createModule(File file, IDocument doc, IPythonNature nature) throws MisconfigurationException {
        return AbstractModule.createModuleFromDoc(file, doc, nature);
    }

    public IToken[] getCompletionsForToken(IDocument doc, ICompletionState state) {
        IToken[] completionsForModule;
        try {
            Tuple obj = PyParser.reparseDocument((PyParser.ParserInfo)new PyParser.ParserInfo(doc, (IGrammarVersionProvider)state.getNature()));
            SimpleNode n = (SimpleNode)obj.o1;
            IModule module = AbstractModule.createModule(n);
            completionsForModule = this.getCompletionsForModule(module, state, true, true);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                if (e instanceof NullPointerException) {
                    Log.log((Throwable)e);
                    message = "NullPointerException";
                } else {
                    message = "Null error message";
                }
            }
            completionsForModule = new IToken[]{new ConcreteToken(message, message, "", "", -1)};
        }
        return completionsForModule;
    }

    public IModule getModule(String name, IPythonNature nature, boolean dontSearchInit) {
        return this.modulesManager.getModule(name, nature, dontSearchInit, false);
    }

    public IModule getModule(String name, IPythonNature nature, boolean dontSearchInit, boolean lookingForRelative) {
        if (lookingForRelative) {
            return this.modulesManager.getRelativeModule(name, nature);
        }
        return this.modulesManager.getModule(name, nature, dontSearchInit);
    }

    protected IToken[] getBuiltinsCompletions(ICompletionState state) {
        IModule m;
        ICompletionState state2 = state.getCopy();
        String act = state.getActivationToken();
        state2.setActivationToken(NodeUtils.getBuiltinType((String)act));
        if (state2.getActivationToken() != null && (m = this.getBuiltinMod(state.getNature())) != null) {
            return m.getGlobalTokens(state2, (ICodeCompletionASTManager)this);
        }
        if (act.equals("__builtins__") || act.startsWith("__builtins__.")) {
            if ((act = act.substring(12)).startsWith(".")) {
                act = act.substring(1);
            }
            m = this.getBuiltinMod(state.getNature());
            ICompletionState state3 = state.getCopy();
            state3.setActivationToken(act);
            return m.getGlobalTokens(state3, (ICodeCompletionASTManager)this);
        }
        return null;
    }

    public IToken[] getCompletionsForModule(IModule module, ICompletionState state) throws CompletionRecursionException {
        return this.getCompletionsForModule(module, state, true);
    }

    public IToken[] getCompletionsForModule(IModule module, ICompletionState state, boolean searchSameLevelMods) throws CompletionRecursionException {
        return this.getCompletionsForModule(module, state, true, false);
    }

    public IToken[] getCompletionsForModule(IModule module, ICompletionState state, boolean searchSameLevelMods, boolean lookForArgumentCompletion) throws CompletionRecursionException {
        return this.getCompletionsForModule(module, state, searchSameLevelMods, lookForArgumentCompletion, false);
    }

    public IToken[] getCompletionsForModule(IModule module, ICompletionState state, boolean searchSameLevelMods, boolean lookForArgumentCompletion, boolean handleAsWildImport) throws CompletionRecursionException {
        String name = module.getName();
        TupleN key = new TupleN(new Object[]{"getCompletionsForModule", name != null ? name : "", state.getActivationToken(), searchSameLevelMods, lookForArgumentCompletion, state.getBuiltinsGotten(), state.getLocalImportsGotten(), handleAsWildImport});
        IToken[] ret = (IToken[])state.getObj((Object)key);
        if (ret != null) {
            return ret;
        }
        IToken[] completionsForModule = this.internalGenerateGetCompletionsForModule(module, state, searchSameLevelMods, lookForArgumentCompletion);
        completionsForModule = this.filterForWildImport(module, handleAsWildImport, completionsForModule);
        state.add((Object)key, (Object)completionsForModule);
        return completionsForModule;
    }

    private IToken[] filterForWildImport(IModule module, boolean handleAsWildImport, IToken[] completionsForModule) {
        if (module != null && handleAsWildImport) {
            SourceModule sourceModule;
            GlobalModelVisitor globalModelVisitorCache;
            ArrayList<IToken> ret = new ArrayList<IToken>();
            int j = 0;
            while (j < completionsForModule.length) {
                IToken token = completionsForModule[j];
                if (!token.getRepresentation().startsWith("_")) {
                    ret.add(token);
                }
                ++j;
            }
            if (module instanceof SourceModule && (globalModelVisitorCache = (sourceModule = (SourceModule)module).getGlobalModelVisitorCache()) != null) {
                globalModelVisitorCache.filterAll(ret);
            }
            return ret.toArray(new IToken[ret.size()]);
        }
        return completionsForModule;
    }

    private void log(String message, IModule module, ICompletionState state) {
        String name = module == null ? "null module" : module.getName();
        Log.toLogFile((Object)this, (String)(String.valueOf(message) + ": " + name + " -- " + state.getActivationToken()));
    }

    private IToken[] internalGenerateGetCompletionsForModule(IModule module, ICompletionState state, boolean searchSameLevelMods, boolean lookForArgumentCompletion) throws CompletionRecursionException {
        IToken[] builtinsCompletions;
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            this.log("internalGenerateGetCompletionsForModule", module, state);
        }
        ArrayList<IToken> importedModules = new ArrayList<IToken>();
        ILocalScope localScope = null;
        int line = state.getLine();
        int col = state.getCol();
        if (!state.getLocalImportsGotten()) {
            state.setLocalImportsGotten(true);
            if (module != null && line >= 0 && (localScope = module.getLocalScope(line, col)) != null) {
                importedModules.addAll(localScope.getLocalImportedModules(line + 1, col + 1, module.getName()));
            }
        }
        if ((builtinsCompletions = this.getBuiltinsCompletions(state)) != null) {
            return builtinsCompletions;
        }
        String act = state.getActivationToken();
        int parI = act.indexOf(40);
        if (parI != -1) {
            state.setFullActivationToken(act);
            act = act.substring(0, parI);
            state.setActivationToken(act);
            state.setLookingFor(1);
        }
        if (module != null) {
            IToken[] globalTokens = module.getGlobalTokens();
            List<IToken> tokenImportedModules = Arrays.asList(module.getTokenImportedModules());
            importedModules.addAll(tokenImportedModules);
            state.setTokenImportedModules(importedModules);
            IToken[] wildImportedModules = module.getWildImportedModules();
            HashSet<IToken> initial = new HashSet<IToken>();
            if (searchSameLevelMods && module.isPackage()) {
                HashSet<IToken> gotten = new HashSet<IToken>();
                this.getAbsoluteImportTokens(module.getPackageFolderName(), gotten, 0, true, null, false);
                for (IToken token : gotten) {
                    if (token.getRepresentation().equals("__init__")) continue;
                    initial.add(token);
                }
            }
            if (state.getActivationToken().length() == 0) {
                List<IToken> completions = this.getGlobalCompletions(globalTokens, importedModules.toArray(EMPTY_ITOKEN_ARRAY), wildImportedModules, state, module);
                if (line >= 0) {
                    IToken[] localTokens = module.getLocalTokens(line, col, localScope);
                    int i = 0;
                    while (i < localTokens.length) {
                        completions.add(localTokens[i]);
                        ++i;
                    }
                }
                completions.addAll(initial);
                return completions.toArray(EMPTY_ITOKEN_ARRAY);
            }
            IToken[] tokens = this.findTokensOnImportedMods(importedModules.toArray(EMPTY_ITOKEN_ARRAY), state, module);
            if (tokens != null && tokens.length > 0) {
                return this.decorateWithLocal(tokens, localScope, state);
            }
            if (searchSameLevelMods && (tokens = this.searchOnSameLevelMods(initial, state)) != null && tokens.length > 0) {
                return this.decorateWithLocal(tokens, localScope, state);
            }
            int i = 0;
            while (i < wildImportedModules.length) {
                IToken name = wildImportedModules[i];
                IModule mod = this.getModule(name.getAsRelativeImport(module.getName()), state.getNature(), false);
                if (mod == null) {
                    mod = this.getModule(name.getOriginalRep(), state.getNature(), false);
                }
                if (mod != null) {
                    state.checkFindModuleCompletionsMemory(mod, state.getActivationToken());
                    IToken[] completionsForModule = this.getCompletionsForModule(mod, state);
                    if (completionsForModule.length > 0) {
                        return this.decorateWithLocal(completionsForModule, localScope, state);
                    }
                }
                ++i;
            }
            tokens = module.getGlobalTokens(state, (ICodeCompletionASTManager)this);
            if (tokens.length > 0) {
                return this.decorateWithLocal(tokens, localScope, state);
            }
            IModule builtinsMod = this.getBuiltinMod(state.getNature());
            if (builtinsMod != null && builtinsMod != module && (tokens = this.getCompletionsForModule(builtinsMod, state)).length > 0 && !tokens[0].getRepresentation().equals("ERROR:")) {
                return this.decorateWithLocal(tokens, localScope, state);
            }
            if (lookForArgumentCompletion && localScope != null) {
                List lookForClass = localScope.getPossibleClassesForActivationToken(state.getActivationToken());
                if (lookForClass.size() > 0) {
                    HashSet<IToken> hashSet = new HashSet<IToken>();
                    this.getCompletionsForClassInLocalScope(module, state, searchSameLevelMods, lookForArgumentCompletion, lookForClass, hashSet);
                    if (hashSet.size() > 0) {
                        return hashSet.toArray(EMPTY_ITOKEN_ARRAY);
                    }
                }
                if ((tokens = CompletionParticipantsHelper.getCompletionsForMethodParameter(state, localScope).toArray(EMPTY_ITOKEN_ARRAY)) != null && tokens.length > 0) {
                    return tokens;
                }
            }
            return this.getAssignCompletions(module, state, lookForArgumentCompletion, localScope);
        }
        Log.log((String)"Module passed in is null!!");
        return EMPTY_ITOKEN_ARRAY;
    }

    private IToken[] decorateWithLocal(IToken[] tokens, ILocalScope localScope, ICompletionState state) {
        Collection interfaceForLocal;
        if (localScope != null && (interfaceForLocal = localScope.getInterfaceForLocal(state.getActivationToken())) != null && interfaceForLocal.size() > 0) {
            IToken[] ret = new IToken[tokens.length + interfaceForLocal.size()];
            Object[] array = interfaceForLocal.toArray();
            System.arraycopy(array, 0, ret, 0, array.length);
            System.arraycopy(tokens, 0, ret, array.length, tokens.length);
            return ret;
        }
        return tokens;
    }

    private IToken[] getAssignCompletions(IModule module, ICompletionState state, boolean lookForArgumentCompletion, ILocalScope localScope) {
        boolean useExtensions;
        AssignCompletionInfo assignCompletions = this.assignAnalysis.getAssignCompletions(this, module, state);
        boolean bl = useExtensions = assignCompletions.completions.size() == 0;
        if (lookForArgumentCompletion && localScope != null && assignCompletions.completions.size() == 0 && assignCompletions.defs.length > 0) {
            Definition[] definitionArray = assignCompletions.defs;
            int n = assignCompletions.defs.length;
            int n2 = 0;
            while (n2 < n) {
                Definition d = definitionArray[n2];
                if (d.module.equals(module) && localScope.equals(d.scope)) {
                    Collection interfaceForLocal = localScope.getInterfaceForLocal(state.getActivationToken());
                    assignCompletions.completions.addAll(interfaceForLocal);
                    break;
                }
                ++n2;
            }
        }
        if (useExtensions && localScope != null) {
            assignCompletions.completions.addAll(CompletionParticipantsHelper.getCompletionsForTokenWithUndefinedType(state, localScope));
        }
        return assignCompletions.completions.toArray(EMPTY_ITOKEN_ARRAY);
    }

    public void getCompletionsForClassInLocalScope(IModule module, ICompletionState state, boolean searchSameLevelMods, boolean lookForArgumentCompletion, List<String> lookForClass, HashSet<IToken> hashSet) throws CompletionRecursionException {
        ICompletionState stateCopy = state.getCopy();
        int prevLookingFor = stateCopy.getLookingFor();
        stateCopy.setLookingFor(1, true);
        for (String classFound : lookForClass) {
            stateCopy.setLocalImportsGotten(false);
            stateCopy.setActivationToken(classFound);
            IToken[] tokens = this.getCompletionsForModule(module, stateCopy, searchSameLevelMods, lookForArgumentCompletion);
            if (tokens == null) continue;
            IToken[] iTokenArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                IToken tok = iTokenArray[n2];
                hashSet.add(tok);
                ++n2;
            }
        }
        if (hashSet.size() == 0) {
            stateCopy.setLookingFor(prevLookingFor, true);
        }
    }

    protected IToken[] searchOnSameLevelMods(Set<IToken> initial, ICompletionState state) throws CompletionRecursionException {
        IToken[] ret = null;
        Tuple modUsed = null;
        String actTokUsed = null;
        for (IToken token : initial) {
            String rep = token.getRepresentation();
            if (!state.getActivationToken().startsWith(rep)) continue;
            String absoluteImport = token.getAsAbsoluteImport();
            modUsed = this.modulesManager.getModuleAndRelatedModulesManager(absoluteImport, state.getNature(), true, false);
            IModule sameLevelMod = null;
            if (modUsed != null) {
                sameLevelMod = (IModule)modUsed.o1;
            }
            if (sameLevelMod == null) {
                return null;
            }
            String qualifier = state.getActivationToken().substring(rep.length());
            if (state.getActivationToken().equals(rep)) {
                actTokUsed = "";
            } else if (qualifier.startsWith(".")) {
                actTokUsed = qualifier.substring(1);
            }
            if (actTokUsed == null) continue;
            ICompletionState copy = state.getCopyWithActTok(actTokUsed);
            copy.setBuiltinsGotten(true);
            ret = this.getCompletionsForModule(sameLevelMod, copy);
            break;
        }
        return ret;
    }

    public List<IToken> getGlobalCompletions(IToken[] globalTokens, IToken[] importedModules, IToken[] wildImportedModules, ICompletionState state, IModule current) {
        if (DebugSettings.DEBUG_CODE_COMPLETION) {
            this.log("getGlobalCompletions", current, state);
        }
        ArrayList<IToken> completions = new ArrayList<IToken>();
        int i = 0;
        while (i < globalTokens.length) {
            completions.add(globalTokens[i]);
            ++i;
        }
        i = 0;
        while (i < importedModules.length) {
            completions.add(importedModules[i]);
            ++i;
        }
        if (!state.getBuiltinsGotten()) {
            state.setBuiltinsGotten(true);
            if (DebugSettings.DEBUG_CODE_COMPLETION) {
                Log.toLogFile((Object)this, (String)"getBuiltinCompletions");
            }
            this.getBuiltinCompletions(state, completions);
            if (DebugSettings.DEBUG_CODE_COMPLETION) {
                Log.toLogFile((Object)this, (String)"END getBuiltinCompletions");
            }
        }
        i = 0;
        while (i < wildImportedModules.length) {
            IToken name = wildImportedModules[i];
            this.getCompletionsForWildImport(state, current, completions, name);
            ++i;
        }
        return completions;
    }

    public List<IToken> getBuiltinCompletions(ICompletionState state, List<IToken> completions) {
        IPythonNature nature = state.getNature();
        IToken[] builtinCompletions = this.getBuiltinComps(nature);
        if (builtinCompletions != null) {
            int i = 0;
            while (i < builtinCompletions.length) {
                completions.add(builtinCompletions[i]);
                ++i;
            }
        }
        return completions;
    }

    protected IToken[] getBuiltinComps(IPythonNature nature) {
        return nature.getBuiltinCompletions();
    }

    protected IModule getBuiltinMod(IPythonNature nature) {
        return nature.getBuiltinMod();
    }

    public ImmutableTuple<IModule, IToken> resolveImport(ICompletionState state, IToken imported, IModule current) throws CompletionRecursionException {
        String currModName = imported.getParentPackage();
        Tuple3<IModule, String, IToken> modTok = this.findOnImportedMods(new IToken[]{imported}, state.getCopyWithActTok(imported.getRepresentation()), currModName, current);
        if (modTok != null && modTok.o1 != null) {
            if (((String)modTok.o2).length() == 0) {
                return new ImmutableTuple((Object)current, (Object)imported);
            }
            try {
                state.checkResolveImportMemory((IModule)modTok.o1, (String)modTok.o2);
            }
            catch (CompletionRecursionException completionRecursionException) {
                return new ImmutableTuple((Object)current, (Object)imported);
            }
            IToken repInModule = this.getRepInModule((IModule)modTok.o1, (String)modTok.o2, state.getNature(), state);
            if (repInModule != null) {
                return new ImmutableTuple((Object)((IModule)modTok.o1), (Object)repInModule);
            }
        }
        return new ImmutableTuple((Object)current, (Object)imported);
    }

    public IToken getRepInModule(IModule module, String tokName, IPythonNature nature) throws CompletionRecursionException {
        return this.getRepInModule(module, tokName, nature, null);
    }

    private IToken getRepInModule(IModule module, String tokName, IPythonNature nature, ICompletionState state) throws CompletionRecursionException {
        if (module != null) {
            if (tokName.startsWith(".")) {
                tokName = tokName.substring(1);
            }
            String[] headAndTail = FullRepIterable.headAndTail((String)tokName);
            String actToken = headAndTail[0];
            String hasToBeFound = headAndTail[1];
            if (state == null) {
                state = CompletionStateFactory.getEmptyCompletionState(actToken, nature, new CompletionCache());
            } else {
                state = state.getCopy();
                state.setActivationToken(actToken);
            }
            IToken[] completionsForModule = this.getCompletionsForModule(module, state);
            int len = completionsForModule.length;
            int i = 0;
            while (i < len) {
                IToken foundTok = completionsForModule[i];
                if (foundTok.getRepresentation().equals(hasToBeFound)) {
                    return foundTok;
                }
                ++i;
            }
        }
        return null;
    }

    public boolean getCompletionsForWildImport(ICompletionState state, IModule current, List<IToken> completions, IToken name) {
        try {
            IModule mod = null;
            if (current != null) {
                mod = this.getModule(name.getAsRelativeImport(current.getName()), state.getNature(), false);
            }
            if (mod == null) {
                mod = this.getModule(name.getOriginalRep(), state.getNature(), false);
            }
            if (mod != null) {
                IToken[] completionsForModule;
                state.checkWildImportInMemory(current, mod);
                IToken[] iTokenArray = completionsForModule = this.getCompletionsForModule(mod, state, true, false, true);
                int n = completionsForModule.length;
                int n2 = 0;
                while (n2 < n) {
                    IToken token = iTokenArray[n2];
                    completions.add(token);
                    ++n2;
                }
                return true;
            }
        }
        catch (CompletionRecursionException completionRecursionException) {}
        return false;
    }

    public IToken[] findTokensOnImportedMods(IToken[] importedModules, ICompletionState state, IModule current) throws CompletionRecursionException {
        Tuple3<IModule, String, IToken> o = this.findOnImportedMods(importedModules, state, current.getName(), current);
        if (o == null) {
            return null;
        }
        IModule mod = (IModule)o.o1;
        String tok = (String)o.o2;
        String tokForSearchInOtherModule = AbstractASTManager.getTokToSearchInOtherModule(o);
        if (tok.length() == 0) {
            ICompletionState copy = state.getCopy();
            copy.setActivationToken("");
            copy.setBuiltinsGotten(true);
            return this.getCompletionsForModule(mod, copy);
        }
        if (mod != null) {
            ICompletionState copy = state.getCopy();
            copy.setActivationToken(tokForSearchInOtherModule);
            copy.setCol(-1);
            copy.setLine(-1);
            copy.raiseNFindTokensOnImportedModsCalled(mod, tokForSearchInOtherModule);
            String parentPackage = ((IToken)o.o3).getParentPackage();
            if (parentPackage.trim().length() > 0 && parentPackage.equals(current.getName()) && state.getActivationToken().equals(tok) && !parentPackage.endsWith("__init__")) {
                String name = mod.getName();
                if (name.endsWith(".__init__")) {
                    name = name.substring(0, name.length() - 9);
                }
                if (((IToken)o.o3).getAsAbsoluteImport().startsWith(name) && current.isInDirectGlobalTokens(tok, (ICompletionCache)state)) {
                    return null;
                }
            }
            return this.getCompletionsForModule(mod, copy);
        }
        return null;
    }

    public static String getTokToSearchInOtherModule(Tuple3<IModule, String, IToken> modTok) {
        SourceToken sourceToken2;
        IToken sourceToken;
        String tok;
        String tokForSearchInOtherModule = tok = (String)modTok.o2;
        if (tok.length() > 0 && (sourceToken = (IToken)modTok.o3) instanceof SourceToken && (sourceToken2 = (SourceToken)sourceToken).getAst() instanceof ImportFrom) {
            ImportFrom importFrom = (ImportFrom)sourceToken2.getAst();
            if (importFrom.names.length > 0 && importFrom.names[0].asname != null) {
                String originalRep = sourceToken.getOriginalRep();
                tokForSearchInOtherModule = FullRepIterable.getLastPart((String)originalRep);
            }
        }
        return tokForSearchInOtherModule;
    }

    public Tuple3<IModule, String, IToken> findOnImportedMods(ICompletionState state, IModule current) throws CompletionRecursionException {
        IToken[] importedModules = current.getTokenImportedModules();
        return this.findOnImportedMods(importedModules, state, current.getName(), current);
    }

    public Tuple3<IModule, String, IToken> findOnImportedMods(IToken[] importedModules, ICompletionState state, String currentModuleName, IModule current) throws CompletionRecursionException {
        FullRepIterable iterable = new FullRepIterable(state.getActivationToken(), true);
        for (String tok : iterable) {
            IToken[] iTokenArray = importedModules;
            int n = importedModules.length;
            int n2 = 0;
            while (n2 < n) {
                IToken importedModule = iTokenArray[n2];
                String modRep = importedModule.getRepresentation();
                if (modRep.equals(tok)) {
                    String act = state.getActivationToken();
                    try {
                        Tuple<IModule, String> r = this.findOnImportedMods(importedModule, tok, state, act, currentModuleName, current);
                        if (r != null) {
                            return new Tuple3((Object)((IModule)r.o1), (Object)((String)r.o2), (Object)importedModule);
                        }
                    }
                    catch (MisconfigurationException e) {
                        Log.log((Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public Tuple<IModule, String> findModule(String moduleToFind, String currentModule, ICompletionState state, IModule current) throws CompletionRecursionException, MisconfigurationException {
        NameTok name = new NameTok(moduleToFind, 7);
        Import impTok = new Import(new aliasType[]{new aliasType((NameTokType)name, null)});
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        List<IToken> imp = AbstractVisitor.makeImportToken(impTok, tokens, currentModule, true);
        IToken importedModule = imp.get(imp.size() - 1);
        return this.findOnImportedMods(importedModule, "", state, "", currentModule, current);
    }

    public Tuple<IModule, String> findOnImportedMods(IToken importedModule, String tok, ICompletionState state, String activationToken, String currentModuleName, IModule current) throws CompletionRecursionException, MisconfigurationException {
        String originalWithoutRep;
        SourceToken token;
        Tuple<IModule, String> modTok = null;
        IModule mod = null;
        IPythonNature nature = state.getNature();
        if (importedModule instanceof SourceToken && (token = (SourceToken)importedModule).isImportFrom()) {
            ImportFrom importFrom = (ImportFrom)token.getAst();
            int level = importFrom.level;
            if (level > 0) {
                String modName;
                String parentPackage = token.getParentPackage();
                List moduleParts = StringUtils.dotSplit((String)parentPackage);
                String relative = null;
                if (moduleParts.size() > level) {
                    relative = FullRepIterable.joinParts((List)moduleParts, (int)(moduleParts.size() - level));
                }
                if ((modName = ((NameTok)importFrom.module).id).length() > 0) {
                    relative = String.valueOf(relative) + "." + modName;
                }
                if (!AbstractVisitor.isWildImport(importFrom)) {
                    tok = FullRepIterable.getLastPart((String)token.originalRep);
                    relative = String.valueOf(relative) + "." + tok;
                }
                modTok = this.findModuleFromPath(relative, nature, false, null);
                mod = (IModule)modTok.o1;
                if (this.checkValidity(currentModuleName, mod)) {
                    Tuple<IModule, String> ret = this.fixTok(modTok, tok, activationToken);
                    return ret;
                }
                return null;
            }
        }
        boolean isAbsoluteImportEnabledx = this.isAbsoluteImportEnabled(current, nature);
        String asRelativeImport = "";
        if (!isAbsoluteImportEnabledx && !(asRelativeImport = importedModule.getAsRelativeImport(currentModuleName)).startsWith(".")) {
            modTok = this.findModuleFromPath(asRelativeImport, nature, true, currentModuleName);
            mod = (IModule)modTok.o1;
            if (this.checkValidity(currentModuleName, mod)) {
                Tuple<IModule, String> ret = this.fixTok(modTok, tok, activationToken);
                return ret;
            }
        }
        if ((originalWithoutRep = importedModule.getOriginalWithoutRep()).length() > 0) {
            if (!originalWithoutRep.endsWith("__init__")) {
                originalWithoutRep = String.valueOf(originalWithoutRep) + ".__init__";
            }
            modTok = this.findModuleFromPath(originalWithoutRep, nature, true, null);
            mod = (IModule)modTok.o1;
            if (!((String)modTok.o2).endsWith("__init__") && this.checkValidity(currentModuleName, mod) && mod.isInGlobalTokens(importedModule.getRepresentation(), nature, false, (ICompletionCache)state)) {
                Tuple<IModule, String> ret = this.fixTok(modTok, tok, activationToken);
                ret.o2 = ((String)ret.o2).length() == 0 ? importedModule.getRepresentation() : String.valueOf(importedModule.getRepresentation()) + "." + (String)ret.o2;
                return ret;
            }
        }
        modTok = this.findModuleFromPath(importedModule.getOriginalRep(), nature, false, null);
        mod = (IModule)modTok.o1;
        if (this.checkValidity(currentModuleName, mod)) {
            Tuple<IModule, String> ret = this.fixTok(modTok, tok, activationToken);
            return ret;
        }
        if (!isAbsoluteImportEnabledx) {
            modTok = this.findModuleFromPath(asRelativeImport, nature, false, null);
            mod = (IModule)modTok.o1;
            if (this.checkValidity(currentModuleName, mod, true)) {
                Tuple<IModule, String> ret = this.fixTok(modTok, tok, activationToken);
                if (!mod.getName().endsWith("__init__")) {
                    return ret;
                }
                if (activationToken.length() == 0 || !((String)ret.o2).equals(activationToken) || mod.isInGlobalTokens(activationToken, nature, false, (ICompletionCache)state)) {
                    return ret;
                }
            }
        }
        return null;
    }

    protected boolean checkValidity(String currentModuleName, IModule mod) {
        return this.checkValidity(currentModuleName, mod, false);
    }

    protected boolean checkValidity(String currentModuleName, IModule mod, boolean isRelative) {
        if (mod == null) {
            return false;
        }
        String modName = mod.getName();
        if (modName == null) {
            return true;
        }
        if (modName.equals(currentModuleName)) {
            return false;
        }
        if (isRelative && currentModuleName != null && modName.endsWith(".__init__")) {
            String withoutLastPart = FullRepIterable.getWithoutLastPart((String)modName);
            String currentWithoutLastPart = FullRepIterable.getWithoutLastPart((String)currentModuleName);
            if (currentWithoutLastPart.equals(withoutLastPart)) {
                return false;
            }
        }
        return true;
    }

    protected Tuple<IModule, String> fixTok(Tuple<IModule, String> modTok, String tok, String activationToken) {
        if (activationToken.length() > tok.length() && activationToken.startsWith(tok)) {
            String toAdd = activationToken.substring(tok.length() + 1);
            modTok.o2 = ((String)modTok.o2).length() == 0 ? toAdd : String.valueOf(modTok.o2) + "." + toAdd;
        }
        return modTok;
    }

    public Tuple<IModule, String> findModuleFromPath(String rep, IPythonNature nature, boolean dontSearchInit, String currentModuleName) {
        int index;
        String tok = "";
        boolean lookingForRelative = currentModuleName != null;
        IModule mod = this.getModule(rep, nature, dontSearchInit, lookingForRelative);
        String mRep = rep;
        while (mod == null && (index = mRep.lastIndexOf(46)) != -1) {
            tok = String.valueOf(mRep.substring(index + 1)) + "." + tok;
            if ((mRep = mRep.substring(0, index)).length() <= 0) continue;
            mod = this.getModule(mRep, nature, dontSearchInit, lookingForRelative);
        }
        if (tok.endsWith(".")) {
            tok = tok.substring(0, tok.length() - 1);
        }
        if (dontSearchInit && currentModuleName != null && mod != null) {
            String parentModule = FullRepIterable.getParentModule((String)currentModuleName);
            if (mod.getName().length() <= parentModule.length()) {
                return new Tuple(null, null);
            }
        }
        return new Tuple((Object)((AbstractModule)mod), (Object)tok);
    }
}

