/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.PythonPairMatcher;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.parser.fastparser.ScopesParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyScopeSelection
extends PyAction {
    public static final String SELECTION_SCOPE_CACHE = "_SELECTION_SCOPE_CACHE_";

    public void run(IAction action) {
        try {
            ITextEditor textEditor = this.getTextEditor();
            IDocument doc = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            ITextSelection selection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
            this.perform(doc, selection);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public void perform(IDocument doc, ITextSelection selection) {
        ITextSelection newSelection;
        IRegion peek;
        PyEdit pyEdit = this.getPyEdit();
        FastStack<IRegion> cache = PyScopeSelection.getCache(pyEdit);
        Region initialRegion = new Region(selection.getOffset(), selection.getLength());
        if (cache.size() > 0 && !(peek = (IRegion)cache.peek()).equals(initialRegion)) {
            cache.clear();
        }
        if (cache.size() == 0) {
            cache.push((Object)initialRegion);
        }
        if (initialRegion.equals((Object)new Region((newSelection = this.getNewSelection(doc, selection)).getOffset(), newSelection.getLength()))) {
            return;
        }
        pyEdit.setSelection(newSelection.getOffset(), newSelection.getLength());
        cache.push((Object)new Region(newSelection.getOffset(), newSelection.getLength()));
    }

    public ITextSelection getNewSelection(IDocument doc, ITextSelection selection) {
        try {
            ScopesParser.Scopes scopes;
            IRegion scope;
            PySelection ps = new PySelection(doc, selection);
            String selectedText = ps.getSelectedText();
            if (selectedText.length() == 0) {
                PythonPairMatcher pairMatcher;
                int openingOffset;
                Tuple currToken = ps.getCurrToken();
                if (((String)currToken.o1).length() > 0) {
                    return new TextSelection(((Integer)currToken.o2).intValue(), ((String)currToken.o1).length());
                }
                char c = '\u0000';
                try {
                    c = ps.getCharAtCurrentOffset();
                }
                catch (BadLocationException badLocationException) {}
                if (StringUtils.isClosingPeer((char)c) && (openingOffset = (pairMatcher = new PythonPairMatcher()).searchForOpeningPeer(ps.getAbsoluteCursorOffset(), StringUtils.getPeer((char)c), c, doc)) >= 0) {
                    return new TextSelection(openingOffset, ps.getAbsoluteCursorOffset() - openingOffset + 1);
                }
            } else {
                boolean tryMatchWithQualifier = true;
                boolean hasDotSelected = false;
                int i = 0;
                while (i < selectedText.length()) {
                    char c = selectedText.charAt(i);
                    if (c == '.') {
                        hasDotSelected = true;
                    } else if (!Character.isJavaIdentifierPart(c)) {
                        tryMatchWithQualifier = false;
                        break;
                    }
                    ++i;
                }
                if (tryMatchWithQualifier) {
                    Tuple currToken = ps.getCurrToken();
                    if (!hasDotSelected && !((String)currToken.o1).equals(selectedText)) {
                        return new TextSelection(((Integer)currToken.o2).intValue(), ((String)currToken.o1).length());
                    }
                    Tuple currDottedToken = ps.getCurrDottedStatement();
                    if (!((String)currDottedToken.o1).equals(selectedText)) {
                        return new TextSelection(((Integer)currDottedToken.o2).intValue(), ((String)currDottedToken.o1).length());
                    }
                }
            }
            if ((scope = (scopes = ScopesParser.createScopes((IDocument)doc)).getScopeForSelection(selection.getOffset(), selection.getLength())) != null) {
                return new TextSelection(scope.getOffset(), scope.getLength());
            }
        }
        catch (BadLocationException e) {
            Log.log((Throwable)e);
        }
        return selection;
    }

    private static String getCurrentSelectionCacheKey(PyEdit pyEdit) {
        IDocument doc = pyEdit.getDocument();
        int length = doc.getLength();
        String key = Integer.toString(length);
        if (doc instanceof IDocumentExtension4) {
            IDocumentExtension4 document = (IDocumentExtension4)doc;
            long modificationStamp = document.getModificationStamp();
            key = String.valueOf(key) + " - " + modificationStamp;
        }
        return key;
    }

    public static FastStack<IRegion> getCache(PyEdit pyEdit) {
        Map<String, Object> cache = pyEdit.getCache();
        String key = PyScopeSelection.getCurrentSelectionCacheKey(pyEdit);
        try {
            Tuple object = (Tuple)cache.get(SELECTION_SCOPE_CACHE);
            if (object != null && key.equals(object.o1)) {
                return (FastStack)object.o2;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        FastStack stack = new FastStack(20);
        cache.put(SELECTION_SCOPE_CACHE, new Tuple((Object)key, (Object)stack));
        return stack;
    }
}

