/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.dltk.console.ui.internal;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.uiutils.RunInUiThread;
import org.python.pydev.dltk.console.InterpreterResponse;
import org.python.pydev.dltk.console.ScriptConsoleHistory;
import org.python.pydev.dltk.console.ScriptConsolePrompt;
import org.python.pydev.dltk.console.ui.IConsoleStyleProvider;
import org.python.pydev.dltk.console.ui.ScriptConsolePartitioner;
import org.python.pydev.dltk.console.ui.ScriptStyleRange;
import org.python.pydev.dltk.console.ui.internal.ICommandHandler;
import org.python.pydev.dltk.console.ui.internal.IScriptConsoleViewer2ForDocumentListener;
import org.python.pydev.editor.autoedit.DocCmd;
import org.python.pydev.editor.autoedit.PyAutoIndentStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptConsoleDocumentListener
implements IDocumentListener {
    private ICommandHandler handler;
    private ScriptConsolePrompt prompt;
    private ScriptConsoleHistory history;
    private int offset;
    private IDocument doc;
    private int disconnectionLevel = 0;
    private long lastChangeMillis;
    private String initialCommands;
    private IScriptConsoleViewer2ForDocumentListener viewer;
    private List<WeakReference<IScriptConsoleViewer2ForDocumentListener>> otherViewers = new ArrayList<WeakReference<IScriptConsoleViewer2ForDocumentListener>>();
    IDocument EMPTY_DOCUMENT = new Document();
    private PyAutoIndentStrategy strategy = new PyAutoIndentStrategy();
    private List<IConsoleLineTracker> consoleLineTrackers;

    public long getLastChangeMillis() {
        return this.lastChangeMillis;
    }

    public ScriptConsoleDocumentListener() {
        this.lastChangeMillis = System.currentTimeMillis();
    }

    public PyAutoIndentStrategy getIndentStrategy() {
        return this.strategy;
    }

    protected synchronized void reconnect(IDocument oldDoc, IDocument newDoc) {
        Assert.isTrue((this.disconnectionLevel == 0 ? 1 : 0) != 0);
        if (oldDoc != null) {
            oldDoc.removeDocumentListener((IDocumentListener)this);
        }
        newDoc.addDocumentListener((IDocumentListener)this);
        this.doc = newDoc;
    }

    protected synchronized void startDisconnected() {
        if (this.disconnectionLevel == 0) {
            this.doc.removeDocumentListener((IDocumentListener)this);
        }
        ++this.disconnectionLevel;
    }

    protected synchronized void stopDisconnected() {
        --this.disconnectionLevel;
        if (this.disconnectionLevel == 0) {
            this.doc.addDocumentListener((IDocumentListener)this);
        }
    }

    public void clear(boolean addInitialCommands) {
        this.startDisconnected();
        try {
            this.doc.set("");
            this.appendInvitation(true);
        }
        finally {
            this.stopDisconnected();
        }
        if (addInitialCommands) {
            try {
                this.doc.replace(this.doc.getLength(), 0, this.initialCommands);
            }
            catch (BadLocationException e) {
                Log.log((Throwable)e);
            }
        }
    }

    public void addViewer(IScriptConsoleViewer2ForDocumentListener scriptConsoleViewer) {
        this.otherViewers.add(new WeakReference<IScriptConsoleViewer2ForDocumentListener>(scriptConsoleViewer));
    }

    public ScriptConsoleDocumentListener(IScriptConsoleViewer2ForDocumentListener viewer, ICommandHandler handler, ScriptConsolePrompt prompt, ScriptConsoleHistory history, List<IConsoleLineTracker> consoleLineTrackers, String initialCommands) {
        this.prompt = prompt;
        this.handler = handler;
        this.history = history;
        this.viewer = viewer;
        this.offset = 0;
        this.doc = null;
        this.consoleLineTrackers = consoleLineTrackers;
        this.initialCommands = initialCommands;
    }

    public void setDocument(IDocument doc) {
        this.reconnect(this.doc, doc);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    protected void processResult(InterpreterResponse result) {
        if (result != null) {
            this.addToConsoleView(result.out, true);
            this.addToConsoleView(result.err, false);
            this.history.commit();
            try {
                this.offset = this.getLastLineLength();
            }
            catch (BadLocationException e) {
                Log.log((Throwable)e);
            }
        }
        this.appendInvitation(false);
    }

    private void addToConsoleView(String out, boolean stdout) {
        if (out.length() == 0) {
            return;
        }
        int start = this.doc.getLength();
        IConsoleStyleProvider styleProvider = this.viewer.getStyleProvider();
        Tuple<List<ScriptStyleRange>, String> style = null;
        if (styleProvider != null && (style = stdout ? styleProvider.createInterpreterOutputStyle(out, start) : styleProvider.createInterpreterErrorStyle(out, start)) != null) {
            for (ScriptStyleRange s : (List)style.o1) {
                this.addToPartitioner(s);
            }
        }
        if (style != null) {
            this.appendText((String)style.o2);
        }
        PySelection ps = new PySelection(this.doc, start);
        int cursorLine = ps.getCursorLine();
        int numberOfLines = this.doc.getNumberOfLines();
        int i = cursorLine;
        while (i < numberOfLines) {
            try {
                int offset = ps.getLineOffset(i);
                int endOffset = ps.getEndLineOffset(i);
                Region region = new Region(offset, endOffset - offset);
                for (IConsoleLineTracker lineTracker : this.consoleLineTrackers) {
                    lineTracker.lineAppended((IRegion)region);
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
            ++i;
        }
    }

    private void addToPartitioner(ScriptStyleRange style) {
        IDocumentPartitioner partitioner = this.doc.getDocumentPartitioner();
        if (partitioner instanceof ScriptConsolePartitioner) {
            ScriptConsolePartitioner scriptConsolePartitioner = (ScriptConsolePartitioner)partitioner;
            scriptConsolePartitioner.addRange(style);
        }
    }

    protected void proccessAddition(int offset, String text) {
        String indentString = "";
        boolean addedNewLine = false;
        boolean addedParen = false;
        boolean addedCloseParen = false;
        int addedLen = text.length();
        if (addedLen == 1) {
            if (text.equals("\r") || text.equals("\n")) {
                addedNewLine = true;
            } else if (text.equals("(")) {
                addedParen = true;
            } else if (text.equals(")")) {
                addedCloseParen = true;
            }
        } else if (addedLen == 2 && text.equals("\r\n")) {
            addedNewLine = true;
        }
        String delim = this.getDelimeter();
        int newDeltaCaretPosition = this.doc.getLength() - (offset + text.length());
        try {
            boolean offset_in_command_line;
            this.doc.replace(offset, text.length(), "");
            boolean bl = offset_in_command_line = offset >= this.getCommandLineOffset();
            if (!offset_in_command_line) {
                offset = newDeltaCaretPosition = this.getCommandLineOffset();
                text = String.valueOf(this.doc.get(this.getCommandLineOffset(), this.getCommandLineLength())) + text;
                this.doc.replace(this.getCommandLineOffset(), this.getCommandLineLength(), "");
            } else {
                text = String.valueOf(text) + this.doc.get(offset, this.doc.getLength() - offset);
                this.doc.replace(offset, this.doc.getLength() - offset, "");
            }
        }
        catch (BadLocationException e) {
            text = "";
            Log.log((Throwable)e);
        }
        text = text.replaceAll("\r\n|\n|\r", delim);
        int start = 0;
        int index = -1;
        ArrayList<String> commands = new ArrayList<String>();
        while ((index = text.indexOf(delim, start)) != -1) {
            String cmd = text.substring(start, index);
            cmd = this.convertTabs(cmd);
            commands.add(cmd);
            start = index + delim.length();
        }
        String[] finalIndentString = new String[]{indentString};
        if (commands.size() > 0) {
            this.startDisconnected();
            String cmd = (String)commands.get(0);
            this.execCommand(addedNewLine, delim, finalIndentString, cmd, commands, 0, text, addedParen, start, addedCloseParen, newDeltaCaretPosition);
        } else {
            this.onAfterAllLinesHandled(text, addedParen, start, offset, addedCloseParen, finalIndentString[0], newDeltaCaretPosition);
        }
    }

    private void execCommand(boolean addedNewLine, String delim, final String[] finalIndentString, String cmd, final List<String> commands, final int currentCommand, final String text, final boolean addedParen, final int start, final boolean addedCloseParen, final int newDeltaCaretPosition) {
        this.applyStyleToUserAddedText(cmd, this.doc.getLength());
        this.appendText(cmd);
        final String commandLine = this.getCommandLine();
        this.history.update(commandLine);
        this.appendText(this.getDelimeter());
        final boolean finalAddedNewLine = addedNewLine;
        final String finalDelim = delim;
        ICallback<Object, InterpreterResponse> onResponseReceived = new ICallback<Object, InterpreterResponse>(){

            public Object call(final InterpreterResponse arg) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        try {
                            IDocument historyDoc;
                            int currHistoryLen;
                            ScriptConsoleDocumentListener.this.processResult(arg);
                            if (finalAddedNewLine && (currHistoryLen = (historyDoc = ScriptConsoleDocumentListener.this.history.getAsDoc()).getLength()) > 0) {
                                DocCmd docCmd = new DocCmd(currHistoryLen - 1, 0, finalDelim);
                                ScriptConsoleDocumentListener.this.strategy.customizeNewLine(historyDoc, docCmd);
                                finalIndentString[0] = docCmd.text.replaceAll("\\r\\n|\\n|\\r", "");
                                if (currHistoryLen != historyDoc.getLength()) {
                                    Log.log((String)"Error: the document passed to the customizeNewLine should not be changed!");
                                }
                            }
                        }
                        catch (Throwable e) {
                            Log.log((Throwable)e);
                        }
                        if (currentCommand + 1 < commands.size()) {
                            ScriptConsoleDocumentListener.this.execCommand(finalAddedNewLine, finalDelim, finalIndentString, (String)commands.get(currentCommand + 1), commands, currentCommand + 1, text, addedParen, start, addedCloseParen, newDeltaCaretPosition);
                        } else {
                            try {
                                ScriptConsoleDocumentListener.this.onAfterAllLinesHandled(text, addedParen, start, ScriptConsoleDocumentListener.this.offset, addedCloseParen, finalIndentString[0], newDeltaCaretPosition);
                            }
                            finally {
                                ScriptConsoleDocumentListener.this.stopDisconnected();
                            }
                        }
                    }
                };
                RunInUiThread.async((Runnable)runnable);
                return null;
            }
        };
        ICallback<Object, Tuple<String, String>> onContentsReceived = new ICallback<Object, Tuple<String, String>>(){

            public Object call(final Tuple<String, String> result) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        if (result != null) {
                            ScriptConsoleDocumentListener.this.addToConsoleView((String)result.o1, true);
                            ScriptConsoleDocumentListener.this.addToConsoleView((String)result.o2, false);
                            ScriptConsoleDocumentListener.this.revealEndOfDocument();
                        }
                    }
                };
                RunInUiThread.async((Runnable)runnable);
                return null;
            }
        };
        new Thread((ICallback)onResponseReceived, (ICallback)onContentsReceived){
            private final /* synthetic */ ICallback val$onResponseReceived;
            private final /* synthetic */ ICallback val$onContentsReceived;
            {
                this.val$onResponseReceived = iCallback;
                this.val$onContentsReceived = iCallback2;
            }

            public void run() {
                ScriptConsoleDocumentListener.this.handler.handleCommand(commandLine, (ICallback<Object, InterpreterResponse>)this.val$onResponseReceived, (ICallback<Object, Tuple<String, String>>)this.val$onContentsReceived);
            }
        }.start();
    }

    private void onAfterAllLinesHandled(String finalText, boolean finalAddedParen, int finalStart, int finalOffset, boolean finalAddedCloseParen, String finalIndentString, int finalNewDeltaCaretPosition) {
        String cmdLine;
        boolean shiftsCaret = true;
        String newText = finalText.substring(finalStart, finalText.length());
        if (finalAddedParen) {
            cmdLine = this.getCommandLine();
            Document parenDoc = new Document(String.valueOf(cmdLine) + newText);
            int currentOffset = cmdLine.length() + 1;
            DocCmd docCmd = new DocCmd(currentOffset, 0, "(");
            docCmd.shiftsCaret = true;
            try {
                PyAutoIndentStrategy.customizeParenthesis((IDocument)parenDoc, docCmd, true, this.strategy.getIndentPrefs());
            }
            catch (BadLocationException e) {
                Log.log((Throwable)e);
            }
            newText = String.valueOf(docCmd.text) + newText.substring(1);
            if (!docCmd.shiftsCaret) {
                shiftsCaret = false;
                this.setCaretOffset(finalOffset + (docCmd.caretOffset - currentOffset));
            }
        } else if (finalAddedCloseParen) {
            cmdLine = this.getCommandLine();
            String existingDoc = String.valueOf(cmdLine) + finalText.substring(1);
            int cmdLineOffset = cmdLine.length();
            if (existingDoc.length() > cmdLineOffset) {
                boolean canSkipOpenParenthesis;
                Document parenDoc = new Document(existingDoc);
                DocCmd docCmd = new DocCmd(cmdLineOffset, 0, ")");
                docCmd.shiftsCaret = true;
                try {
                    canSkipOpenParenthesis = this.strategy.canSkipCloseParenthesis((IDocument)parenDoc, docCmd);
                }
                catch (BadLocationException e) {
                    canSkipOpenParenthesis = false;
                    Log.log((Throwable)e);
                }
                if (canSkipOpenParenthesis) {
                    shiftsCaret = false;
                    this.setCaretOffset(finalOffset + 1);
                    newText = newText.substring(1);
                }
            }
        }
        String cmd = String.valueOf(finalIndentString) + newText;
        cmd = this.convertTabs(cmd);
        this.applyStyleToUserAddedText(cmd, this.doc.getLength());
        this.appendText(cmd);
        if (shiftsCaret) {
            this.setCaretOffset(this.doc.getLength() - finalNewDeltaCaretPosition);
        }
        this.history.update(this.getCommandLine());
    }

    private String convertTabs(String cmd) {
        DocCmd newStr = new DocCmd(0, 0, cmd);
        this.strategy.getIndentPrefs().convertToStd(this.EMPTY_DOCUMENT, (DocumentCommand)newStr);
        cmd = newStr.text;
        return cmd;
    }

    private void applyStyleToUserAddedText(String cmd, int offset2) {
        ScriptStyleRange style;
        IConsoleStyleProvider styleProvider = this.viewer.getStyleProvider();
        if (styleProvider != null && (style = styleProvider.createUserInputStyle(cmd, offset2)) != null) {
            this.addToPartitioner(style);
        }
    }

    public void documentChanged(DocumentEvent event) {
        this.lastChangeMillis = System.currentTimeMillis();
        this.startDisconnected();
        try {
            int eventOffset = event.getOffset();
            String eventText = event.getText();
            this.proccessAddition(eventOffset, eventText);
        }
        finally {
            this.stopDisconnected();
        }
    }

    protected void appendText(String text) {
        int initialOffset = this.doc.getLength();
        try {
            this.doc.replace(initialOffset, 0, text);
        }
        catch (BadLocationException e) {
            Log.log((Throwable)e);
        }
    }

    protected void appendInvitation(boolean async) {
        ScriptStyleRange style;
        int start = this.doc.getLength();
        String promptStr = this.prompt.toString();
        IConsoleStyleProvider styleProvider = this.viewer.getStyleProvider();
        if (styleProvider != null && (style = styleProvider.createPromptStyle(promptStr, start)) != null) {
            this.addToPartitioner(style);
        }
        this.appendText(promptStr);
        this.setCaretOffset(this.doc.getLength(), async);
        this.revealEndOfDocument();
    }

    private void revealEndOfDocument() {
        this.viewer.revealEndOfDocument();
        Iterator<WeakReference<IScriptConsoleViewer2ForDocumentListener>> it = this.otherViewers.iterator();
        while (it.hasNext()) {
            WeakReference<IScriptConsoleViewer2ForDocumentListener> ref = it.next();
            IScriptConsoleViewer2ForDocumentListener v = (IScriptConsoleViewer2ForDocumentListener)ref.get();
            if (v == null) {
                it.remove();
                continue;
            }
            v.revealEndOfDocument();
        }
    }

    private void setCaretOffset(int offset) {
        this.setCaretOffset(offset, false);
    }

    private void setCaretOffset(int offset, boolean async) {
        this.viewer.setCaretOffset(offset, async);
        Iterator<WeakReference<IScriptConsoleViewer2ForDocumentListener>> it = this.otherViewers.iterator();
        while (it.hasNext()) {
            WeakReference<IScriptConsoleViewer2ForDocumentListener> ref = it.next();
            IScriptConsoleViewer2ForDocumentListener v = (IScriptConsoleViewer2ForDocumentListener)ref.get();
            if (v == null) {
                it.remove();
                continue;
            }
            v.setCaretOffset(offset, async);
        }
    }

    public String getDelimeter() {
        return TextUtilities.getDefaultLineDelimiter((IDocument)this.doc);
    }

    public int getLastLineLength() throws BadLocationException {
        int lastLine = this.doc.getNumberOfLines() - 1;
        return this.doc.getLineLength(lastLine);
    }

    public int getLastLineOffset() throws BadLocationException {
        int lastLine = this.doc.getNumberOfLines() - 1;
        return this.doc.getLineOffset(lastLine);
    }

    public int getLastLineReadOnlySize() {
        return this.offset + this.prompt.toString().length();
    }

    public int getCommandLineOffset() throws BadLocationException {
        int lastLine = this.doc.getNumberOfLines() - 1;
        return this.doc.getLineOffset(lastLine) + this.getLastLineReadOnlySize();
    }

    public int getCommandLineLength() throws BadLocationException {
        int lastLine = this.doc.getNumberOfLines() - 1;
        return this.doc.getLineLength(lastLine) - this.getLastLineReadOnlySize();
    }

    public String getCommandLine() {
        int commandLineLength;
        int commandLineOffset;
        try {
            commandLineOffset = this.getCommandLineOffset();
            commandLineLength = this.getCommandLineLength();
        }
        catch (BadLocationException e1) {
            Log.log((Throwable)e1);
            return "";
        }
        if (commandLineLength < 0) {
            return "";
        }
        try {
            return this.doc.get(commandLineOffset, commandLineLength);
        }
        catch (BadLocationException badLocationException) {
            Log.log((String)StringUtils.format((String)"Error: bad location: offset:%s text:%s", (Object[])new Object[]{commandLineOffset, commandLineLength}));
            return "";
        }
    }

    public void setCommandLine(String command) throws BadLocationException {
        this.doc.replace(this.getCommandLineOffset(), this.getCommandLineLength(), command);
    }
}

