/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.todo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.builder.PyDevBuilderVisitor;
import org.python.pydev.builder.PydevMarkerUtils;
import org.python.pydev.builder.todo.PyTodoPrefPage;
import org.python.pydev.core.callbacks.ICallback0;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.logging.DebugSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyTodoVisitor
extends PyDevBuilderVisitor {
    @Override
    public void visitChangedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
        if (document != null) {
            List<String> todoTags = PyTodoPrefPage.getTodoTags();
            try {
                if (!this.isResourceInPythonpathProjectSources(resource, this.getPythonNature(resource), false)) {
                    PydevMarkerUtils.removeMarkers(resource, "org.eclipse.core.resources.taskmarker");
                    return;
                }
            }
            catch (Exception e1) {
                Log.log((Throwable)e1);
                return;
            }
            try {
                PydevMarkerUtils.replaceMarkers(this.computeTodoMarkers((IDocument)document.call(), todoTags), resource, "org.eclipse.core.resources.taskmarker", false, monitor);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
    }

    List<PydevMarkerUtils.MarkerInfo> computeTodoMarkers(IDocument document, List<String> todoTags) throws BadLocationException {
        ArrayList<PydevMarkerUtils.MarkerInfo> lst = new ArrayList<PydevMarkerUtils.MarkerInfo>();
        if (todoTags.size() > 0) {
            ParsingUtils utils = ParsingUtils.create((Object)document);
            int len = utils.len();
            try {
                int i = 0;
                while (i < len) {
                    char c = utils.charAt(i);
                    switch (c) {
                        case '\"': 
                        case '\'': {
                            int j = utils.eatLiterals(null, i);
                            this.check(i, j, document, lst, todoTags);
                            i = j;
                            break;
                        }
                        case '#': {
                            int j = utils.eatComments(null, i);
                            this.check(i, j, document, lst, todoTags);
                            i = j;
                        }
                    }
                    ++i;
                }
            }
            catch (BadLocationException badLocationException) {
            }
            catch (SyntaxErrorException e) {
                Log.log((Throwable)e);
            }
            if (DebugSettings.DEBUG_ANALYSIS_REQUESTS) {
                Log.toLogFile((Object)this, (String)"Adding todo markers");
            }
        }
        return lst;
    }

    private void check(int i, int j, IDocument document, List<PydevMarkerUtils.MarkerInfo> lst, List<String> todoTags) throws BadLocationException {
        String tok = document.get(i, j - i);
        HashSet<Integer> lines = new HashSet<Integer>();
        for (String element : todoTags) {
            int index;
            if (element.length() == 0) continue;
            int start = 0;
            while ((index = tok.indexOf(element, start)) != -1) {
                start = index + element.length();
                int absoluteStart = i + index;
                int line = document.getLineOfOffset(absoluteStart);
                if (lines.contains(line)) continue;
                lines.add(line);
                String message = tok.substring(index).trim();
                String markerType = "org.eclipse.core.resources.taskmarker";
                int severity = 1;
                boolean userEditable = false;
                boolean isTransient = false;
                int absoluteEnd = absoluteStart + message.length();
                Map<String, Object> additionalInfo = null;
                PydevMarkerUtils.MarkerInfo markerInfo = new PydevMarkerUtils.MarkerInfo(document, message, markerType, severity, userEditable, isTransient, line, absoluteStart, absoluteEnd, additionalInfo);
                lst.add(markerInfo);
            }
        }
    }

    @Override
    public void visitRemovedResource(IResource resource, ICallback0<IDocument> document, IProgressMonitor monitor) {
    }
}

