/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.grammarcommon;

import java.util.ArrayList;
import java.util.List;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.grammarcommon.AbstractGrammarWalkHelpers;
import org.python.pydev.parser.grammarcommon.AbstractTokenManager;
import org.python.pydev.parser.grammarcommon.EmptySuiteException;
import org.python.pydev.parser.grammarcommon.IJJTPythonGrammarState;
import org.python.pydev.parser.grammarcommon.TokensIterator;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGrammarErrorHandlers
extends AbstractGrammarWalkHelpers {
    public static final boolean DEBUG_SHOW_PARSE_ERRORS = PyParser.DEBUG_SHOW_PARSE_ERRORS;
    public static final boolean DEBUG_SHOW_LOADED_TOKENS = false;
    protected int lastSuiteStartCol = -1;
    protected int parseExceptions = 0;
    private final List<ParseException> parseErrors = new ArrayList<ParseException>();

    protected final void markLastAsSuiteStart() {
        Token currentToken = this.getCurrentToken();
        this.lastSuiteStartCol = currentToken.beginColumn;
    }

    protected abstract IJJTPythonGrammarState getJJTree();

    public List<ParseException> getParseErrors() {
        return this.parseErrors;
    }

    private void addParseError(ParseException e) {
        this.parseErrors.add(e);
    }

    public Throwable getErrorOnParsing() {
        if (this.parseErrors != null && this.parseErrors.size() > 0) {
            return this.parseErrors.get(0);
        }
        return null;
    }

    public final void addAndReport(ParseException e, String msg) throws ParseException {
        if (DEBUG_SHOW_PARSE_ERRORS) {
            System.err.println("\n\n\n\n\n---------------------------------\n" + msg);
            e.printStackTrace();
        }
        this.addParseError(e);
        ++this.parseExceptions;
        if (this.parseExceptions > 100) {
            throw e;
        }
    }

    protected final void handleErrorInIndent(ParseException e) throws ParseException {
        this.addAndReport(e, "Handle no indent");
        TokensIterator iterTokens = this.getTokensIterator(this.getCurrentToken(), 3, false);
        iterTokens.next();
        if (!iterTokens.hasNext()) {
            throw new EmptySuiteException();
        }
        Token nextToken = iterTokens.next();
        if (nextToken.beginColumn <= this.lastSuiteStartCol) {
            throw new EmptySuiteException();
        }
    }

    protected final void handleNoEof(ParseException e) throws ParseException {
        this.addAndReport(e, "Handle no EOF");
    }

    protected final void handleErrorInImport(ParseException e) throws ParseException {
        this.addAndReport(e, "Handle error in import");
    }

    protected final void handleRParensNearButNotCurrent(ParseException e) throws ParseException {
        this.addAndReport(e, "Handle parens near but not current");
        Token t = this.getCurrentToken();
        AbstractTokenManager tokenManager = this.getTokenManager();
        int rparenId = tokenManager.getRparenId();
        while (t != null && t.kind != rparenId) {
            t = t.next;
        }
        if (t != null && t.kind == rparenId) {
            this.setCurrentToken(t);
        }
    }

    protected final void handleErrorInDedent(ParseException e) throws ParseException {
        this.addAndReport(e, "Handle dedent");
        AbstractTokenManager tokenManager = this.getTokenManager();
        int indentId = tokenManager.getIndentId();
        int dedentId = tokenManager.getDedentId();
        int level = 0;
        TokensIterator iterTokens = this.getTokensIterator(this.getCurrentToken(), 50, false);
        while (iterTokens.hasNext()) {
            Token next = iterTokens.next();
            if (level == 0 && next.kind == dedentId) {
                this.setCurrentToken(next);
                break;
            }
            if (next.kind == indentId) {
                ++level;
                continue;
            }
            if (next.kind != dedentId) continue;
            --level;
        }
    }

    protected final void handleErrorInStmt(ParseException e) throws ParseException {
        this.addAndReport(e, "Handle error in stmt");
    }

    protected final void handleErrorInCompountStmt(ParseException e) throws ParseException {
        this.addAndReport(e, "Handle error in compount stmt");
    }

    protected final void handleNoNewline(ParseException e) throws ParseException {
        this.addAndReport(e, "Handle no newline");
    }

    protected final void handleNoValInDict(ParseException e) throws ParseException {
        this.addAndReport(e, "No value for dict key");
    }

    protected final void handleNoNewlineInSuiteFound() throws ParseException {
        this.addAndReport(new ParseException("No new line found.", this.getCurrentToken()), "Handle no new line in suite");
    }

    protected final void handleNoSuiteMatch(ParseException e) throws ParseException {
        this.addAndReport(e, "Handle no suite match");
    }

    protected final Token handleErrorInName(ParseException e) throws ParseException {
        this.addAndReport(e, "Handle name");
        Token currentToken = this.getCurrentToken();
        return this.getTokenManager().createFrom(currentToken, this.getTokenManager().getNameId(), "!<MissingName>!");
    }
}

