/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.customizations.app_engine.wizards;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.customizations.CustomizationsPlugin;

public class AppEngineTemplatePage
extends WizardPage {
    protected static final String CHOOSE_ONE = "-- Choose One --";
    protected static final String EMPTY_PROJECT = "Empty Project";
    protected Map<String, Tuple<String, File>> templateNamesAndDescriptions;
    protected Combo comboTemplateNames;
    protected Label templateDescription;
    protected String lastTemplateChoice = "";
    private Text appIdText;
    private String lastAppIdText = "sample-app";

    protected AppEngineTemplatePage(String pageName) {
        super(pageName);
        this.setChooseOneErrorMessage();
    }

    private void setChooseOneErrorMessage() {
        this.setErrorMessage("Please select the template to use to create the project");
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.setFillHorizontalLayoutDataAndFont((Control)composite, font);
        Label appIdLabel = new Label(composite, 0);
        appIdLabel.setText("What's the application id registered for this project?");
        this.setFillHorizontalLayoutDataAndFont((Control)appIdLabel, font);
        this.appIdText = new Text(composite, 2048);
        this.appIdText.setText(this.lastAppIdText);
        this.setFillHorizontalLayoutDataAndFont((Control)this.appIdText, font);
        this.appIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AppEngineTemplatePage.this.handleChange();
            }
        });
        Label templateLabel = new Label(composite, 0);
        templateLabel.setText("From which template do you want to create your new Google App Project?");
        this.setFillHorizontalLayoutDataAndFont((Control)templateLabel, font);
        this.comboTemplateNames = new Combo(composite, 2048);
        this.templateNamesAndDescriptions = new HashMap<String, Tuple<String, File>>();
        try {
            this.loadTemplates();
        }
        catch (CoreException e1) {
            Log.log((Throwable)e1);
        }
        ArrayList<String> keys = new ArrayList<String>(this.templateNamesAndDescriptions.keySet());
        Collections.sort(keys);
        keys.add(0, EMPTY_PROJECT);
        keys.add(0, CHOOSE_ONE);
        this.comboTemplateNames.setItems(keys.toArray(new String[0]));
        this.comboTemplateNames.setText(CHOOSE_ONE);
        this.setFillHorizontalLayoutDataAndFont((Control)this.comboTemplateNames, font);
        this.comboTemplateNames.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AppEngineTemplatePage.this.handleChange();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.templateDescription = new Label(composite, 0);
        this.templateDescription.setText("");
        this.setFillHorizontalLayoutDataAndFont((Control)this.templateDescription, font);
        this.setControl((Control)composite);
    }

    private void setFillHorizontalLayoutDataAndFont(Control control, Font font) {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        control.setLayoutData((Object)data);
        control.setFont(font);
    }

    private void loadTemplates() throws CoreException {
        File[] files;
        File relativePath = CustomizationsPlugin.getBundleInfo().getRelativePath((IPath)new Path("templates/google_app_engine"));
        File[] fileArray = files = relativePath.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            if (dir.isDirectory()) {
                File[] secondLevelFiles;
                File[] fileArray2 = secondLevelFiles = dir.listFiles();
                int n3 = secondLevelFiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file2 = fileArray2[n4];
                    if (file2.getName().equals("description.txt")) {
                        String fileContents = REF.getFileContents((File)file2).trim();
                        Tuple nameAndDesc = StringUtils.splitOnFirst((String)fileContents, (char)':');
                        this.templateNamesAndDescriptions.put((String)nameAndDesc.o1, (Tuple<String, File>)new Tuple((Object)((String)nameAndDesc.o2), (Object)dir));
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    protected void handleChange() {
        this.lastTemplateChoice = this.comboTemplateNames.getText();
        this.lastAppIdText = this.appIdText.getText();
        Tuple<String, File> description = this.templateNamesAndDescriptions.get(this.lastTemplateChoice);
        this.templateDescription.setText(description != null ? (String)description.o1 : "");
        boolean hasError = false;
        if (this.lastTemplateChoice.equals(CHOOSE_ONE)) {
            this.setChooseOneErrorMessage();
            hasError = true;
        } else if (this.lastAppIdText == null || this.lastAppIdText.trim().length() == 0) {
            this.setErrorMessage("Please fill the application id (registered in Google App Engine).");
            hasError = true;
        }
        if (!hasError) {
            this.setErrorMessage(null);
        }
    }

    public void fillSourceFolder(IContainer sourceFolder) {
        Tuple<String, File> tuple;
        if (this.lastTemplateChoice != null && !this.lastTemplateChoice.equals(CHOOSE_ONE) && !this.lastTemplateChoice.equals(EMPTY_PROJECT) && (tuple = this.templateNamesAndDescriptions.get(this.lastTemplateChoice)) != null && ((File)tuple.o2).isDirectory()) {
            try {
                REF.copyDirectory((File)((File)tuple.o2), (File)sourceFolder.getLocation().toFile(), (ICallback)new ICallback<Boolean, File>(){

                    public Boolean call(File arg) {
                        String filename = arg.getName().toLowerCase();
                        if (filename.equals("description.txt") || filename.equals(".svn") || filename.equals("cvs")) {
                            return true;
                        }
                        return false;
                    }
                }, (ICallback)new ICallback<String, String>(){

                    public String call(String contents) {
                        return StringUtils.replaceAll((String)contents, (String)"${app_id}", (String)AppEngineTemplatePage.this.lastAppIdText);
                    }
                });
            }
            catch (IOException e) {
                Log.log((Throwable)e);
            }
            try {
                sourceFolder.refreshLocal(2, null);
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        }
    }
}

