/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.debug.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.debug.core.IConsoleInputListener;
import org.python.pydev.debug.model.AbstractDebugTarget;

public final class ProcessServerOutputStream
extends ByteArrayOutputStream {
    final List<IConsoleInputListener> participants = ExtensionHelper.getParticipants((String)"org.python.pydev.debug.pydev_debug_console_input_listener");

    public synchronized void write(int b) {
        super.write(b);
        this.checkFinishedLine();
    }

    public synchronized void write(byte[] b, int off, int len) {
        super.write(b, off, len);
        this.checkFinishedLine();
    }

    public void write(byte[] b) throws IOException {
        super.write(b);
        this.checkFinishedLine();
    }

    private void checkFinishedLine() {
        IAdaptable context;
        char c;
        String s = this.toString();
        this.reset();
        if (s.length() > 0 && ((c = s.charAt(s.length() - 1)) == '\n' || c == '\r') && (context = DebugUITools.getDebugContext()) != null) {
            s = StringUtils.rightTrim((String)s);
            Object adapter = context.getAdapter(IDebugTarget.class);
            if (adapter instanceof AbstractDebugTarget) {
                AbstractDebugTarget target = (AbstractDebugTarget)adapter;
                for (IConsoleInputListener listener : this.participants) {
                    listener.newLineReceived(s, target);
                }
            }
        }
    }
}

