/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.utils;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryTraverser
implements Iterable<String> {
    private Pattern filter;
    private File baseDirectory;

    public DirectoryTraverser(File baseDirectory, Pattern filter) {
        this.filter = filter;
        this.baseDirectory = baseDirectory;
        File directory = baseDirectory;
        if (!directory.exists()) {
            throw new RuntimeException("Given directory doesn't exist");
        }
        if (!directory.isDirectory()) {
            throw new RuntimeException("Specified path is not a directory");
        }
    }

    public List<String> getAllFiles() {
        LinkedList<String> files = new LinkedList<String>();
        this.traverse("", files);
        return files;
    }

    @Override
    public Iterator<String> iterator() {
        return this.getAllFiles().iterator();
    }

    private void traverse(String relDir, List<String> files) {
        File currentDir = new File(this.baseDirectory, relDir);
        String[] stringArray = currentDir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entryName = stringArray[n2];
            File absEntry = new File(currentDir, entryName);
            String relPath = relDir.length() != 0 ? String.valueOf(relDir) + entryName : entryName;
            if (absEntry.isDirectory()) {
                this.traverse(String.valueOf(relPath) + File.separator, files);
            } else {
                Matcher matcher = this.filter.matcher(absEntry.getAbsolutePath());
                if (matcher.matches()) {
                    files.add(relPath);
                }
            }
            ++n2;
        }
    }
}

