/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.refactorer;

import com.python.pydev.refactoring.IPyRefactoring2;
import com.python.pydev.refactoring.refactorer.RefactorerFindDefinition;
import com.python.pydev.refactoring.refactorer.RefactorerFinds;
import com.python.pydev.refactoring.wizards.rename.PyRenameEntryPoint;
import com.python.pydev.refactoring.wizards.rename.PyRenameRefactoringWizard;
import com.python.pydev.ui.hierarchy.HierarchyNodeModel;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codecompletion.revisited.visitors.AssignDefinition;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.refactoring.AbstractPyRefactoring;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.editor.refactoring.TooManyMatchesException;
import org.python.pydev.parser.visitors.scope.ASTEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Refactorer
extends AbstractPyRefactoring
implements IPyRefactoring2 {
    public String getName() {
        return "PyDev Extensions Refactorer";
    }

    public String rename(RefactoringRequest request) {
        try {
            RenameRefactoring renameRefactoring = new RenameRefactoring((RenameProcessor)new PyRenameEntryPoint(request));
            request.fillInitialNameAndOffset();
            PyRenameRefactoringWizard wizard = new PyRenameRefactoringWizard((Refactoring)renameRefactoring, "Rename", "inputPageDescription", request, request.initialName);
            try {
                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                op.run(PyAction.getShell(), "Rename Refactor Action");
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }

    public ItemPointer[] findDefinition(RefactoringRequest request) throws TooManyMatchesException {
        return new RefactorerFindDefinition().findDefinition(request);
    }

    public boolean areAllInSameClassHierarchy(List<AssignDefinition> defs) {
        return new RefactorerFinds(this).areAllInSameClassHierarchy(defs);
    }

    public HierarchyNodeModel findClassHierarchy(RefactoringRequest request, boolean findOnlyParents) {
        return new RefactorerFinds(this).findClassHierarchy(request, findOnlyParents);
    }

    public Map<Tuple<String, File>, HashSet<ASTEntry>> findAllOccurrences(RefactoringRequest req) throws OperationCanceledException, CoreException {
        PyRenameEntryPoint processor = new PyRenameEntryPoint(req);
        req.checkCancelled();
        IProgressMonitor monitor = req.getMonitor();
        try {
            monitor.beginTask("Find all occurrences", 100);
            monitor.setTaskName("Find all occurrences");
            try {
                req.pushMonitor((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                RefactoringStatus status = processor.checkInitialConditions(req.getMonitor());
                if (status.getSeverity() == 4) {
                    return null;
                }
            }
            finally {
                req.popMonitor().done();
            }
            {
            }
        }
        finally {
            monitor.done();
        }
    }
}

