/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui.launching;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.pydev.core.log.Log;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.PyDebugTarget;
import org.python.pydev.debug.model.PySourceLocator;
import org.python.pydev.debug.model.remote.RemoteDebugger;
import org.python.pydev.debug.pyunit.PyUnitServer;
import org.python.pydev.debug.pyunit.PyUnitView;
import org.python.pydev.debug.ui.launching.PythonRunnerCallbacks;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.SimpleRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonRunner {
    public static void run(PythonRunnerConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException, IOException {
        try {
            PyUnitServer pyUnitServer = null;
            if (config.isUnittest()) {
                pyUnitServer = config.createPyUnitServer(config, launch);
                PyUnitView.registerPyUnitServer(pyUnitServer);
            }
            if (config.isDebug) {
                PythonRunner.runDebug(config, launch, monitor);
            } else {
                PythonRunner.doIt(config, monitor, config.envp, config.getCommandLine(true), config.workingDirectory, launch);
            }
        }
        catch (JDTNotAvailableException e) {
            Log.log((Throwable)e);
            final Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError((Shell)display.getActiveShell(), (String)"Unable to run the selected configuration.", (String)e.getMessage());
                }
            });
        }
    }

    private static void runDebug(PythonRunnerConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException, IOException, JDTNotAvailableException {
        IProcess process;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 5);
        subMonitor.beginTask("Launching python", 1);
        RemoteDebugger debugger = new RemoteDebugger();
        debugger.startConnect((IProgressMonitor)subMonitor, config);
        subMonitor.subTask("Constructing command_line...");
        String[] cmdLine = config.getCommandLine(true);
        Process p = PythonRunner.createProcess(launch, config.envp, cmdLine, config.workingDirectory);
        HashMap<Object, Object> processAttributes = new HashMap<Object, Object>();
        processAttributes.put(IProcess.ATTR_CMDLINE, config.getCommandLineAsString());
        processAttributes.put("PYDEV_DEBUG_IPROCESS_ATTR", "true");
        PyDebugTarget t = new PyDebugTarget(launch, null, config.resource, debugger, config.project);
        try {
            t.process = process = PythonRunner.registerWithDebugPluginForProcessType(config.getRunningName(), launch, p, processAttributes, config);
        }
        finally {
            t.finishedInit = true;
        }
        subMonitor.subTask("Waiting for connection...");
        Socket socket = null;
        try {
            socket = debugger.waitForConnect((IProgressMonitor)subMonitor, p, process);
            if (socket == null) {
                debugger.dispose();
                return;
            }
        }
        catch (Exception ex) {
            process.terminate();
            p.destroy();
            String message = "Unexpected error setting up the debugger";
            if (ex instanceof SocketTimeoutException) {
                message = "Timed out after " + Float.toString(config.acceptTimeout / 1000) + " seconds while waiting for python script to connect.";
            }
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, message, ex));
        }
        subMonitor.subTask("Done");
        launch.setSourceLocator((ISourceLocator)new PySourceLocator());
        t.startTransmission(socket);
        t.initialize();
        t.addConsoleInputListener();
    }

    private static IProcess doIt(PythonRunnerConfig config, IProgressMonitor monitor, String[] envp, String[] cmdLine, File workingDirectory, ILaunch launch) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 5);
        subMonitor.beginTask("Launching python", 1);
        subMonitor.subTask("Constructing command_line...");
        String commandLineAsString = SimpleRunner.getArgumentsAsStr((String[])cmdLine, (String[])new String[0]);
        HashMap<Object, Object> processAttributes = new HashMap<Object, Object>();
        processAttributes.put(IProcess.ATTR_CMDLINE, commandLineAsString);
        subMonitor.subTask("Exec...");
        Process p = PythonRunner.createProcess(launch, envp, cmdLine, workingDirectory);
        String label = cmdLine[cmdLine.length - 1];
        if (config.isInteractive) {
            throw new RuntimeException("Interactive not supported here!");
        }
        IProcess process = PythonRunner.registerWithDebugPluginForProcessType(label, launch, p, processAttributes, config);
        subMonitor.subTask("Done");
        return process;
    }

    private static Process createProcess(ILaunch launch, String[] envp, String[] cmdLine, File workingDirectory) throws CoreException {
        Process p;
        String encoding = launch.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
        if (encoding != null && encoding.trim().length() > 0) {
            String[] s = new String[envp.length + 3];
            System.arraycopy(envp, 0, s, 0, envp.length);
            s[s.length - 3] = "PYDEV_COMPLETER_PYTHONPATH=" + PydevPlugin.getBundleInfo().getRelativePath((IPath)new Path("pysrc")).toString();
            s[s.length - 2] = "PYDEV_CONSOLE_ENCODING=" + encoding;
            s[s.length - 1] = "PYTHONIOENCODING=" + encoding;
            envp = s;
        }
        if ((p = DebugPlugin.exec((String[])cmdLine, (File)workingDirectory, (String[])envp)) == null) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Could not execute python process.", null));
        }
        PythonRunnerCallbacks.afterCreatedProcess.call((Object)p);
        return p;
    }

    private static IProcess registerWithDebugPluginForProcessType(String label, ILaunch launch, Process p, Map<Object, Object> processAttributes, PythonRunnerConfig config) {
        processAttributes.put(IProcess.ATTR_PROCESS_TYPE, config.getProcessType());
        processAttributes.put(IProcess.ATTR_PROCESS_LABEL, label);
        processAttributes.put("PYDEV_CONFIG_RUN", config.run);
        processAttributes.put("PYDEV_ADD_RELAUNCH_IPROCESS_ATTR", "true");
        processAttributes.put("org.eclipse.debug.core.capture_output", "true");
        return DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)label, processAttributes);
    }
}

