/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.newconsole.prefs;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.utils.MultiStringFieldEditor;

public class InteractiveConsolePrefs
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PREFERENCES_ID = "org.python.pydev.debug.newconsole.prefs.InteractiveConsolePrefs";

    public InteractiveConsolePrefs() {
        super(0);
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        ColorFieldEditor sysout = new ColorFieldEditor("pydevconsole_sysout_color", "Stdout color", p);
        ColorFieldEditor syserr = new ColorFieldEditor("pydevconsole_syserr_color", "Stderr color", p);
        ColorFieldEditor sysin = new ColorFieldEditor("pydevconsole_sysin_color", "Stdin color", p);
        ColorFieldEditor prompt = new ColorFieldEditor("pydevconsole_prompt_color", "Prompt color", p);
        ColorFieldEditor background = new ColorFieldEditor("pydevconsole_background_color", "Background color", p);
        ColorFieldEditor debugBackground = new ColorFieldEditor("pydevdebugconsole_background_color", "Debug console background color", p);
        this.addField((FieldEditor)sysout);
        this.addField((FieldEditor)syserr);
        this.addField((FieldEditor)sysin);
        this.addField((FieldEditor)prompt);
        this.addField((FieldEditor)background);
        this.addField((FieldEditor)debugBackground);
        this.addField((FieldEditor)new MultiStringFieldEditor("INITIAL_INTERPRETER_CMDS", "Initial\ninterpreter\ncommands:\n", p));
        this.addField((FieldEditor)new StringFieldEditor("INTERACTIVE_CONSOLE_VM_ARGS", "Vm Args for jython\n(used only on external\nprocess option):", p));
        this.addField((FieldEditor)new IntegerFieldEditor("INTERACTIVE_CONSOLE_MAXIMUM_CONNECTION_ATTEMPTS", "Maximum connection attempts\nfor initial communication:", p));
        this.addField((FieldEditor)new BooleanFieldEditor("INTERACTIVE_CONSOLE_FOCUS_ON_CONSOLE_START", "Focus console when it's started?", 1, p));
        this.addField((FieldEditor)new BooleanFieldEditor("INTERACTIVE_CONSOLE_SEND_INITIAL_COMMAND_WHEN_CREATED_FROM_EDITOR", "When creating console send\ncurrent selection/editor\ncontents for execution?", 1, p));
        this.addField((FieldEditor)new BooleanFieldEditor("INTERACTIVE_CONSOLE_FOCUS_ON_SEND_COMMAND", "Focus console when an evaluate\ncommand is sent from the editor?", 1, p));
        this.addField((FieldEditor)new BooleanFieldEditor("INTERACTIVE_CONSOLE_CONNECT_VARIABLE_VIEW", "Connect console to Variables Debug View?", 1, p));
    }

    public void init(IWorkbench workbench) {
        this.setDescription("PyDev interactive console preferences.");
        this.setPreferenceStore(PydevDebugPlugin.getDefault().getPreferenceStore());
    }

    public static int getMaximumAttempts() {
        PydevDebugPlugin plugin = PydevDebugPlugin.getDefault();
        if (plugin != null) {
            return plugin.getPreferenceStore().getInt("INTERACTIVE_CONSOLE_MAXIMUM_CONNECTION_ATTEMPTS");
        }
        return 50;
    }

    public static boolean getFocusConsoleOnStartup() {
        PydevDebugPlugin plugin = PydevDebugPlugin.getDefault();
        if (plugin != null) {
            return plugin.getPreferenceStore().getBoolean("INTERACTIVE_CONSOLE_FOCUS_ON_CONSOLE_START");
        }
        return true;
    }

    public static boolean getFocusConsoleOnSendCommand() {
        PydevDebugPlugin plugin = PydevDebugPlugin.getDefault();
        if (plugin != null) {
            return plugin.getPreferenceStore().getBoolean("INTERACTIVE_CONSOLE_FOCUS_ON_SEND_COMMAND");
        }
        return true;
    }

    public static boolean getConsoleConnectVariableView() {
        PydevDebugPlugin plugin = PydevDebugPlugin.getDefault();
        if (plugin != null) {
            return plugin.getPreferenceStore().getBoolean("INTERACTIVE_CONSOLE_CONNECT_VARIABLE_VIEW");
        }
        return false;
    }

    public static boolean getSendCommandOnCreationFromEditor() {
        PydevDebugPlugin plugin = PydevDebugPlugin.getDefault();
        if (plugin != null) {
            return plugin.getPreferenceStore().getBoolean("INTERACTIVE_CONSOLE_SEND_INITIAL_COMMAND_WHEN_CREATED_FROM_EDITOR");
        }
        return true;
    }
}

