/*
 * Decompiled with CFR 0.152.
 */
package org.python.parser.ast;

import java.io.DataOutputStream;
import java.io.IOException;
import org.python.parser.SimpleNode;
import org.python.parser.ast.VisitorIF;
import org.python.parser.ast.exprType;

public class Dict
extends exprType {
    public exprType[] keys;
    public exprType[] values;

    public Dict(exprType[] keys, exprType[] values) {
        this.keys = keys;
        this.values = values;
    }

    public Dict(exprType[] keys, exprType[] values, SimpleNode parent) {
        this(keys, values);
        this.beginLine = parent.beginLine;
        this.beginColumn = parent.beginColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Dict[");
        sb.append("keys=");
        sb.append(this.dumpThis(this.keys));
        sb.append(", ");
        sb.append("values=");
        sb.append(this.dumpThis(this.values));
        sb.append("]");
        return sb.toString();
    }

    public void pickle(DataOutputStream ostream) throws IOException {
        this.pickleThis(32, ostream);
        this.pickleThis(this.keys, ostream);
        this.pickleThis(this.values, ostream);
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitDict(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        int i;
        if (this.keys != null) {
            i = 0;
            while (i < this.keys.length) {
                if (this.keys[i] != null) {
                    this.keys[i].accept(visitor);
                }
                ++i;
            }
        }
        if (this.values != null) {
            i = 0;
            while (i < this.values.length) {
                if (this.values[i] != null) {
                    this.values[i].accept(visitor);
                }
                ++i;
            }
        }
    }
}

