/*
 * Decompiled with CFR 0.152.
 */
package org.python.parser;

import org.python.core.PyObject;
import org.python.parser.CtxVisitor;
import org.python.parser.DefaultArg;
import org.python.parser.ExtraArg;
import org.python.parser.ExtraArgValue;
import org.python.parser.IdentityNode;
import org.python.parser.JJTPythonGrammarState;
import org.python.parser.ParseException;
import org.python.parser.PythonGrammarTreeConstants;
import org.python.parser.SimpleNode;
import org.python.parser.ast.Assert;
import org.python.parser.ast.Assign;
import org.python.parser.ast.Attribute;
import org.python.parser.ast.AugAssign;
import org.python.parser.ast.BinOp;
import org.python.parser.ast.BoolOp;
import org.python.parser.ast.Break;
import org.python.parser.ast.Call;
import org.python.parser.ast.ClassDef;
import org.python.parser.ast.Compare;
import org.python.parser.ast.Continue;
import org.python.parser.ast.Delete;
import org.python.parser.ast.Dict;
import org.python.parser.ast.Ellipsis;
import org.python.parser.ast.Exec;
import org.python.parser.ast.Expr;
import org.python.parser.ast.Expression;
import org.python.parser.ast.ExtSlice;
import org.python.parser.ast.For;
import org.python.parser.ast.FunctionDef;
import org.python.parser.ast.Global;
import org.python.parser.ast.If;
import org.python.parser.ast.Import;
import org.python.parser.ast.ImportFrom;
import org.python.parser.ast.Index;
import org.python.parser.ast.Interactive;
import org.python.parser.ast.Lambda;
import org.python.parser.ast.List;
import org.python.parser.ast.ListComp;
import org.python.parser.ast.Module;
import org.python.parser.ast.Name;
import org.python.parser.ast.Num;
import org.python.parser.ast.Pass;
import org.python.parser.ast.Print;
import org.python.parser.ast.Raise;
import org.python.parser.ast.Repr;
import org.python.parser.ast.Return;
import org.python.parser.ast.Slice;
import org.python.parser.ast.Str;
import org.python.parser.ast.Subscript;
import org.python.parser.ast.Suite;
import org.python.parser.ast.TryExcept;
import org.python.parser.ast.TryFinally;
import org.python.parser.ast.Tuple;
import org.python.parser.ast.UnaryOp;
import org.python.parser.ast.Unicode;
import org.python.parser.ast.While;
import org.python.parser.ast.Yield;
import org.python.parser.ast.aliasType;
import org.python.parser.ast.argumentsType;
import org.python.parser.ast.excepthandlerType;
import org.python.parser.ast.exprType;
import org.python.parser.ast.keywordType;
import org.python.parser.ast.listcompType;
import org.python.parser.ast.sliceType;
import org.python.parser.ast.stmtType;

public class TreeBuilder
implements PythonGrammarTreeConstants {
    private JJTPythonGrammarState stack;
    CtxVisitor ctx;
    private static SimpleNode[] nodes = new SimpleNode[PythonGrammarTreeConstants.jjtNodeName.length];

    public TreeBuilder(JJTPythonGrammarState stack) {
        this.stack = stack;
        this.ctx = new CtxVisitor();
    }

    private stmtType[] makeStmts(int l) {
        stmtType[] stmts = new stmtType[l];
        int i = l - 1;
        while (i >= 0) {
            stmts[i] = (stmtType)this.stack.popNode();
            --i;
        }
        return stmts;
    }

    private stmtType[] popSuite() {
        return ((Suite)this.popNode()).body;
    }

    private exprType[] makeExprs() {
        if (this.stack.nodeArity() > 0 && this.peekNode().getId() == 87) {
            this.popNode();
        }
        return this.makeExprs(this.stack.nodeArity());
    }

    private exprType[] makeExprs(int l) {
        exprType[] exprs = new exprType[l];
        int i = l - 1;
        while (i >= 0) {
            exprs[i] = this.makeExpr();
            --i;
        }
        return exprs;
    }

    private exprType makeExpr(SimpleNode node) {
        return (exprType)node;
    }

    private exprType makeExpr() {
        return this.makeExpr((SimpleNode)this.stack.popNode());
    }

    private String makeIdentifier() {
        return ((Name)this.stack.popNode()).id;
    }

    private String[] makeIdentifiers() {
        int l = this.stack.nodeArity();
        String[] ids = new String[l];
        int i = l - 1;
        while (i >= 0) {
            ids[i] = this.makeIdentifier();
            --i;
        }
        return ids;
    }

    private aliasType[] makeAliases() {
        return this.makeAliases(this.stack.nodeArity());
    }

    private aliasType[] makeAliases(int l) {
        aliasType[] aliases = new aliasType[l];
        int i = l - 1;
        while (i >= 0) {
            aliases[i] = (aliasType)this.stack.popNode();
            --i;
        }
        return aliases;
    }

    public SimpleNode openNode(int id) {
        if (nodes[id] == null) {
            if (id == 95 || id == 96 || id == 93) {
                return new IdentityNode(id);
            }
            TreeBuilder.nodes[id] = new IdentityNode(id);
        }
        return nodes[id];
    }

    public static String getImageAsString(SimpleNode n) {
        Object image = n.getImage();
        String imageAsString = image == null ? "Incomplete node" : image.toString();
        return imageAsString;
    }

    public SimpleNode closeNode(SimpleNode n, int arity) throws Exception {
        switch (n.getId()) {
            case -1: {
                System.out.println("Illegal node");
            }
            case 0: {
                return new Interactive(this.makeStmts(arity));
            }
            case 1: {
                return new Module(this.makeStmts(arity));
            }
            case 2: {
                return new Expression(this.makeExpr());
            }
            case 95: {
                return new Name(TreeBuilder.getImageAsString(n), 1);
            }
            case 93: {
                return new Num((PyObject)n.getImage());
            }
            case 96: {
                return new Str(TreeBuilder.getImageAsString(n));
            }
            case 97: {
                return new Unicode(TreeBuilder.getImageAsString(n));
            }
            case 45: {
                stmtType[] stmts = new stmtType[arity];
                int i = arity - 1;
                while (i >= 0) {
                    stmts[i] = (stmtType)this.popNode();
                    --i;
                }
                return new Suite(stmts);
            }
            case 21: {
                exprType value = this.makeExpr();
                if (arity > 1) {
                    SimpleNode[] exprs = this.makeExprs(arity - 1);
                    this.ctx.setStore(exprs);
                    return new Assign((exprType[])exprs, value);
                }
                return new Expr(value);
            }
            case 76: {
                sliceType slice = (sliceType)this.stack.popNode();
                exprType value = this.makeExpr();
                return new Subscript(value, slice, 1);
            }
            case 77: {
                String attr = this.makeIdentifier();
                exprType value = this.makeExpr();
                return new Attribute(value, attr, 1);
            }
            case 24: {
                SimpleNode[] exprs = this.makeExprs(arity);
                this.ctx.setDelete(exprs);
                return new Delete((exprType[])exprs);
            }
            case 23: {
                boolean nl = true;
                if (this.stack.nodeArity() == 0) {
                    return new Print(null, null, true);
                }
                if (this.peekNode().getId() == 87) {
                    this.popNode();
                    nl = false;
                }
                return new Print(null, this.makeExprs(), nl);
            }
            case 22: {
                boolean nl = true;
                if (this.peekNode().getId() == 87) {
                    this.popNode();
                    nl = false;
                }
                exprType[] exprs = this.makeExprs(this.stack.nodeArity() - 1);
                return new Print(this.makeExpr(), exprs, nl);
            }
            case 41: {
                stmtType[] orelse = null;
                if (this.stack.nodeArity() == 4) {
                    orelse = this.popSuite();
                }
                stmtType[] body = this.popSuite();
                exprType iter = this.makeExpr();
                exprType target = this.makeExpr();
                this.ctx.setStore(target);
                return new For(target, iter, body, orelse);
            }
            case 40: {
                stmtType[] orelse = null;
                if (this.stack.nodeArity() == 3) {
                    orelse = this.popSuite();
                }
                stmtType[] body = this.popSuite();
                exprType test = this.makeExpr();
                return new While(test, body, orelse);
            }
            case 39: {
                stmtType[] orelse = null;
                if (arity % 2 == 1) {
                    orelse = this.popSuite();
                }
                stmtType[] body = this.popSuite();
                exprType test = this.makeExpr();
                If last = new If(test, body, orelse);
                int i = 0;
                while (i < arity / 2 - 1) {
                    body = this.popSuite();
                    test = this.makeExpr();
                    last = new If(test, body, new stmtType[]{last});
                    ++i;
                }
                return last;
            }
            case 25: {
                return new Pass();
            }
            case 26: {
                return new Break();
            }
            case 27: {
                return new Continue();
            }
            case 3: {
                stmtType[] body = this.popSuite();
                argumentsType arguments = this.makeArguments(arity - 2);
                String name = this.makeIdentifier();
                return new FunctionDef(name, arguments, body);
            }
            case 7: {
                exprType value = arity == 1 ? null : this.makeExpr();
                return new DefaultArg(this.makeExpr(), value);
            }
            case 5: {
                return new ExtraArg(this.makeIdentifier(), 5);
            }
            case 6: {
                return new ExtraArg(this.makeIdentifier(), 6);
            }
            case 89: {
                stmtType[] body = this.popSuite();
                exprType[] bases = this.makeExprs(this.stack.nodeArity() - 1);
                String name = this.makeIdentifier();
                return new ClassDef(name, bases, body);
            }
            case 28: {
                exprType value = arity == 1 ? this.makeExpr() : null;
                return new Return(value);
            }
            case 29: {
                return new Yield(this.makeExpr());
            }
            case 30: {
                exprType tback = arity >= 3 ? this.makeExpr() : null;
                exprType inst = arity >= 2 ? this.makeExpr() : null;
                exprType type = arity >= 1 ? this.makeExpr() : null;
                return new Raise(type, inst, tback);
            }
            case 36: {
                return new Global(this.makeIdentifiers());
            }
            case 37: {
                exprType globals = arity >= 3 ? this.makeExpr() : null;
                exprType locals = arity >= 2 ? this.makeExpr() : null;
                exprType value = this.makeExpr();
                return new Exec(value, locals, globals);
            }
            case 38: {
                exprType msg = arity == 2 ? this.makeExpr() : null;
                exprType test = this.makeExpr();
                return new Assert(test, msg);
            }
            case 43: {
                stmtType[] orelse = this.popSuite();
                return new TryFinally(this.popSuite(), orelse);
            }
            case 42: {
                stmtType[] orelse = null;
                if (this.peekNode() instanceof Suite) {
                    --arity;
                    orelse = this.popSuite();
                }
                int l = arity - 1;
                excepthandlerType[] handlers = new excepthandlerType[l];
                int i = l - 1;
                while (i >= 0) {
                    handlers[i] = (excepthandlerType)this.popNode();
                    --i;
                }
                return new TryExcept(this.popSuite(), handlers, orelse);
            }
            case 44: {
                exprType excname;
                stmtType[] body = this.popSuite();
                exprType exprType2 = excname = arity == 3 ? this.makeExpr() : null;
                if (excname != null) {
                    this.ctx.setStore(excname);
                }
                exprType type = arity >= 2 ? this.makeExpr() : null;
                return new excepthandlerType(type, excname, body);
            }
            case 46: {
                return new BoolOp(2, this.makeExprs());
            }
            case 47: {
                return new BoolOp(1, this.makeExprs());
            }
            case 49: {
                int l = arity / 2;
                exprType[] comparators = new exprType[l];
                int[] ops = new int[l];
                int i = l - 1;
                while (i >= 0) {
                    comparators[i] = this.makeExpr();
                    SimpleNode op = (SimpleNode)this.stack.popNode();
                    switch (op.getId()) {
                        case 50: {
                            ops[i] = 3;
                            break;
                        }
                        case 51: {
                            ops[i] = 5;
                            break;
                        }
                        case 52: {
                            ops[i] = 1;
                            break;
                        }
                        case 53: {
                            ops[i] = 6;
                            break;
                        }
                        case 54: {
                            ops[i] = 4;
                            break;
                        }
                        case 55: {
                            ops[i] = 2;
                            break;
                        }
                        case 56: {
                            ops[i] = 9;
                            break;
                        }
                        case 57: {
                            ops[i] = 10;
                            break;
                        }
                        case 58: {
                            ops[i] = 8;
                            break;
                        }
                        case 59: {
                            ops[i] = 7;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown cmp op:" + op.getId());
                        }
                    }
                    --i;
                }
                return new Compare(this.makeExpr(), ops, comparators);
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                return n;
            }
            case 60: {
                return this.makeBinOp(9);
            }
            case 61: {
                return this.makeBinOp(10);
            }
            case 62: {
                return this.makeBinOp(11);
            }
            case 63: {
                return this.makeBinOp(7);
            }
            case 64: {
                return this.makeBinOp(8);
            }
            case 65: {
                return this.makeBinOp(1);
            }
            case 66: {
                return this.makeBinOp(2);
            }
            case 67: {
                return this.makeBinOp(3);
            }
            case 68: {
                return this.makeBinOp(4);
            }
            case 70: {
                return this.makeBinOp(5);
            }
            case 74: {
                return this.makeBinOp(6);
            }
            case 69: {
                return this.makeBinOp(12);
            }
            case 71: {
                return new UnaryOp(3, this.makeExpr());
            }
            case 72: {
                return new UnaryOp(4, this.makeExpr());
            }
            case 73: {
                return new UnaryOp(1, this.makeExpr());
            }
            case 48: {
                return new UnaryOp(2, this.makeExpr());
            }
            case 75: {
                exprType starargs = null;
                exprType kwargs = null;
                int l = arity - 1;
                if (l > 0 && this.peekNode().getId() == 91) {
                    kwargs = ((ExtraArgValue)this.popNode()).value;
                    --l;
                }
                if (l > 0 && this.peekNode().getId() == 90) {
                    starargs = ((ExtraArgValue)this.popNode()).value;
                    --l;
                }
                int nargs = l;
                SimpleNode[] tmparr = new SimpleNode[l];
                int i = l - 1;
                while (i >= 0) {
                    tmparr[i] = this.popNode();
                    if (tmparr[i] instanceof keywordType) {
                        nargs = i;
                    }
                    --i;
                }
                exprType[] args = new exprType[nargs];
                int i2 = 0;
                while (i2 < nargs) {
                    args[i2] = this.makeExpr(tmparr[i2]);
                    ++i2;
                }
                keywordType[] keywords = new keywordType[l - nargs];
                int i3 = nargs;
                while (i3 < l) {
                    if (!(tmparr[i3] instanceof keywordType)) {
                        throw new ParseException("non-keyword argument following keyword", tmparr[i3]);
                    }
                    keywords[i3 - nargs] = (keywordType)tmparr[i3];
                    ++i3;
                }
                exprType func = this.makeExpr();
                return new Call(func, args, keywords, starargs, kwargs);
            }
            case 91: {
                return new ExtraArgValue(this.makeExpr(), 91);
            }
            case 90: {
                return new ExtraArgValue(this.makeExpr(), 90);
            }
            case 92: {
                exprType value = this.makeExpr();
                String name = this.makeIdentifier();
                return new keywordType(name, value);
            }
            case 8: {
                return new Tuple(this.makeExprs(), 1);
            }
            case 78: {
                if (this.stack.nodeArity() > 0 && this.peekNode() instanceof listcompType) {
                    listcompType[] generators = new listcompType[arity - 1];
                    int i = arity - 2;
                    while (i >= 0) {
                        generators[i] = (listcompType)this.popNode();
                        --i;
                    }
                    return new ListComp(this.makeExpr(), generators);
                }
                return new List(this.makeExprs(), 1);
            }
            case 79: {
                int l = arity / 2;
                exprType[] keys = new exprType[l];
                exprType[] vals = new exprType[l];
                int i = l - 1;
                while (i >= 0) {
                    vals[i] = this.makeExpr();
                    keys[i] = this.makeExpr();
                    --i;
                }
                return new Dict(keys, vals);
            }
            case 80: {
                return new Repr(this.makeExpr());
            }
            case 81: {
                String str2 = ((Str)this.popNode()).s;
                String str1 = ((Str)this.popNode()).s;
                return new Str(String.valueOf(str1) + str2);
            }
            case 82: {
                exprType test = this.makeExpr();
                argumentsType arguments = this.makeArguments(arity - 1);
                return new Lambda(arguments, test);
            }
            case 84: {
                return new Ellipsis();
            }
            case 85: {
                SimpleNode[] arr = new SimpleNode[arity];
                int i = arity - 1;
                while (i >= 0) {
                    arr[i] = this.popNode();
                    --i;
                }
                exprType[] values = new exprType[3];
                int k = 0;
                int j = 0;
                while (j < arity) {
                    if (arr[j].getId() == 86) {
                        ++k;
                    } else {
                        values[k] = this.makeExpr(arr[j]);
                    }
                    ++j;
                }
                if (k == 0) {
                    return new Index(values[0]);
                }
                return new Slice(values[0], values[1], values[2]);
            }
            case 83: {
                if (arity > 0 && this.peekNode().getId() == 87) {
                    --arity;
                    this.popNode();
                }
                sliceType[] dims = new sliceType[arity];
                int i = arity - 1;
                while (i >= 0) {
                    dims[i] = (sliceType)this.popNode();
                    --i;
                }
                return new ExtSlice(dims);
            }
            case 9: {
                return this.makeAugAssign(1);
            }
            case 10: {
                return this.makeAugAssign(2);
            }
            case 11: {
                return this.makeAugAssign(3);
            }
            case 12: {
                return this.makeAugAssign(4);
            }
            case 14: {
                return this.makeAugAssign(5);
            }
            case 15: {
                return this.makeAugAssign(11);
            }
            case 16: {
                return this.makeAugAssign(9);
            }
            case 17: {
                return this.makeAugAssign(10);
            }
            case 18: {
                return this.makeAugAssign(7);
            }
            case 19: {
                return this.makeAugAssign(8);
            }
            case 20: {
                return this.makeAugAssign(6);
            }
            case 13: {
                return this.makeAugAssign(12);
            }
            case 88: {
                exprType[] ifs = new exprType[arity - 2];
                int i = arity - 3;
                while (i >= 0) {
                    ifs[i] = this.makeExpr();
                    --i;
                }
                exprType iter = this.makeExpr();
                exprType target = this.makeExpr();
                this.ctx.setStore(target);
                return new listcompType(target, iter, ifs);
            }
            case 32: {
                aliasType[] aliases = this.makeAliases(arity - 1);
                String module = this.makeIdentifier();
                return new ImportFrom(module, aliases);
            }
            case 31: {
                return new Import(this.makeAliases());
            }
            case 34: {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < arity) {
                    if (i > 0) {
                        sb.insert(0, '.');
                    }
                    sb.insert(0, this.makeIdentifier());
                    ++i;
                }
                return new Name(sb.toString(), 1);
            }
            case 33: {
                String asname = null;
                if (arity > 1) {
                    asname = this.makeIdentifier();
                }
                return new aliasType(this.makeIdentifier(), asname);
            }
            case 35: {
                String asname = null;
                if (arity > 1) {
                    asname = this.makeIdentifier();
                }
                return new aliasType(this.makeIdentifier(), asname);
            }
            case 86: 
            case 87: {
                return n;
            }
        }
        return null;
    }

    private stmtType makeAugAssign(int op) throws Exception {
        exprType value = this.makeExpr();
        exprType target = this.makeExpr();
        this.ctx.setAugStore(target);
        return new AugAssign(target, op, value);
    }

    private void dumpStack() {
        int n = this.stack.nodeArity();
        System.out.println("nodeArity:" + n);
        if (n > 0) {
            System.out.println("peek:" + this.stack.peekNode());
        }
    }

    SimpleNode peekNode() {
        return (SimpleNode)this.stack.peekNode();
    }

    SimpleNode popNode() {
        return (SimpleNode)this.stack.popNode();
    }

    BinOp makeBinOp(int op) {
        exprType right = this.makeExpr();
        exprType left = this.makeExpr();
        return new BinOp(left, op, right);
    }

    argumentsType makeArguments(int l) throws Exception {
        String kwarg = null;
        String stararg = null;
        if (l > 0 && this.peekNode().getId() == 6) {
            kwarg = ((ExtraArg)this.popNode()).name;
            --l;
        }
        if (l > 0 && this.peekNode().getId() == 5) {
            stararg = ((ExtraArg)this.popNode()).name;
            --l;
        }
        int startofdefaults = l;
        exprType[] fpargs = new exprType[l];
        exprType[] defaults = new exprType[l];
        int i = l - 1;
        while (i >= 0) {
            DefaultArg node = (DefaultArg)this.popNode();
            fpargs[i] = node.parameter;
            this.ctx.setStore(fpargs[i]);
            defaults[i] = node.value;
            if (node.value != null) {
                startofdefaults = i;
            }
            --i;
        }
        exprType[] newdefs = new exprType[l - startofdefaults];
        System.arraycopy(defaults, startofdefaults, newdefs, 0, newdefs.length);
        return new argumentsType(fpargs, stararg, kwarg, newdefs);
    }
}

