/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.python.core.Options;
import org.python.core.PackageManager;

public abstract class CachedJarsPackageManager
extends PackageManager {
    private boolean indexModified;
    private Hashtable jarfiles;
    private File cachedir;

    protected void message(String msg) {
    }

    protected void warning(String warn) {
    }

    protected void comment(String msg) {
    }

    protected void debug(String msg) {
    }

    protected boolean filterByName(String name, boolean pkg) {
        return name.indexOf(36) != -1;
    }

    protected boolean filterByAccess(String name, int acc) {
        return (acc & 1) != 1;
    }

    private static String vectorToString(Vector vec) {
        int n = vec.size();
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < n) {
            ret.append((String)vec.elementAt(i));
            if (i < n - 1) {
                ret.append(",");
            }
            ++i;
        }
        return ret.toString();
    }

    private void addZipEntry(Hashtable zipPackages, ZipEntry entry, ZipInputStream zip) throws IOException {
        int access;
        String name = entry.getName();
        if (!name.endsWith(".class")) {
            return;
        }
        char sep = '/';
        int breakPoint = name.lastIndexOf(sep);
        if (breakPoint == -1) {
            breakPoint = name.lastIndexOf(92);
            sep = '\\';
        }
        String packageName = breakPoint == -1 ? "" : name.substring(0, breakPoint).replace(sep, '.');
        String className = name.substring(breakPoint + 1, name.length() - 6);
        if (this.filterByName(className, false)) {
            return;
        }
        Vector[] vec = (Vector[])zipPackages.get(packageName);
        if (vec == null) {
            vec = new Vector[]{new Vector(), new Vector()};
            zipPackages.put(packageName, vec);
        }
        if ((access = CachedJarsPackageManager.checkAccess(zip)) != -1 && !this.filterByAccess(name, access)) {
            vec[0].addElement(className);
        } else {
            vec[1].addElement(className);
        }
    }

    private Hashtable getZipPackages(InputStream jarin) throws IOException {
        ZipEntry entry;
        Hashtable zipPackages = new Hashtable();
        ZipInputStream zip = new ZipInputStream(jarin);
        while ((entry = zip.getNextEntry()) != null) {
            this.addZipEntry(zipPackages, entry, zip);
            zip.closeEntry();
        }
        Enumeration e = zipPackages.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Vector[] vec = (Vector[])zipPackages.get(key);
            String classes = CachedJarsPackageManager.vectorToString(vec[0]);
            if (vec[1].size() > 0) {
                classes = String.valueOf(classes) + '@' + CachedJarsPackageManager.vectorToString(vec[1]);
            }
            zipPackages.put(key, classes);
        }
        return zipPackages;
    }

    public void addJarToPackages(URL jarurl) {
        this.addJarToPackages(jarurl, null, false);
    }

    public void addJarToPackages(URL jarurl, boolean cache) {
        this.addJarToPackages(jarurl, null, cache);
    }

    public void addJarToPackages(File jarfile) {
        this.addJarToPackages(null, jarfile, false);
    }

    public void addJarToPackages(File jarfile, boolean cache) {
        this.addJarToPackages(null, jarfile, cache);
    }

    private void addJarToPackages(URL jarurl, File jarfile, boolean cache) {
        try {
            boolean caching = this.jarfiles != null;
            URLConnection jarconn = null;
            boolean localfile = true;
            if (jarfile == null) {
                jarconn = jarurl.openConnection();
                if (jarconn.getURL().getProtocol().equals("file")) {
                    String jarfilename = jarurl.getFile();
                    jarfilename = jarfilename.replace('/', File.separatorChar);
                    jarfile = new File(jarfilename);
                } else {
                    localfile = false;
                }
            }
            if (localfile && !jarfile.exists()) {
                return;
            }
            Hashtable zipPackages = null;
            long mtime = 0L;
            String jarcanon = null;
            JarXEntry entry = null;
            boolean brandNew = false;
            if (caching) {
                if (localfile) {
                    mtime = jarfile.lastModified();
                    jarcanon = jarfile.getCanonicalPath();
                } else {
                    mtime = jarconn.getLastModified();
                    jarcanon = jarurl.toString();
                }
                entry = (JarXEntry)this.jarfiles.get(jarcanon);
                if ((entry == null || !new File(entry.cachefile).exists()) && cache) {
                    String jarname;
                    this.message("processing new jar, '" + jarcanon + "'");
                    if (localfile) {
                        jarname = jarfile.getName();
                    } else {
                        jarname = jarurl.getFile();
                        int slash = jarname.lastIndexOf(47);
                        if (slash != -1) {
                            jarname = jarname.substring(slash + 1);
                        }
                    }
                    jarname = jarname.substring(0, jarname.length() - 4);
                    entry = new JarXEntry(jarname);
                    this.jarfiles.put(jarcanon, entry);
                    brandNew = true;
                }
                if (mtime != 0L && entry != null && entry.mtime == mtime) {
                    zipPackages = this.readCacheFile(entry, jarcanon);
                }
            }
            if (zipPackages == null) {
                boolean bl = caching = caching && cache;
                if (caching) {
                    this.indexModified = true;
                    if (entry.mtime != 0L) {
                        this.message("processing modified jar, '" + jarcanon + "'");
                    }
                    entry.mtime = mtime;
                }
                InputStream jarin = jarconn == null ? new BufferedInputStream(new FileInputStream(jarfile)) : jarconn.getInputStream();
                zipPackages = this.getZipPackages(jarin);
                if (caching) {
                    this.writeCacheFile(entry, jarcanon, zipPackages, brandNew);
                }
            }
            this.addPackages(zipPackages, jarcanon);
        }
        catch (IOException iOException) {
            this.warning("skipping bad jar, '" + (jarfile != null ? jarfile.toString() : jarurl.toString()) + "'");
        }
    }

    private void addPackages(Hashtable zipPackages, String jarfile) {
        Enumeration e = zipPackages.keys();
        while (e.hasMoreElements()) {
            String pkg = (String)e.nextElement();
            String classes = (String)zipPackages.get(pkg);
            int idx = classes.indexOf(64);
            if (idx >= 0 && Options.respectJavaAccessibility) {
                classes = classes.substring(0, idx);
            }
            this.makeJavaPackage(pkg, classes, jarfile);
        }
    }

    private Hashtable readCacheFile(JarXEntry entry, String jarcanon) {
        DataInputStream istream;
        block6: {
            String cachefile = entry.cachefile;
            long mtime = entry.mtime;
            this.debug("reading cache, '" + jarcanon + "'");
            istream = this.inOpenCacheFile(cachefile);
            String old_jarcanon = istream.readUTF();
            long old_mtime = istream.readLong();
            if (old_jarcanon.equals(jarcanon) && old_mtime == mtime) break block6;
            this.comment("invalid cache file: " + cachefile + ", " + jarcanon + ":" + old_jarcanon + ", " + mtime + ":" + old_mtime);
            this.deleteCacheFile(cachefile);
            return null;
        }
        try {
            Hashtable<String, String> packs = new Hashtable<String, String>();
            try {
                while (true) {
                    String packageName = istream.readUTF();
                    String classes = istream.readUTF();
                    packs.put(packageName, classes);
                }
            }
            catch (EOFException eOFException) {
                istream.close();
                return packs;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void writeCacheFile(JarXEntry entry, String jarcanon, Hashtable zipPackages, boolean brandNew) {
        try {
            DataOutputStream ostream = this.outCreateCacheFile(entry, brandNew);
            ostream.writeUTF(jarcanon);
            ostream.writeLong(entry.mtime);
            this.comment("rewriting cachefile for '" + jarcanon + "'");
            Enumeration e = zipPackages.keys();
            while (e.hasMoreElements()) {
                String packageName = (String)e.nextElement();
                String classes = (String)zipPackages.get(packageName);
                ostream.writeUTF(packageName);
                ostream.writeUTF(classes);
            }
            ostream.close();
        }
        catch (IOException iOException) {
            this.warning("can't write cache file for '" + jarcanon + "'");
        }
    }

    protected void initCache() {
        this.indexModified = false;
        this.jarfiles = new Hashtable();
        try {
            DataInputStream istream = this.inOpenIndex();
            if (istream == null) {
                return;
            }
            try {
                while (true) {
                    String jarcanon = istream.readUTF();
                    String cachefile = istream.readUTF();
                    long mtime = istream.readLong();
                    this.jarfiles.put(jarcanon, new JarXEntry(cachefile, mtime));
                }
            }
            catch (EOFException eOFException) {
                istream.close();
            }
        }
        catch (IOException iOException) {
            this.warning("invalid index file");
        }
    }

    public void saveCache() {
        if (this.jarfiles == null || !this.indexModified) {
            return;
        }
        this.indexModified = false;
        this.comment("writing modified index file");
        try {
            DataOutputStream ostream = this.outOpenIndex();
            Enumeration e = this.jarfiles.keys();
            while (e.hasMoreElements()) {
                String jarcanon = (String)e.nextElement();
                JarXEntry entry = (JarXEntry)this.jarfiles.get(jarcanon);
                ostream.writeUTF(jarcanon);
                ostream.writeUTF(entry.cachefile);
                ostream.writeLong(entry.mtime);
            }
            ostream.close();
        }
        catch (IOException iOException) {
            this.warning("can't write index file");
        }
    }

    protected DataInputStream inOpenIndex() throws IOException {
        File indexFile = new File(this.cachedir, "packages.idx");
        if (!indexFile.exists()) {
            return null;
        }
        DataInputStream istream = new DataInputStream(new BufferedInputStream(new FileInputStream(indexFile)));
        return istream;
    }

    protected DataOutputStream outOpenIndex() throws IOException {
        File indexFile = new File(this.cachedir, "packages.idx");
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
    }

    protected DataInputStream inOpenCacheFile(String cachefile) throws IOException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(cachefile)));
    }

    protected void deleteCacheFile(String cachefile) {
        new File(cachefile).delete();
    }

    protected DataOutputStream outCreateCacheFile(JarXEntry entry, boolean create) throws IOException {
        File cachefile = null;
        if (create) {
            int index = 1;
            String suffix = "";
            String jarname = entry.cachefile;
            while ((cachefile = new File(this.cachedir, String.valueOf(jarname) + suffix + ".pkc")).exists()) {
                suffix = "$" + index;
                ++index;
            }
            entry.cachefile = cachefile.getCanonicalPath();
        } else {
            cachefile = new File(entry.cachefile);
        }
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(cachefile)));
    }

    protected boolean useCacheDir(File aCachedir1) {
        if (aCachedir1 == null) {
            return false;
        }
        try {
            if (!aCachedir1.isDirectory() && !aCachedir1.mkdirs()) {
                this.warning("can't create package cache dir, '" + aCachedir1 + "'");
                return false;
            }
        }
        catch (AccessControlException accessControlException) {
            this.warning("The java security manager isn't allowing access to the package cache dir, '" + aCachedir1 + "'");
            return false;
        }
        this.cachedir = aCachedir1;
        return true;
    }

    public static class JarXEntry {
        public String cachefile;
        public long mtime;

        public JarXEntry(String cachefile) {
            this.cachefile = cachefile;
        }

        public JarXEntry(String cachefile, long mtime) {
            this.cachefile = cachefile;
            this.mtime = mtime;
        }
    }
}

