/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.red_core;

import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.python.pydev.editor.preferences.PydevEditorPrefs;
import org.python.pydev.plugin.preferences.IPydevPreferencesProvider;
import org.python.pydev.plugin.preferences.IPydevPreferencesProvider2;
import org.python.pydev.red_core.AddRedCoreThemeAvailable;
import org.python.pydev.red_core.preferences.PydevRedCorePreferencesInitializer;
import org.python.pydev.utils.LabelFieldEditor;
import org.python.pydev.utils.LinkFieldEditor;

public class AddRedCorePreferences
implements IPydevPreferencesProvider,
IPydevPreferencesProvider2 {
    public IPreferenceStore[] getPreferenceStore() {
        if (!AddRedCoreThemeAvailable.isRedCoreAvailableForTheming()) {
            return null;
        }
        return new IPreferenceStore[]{ThemePlugin.getDefault().getPreferenceStore(), CommonEditorPlugin.getDefault().getPreferenceStore()};
    }

    public boolean isColorOrStyleProperty(String property) {
        if (!AddRedCoreThemeAvailable.isRedCoreAvailableForTheming()) {
            return false;
        }
        return property.equals("THEME_CHANGED");
    }

    private TextAttribute getFromTheme(String name) {
        if (!AddRedCoreThemeAvailable.isRedCoreAvailableForTheming()) {
            return null;
        }
        Theme currentTheme = ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
        return currentTheme.getTextAttribute(name);
    }

    public TextAttribute getKeywordTextAttribute() {
        return this.getFromTheme("keyword.py");
    }

    public TextAttribute getSelfTextAttribute() {
        return this.getFromTheme("keyword.other.self.py");
    }

    public TextAttribute getCodeTextAttribute() {
        return this.getFromTheme("source.py");
    }

    public TextAttribute getDecoratorTextAttribute() {
        return this.getFromTheme("storage.type.annotation.py");
    }

    public TextAttribute getNumberTextAttribute() {
        return this.getFromTheme("constant.numeric.py");
    }

    public TextAttribute getClassNameTextAttribute() {
        return this.getFromTheme("entity.name.class.py");
    }

    public TextAttribute getFuncNameTextAttribute() {
        return this.getFromTheme("entity.name.function.py");
    }

    public TextAttribute getCommentTextAttribute() {
        return this.getFromTheme("comment.py");
    }

    public TextAttribute getBackquotesTextAttribute() {
        return this.getFromTheme("support.type.py");
    }

    public TextAttribute getParensTextAttribute() {
        return this.getFromTheme("source.parens.py");
    }

    public TextAttribute getOperatorsTextAttribute() {
        return this.getFromTheme("source.operators.py");
    }

    public TextAttribute getStringTextAttribute() {
        return this.getFromTheme("string.py");
    }

    public TextAttribute getConsoleErrorTextAttribute() {
        return this.getFromTheme("console.error.py");
    }

    public TextAttribute getConsoleOutputTextAttribute() {
        return this.getFromTheme("console.output.py");
    }

    public TextAttribute getConsoleInputTextAttribute() {
        return this.getFromTheme("console.input.py");
    }

    public TextAttribute getConsolePromptTextAttribute() {
        return this.getFromTheme("console.prompt.py");
    }

    public TextAttribute getHyperlinkTextAttribute() {
        return this.getFromTheme("hyperlink.py");
    }

    public RGB getConsoleBackgroundRGB() {
        if (!AddRedCoreThemeAvailable.isRedCoreAvailableForTheming()) {
            return null;
        }
        Theme currentTheme = ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
        return currentTheme.getBackground();
    }

    protected Button addUseAptanaThemesCheckbox(final Composite parent, String label) {
        final Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.setSelection(PydevRedCorePreferencesInitializer.getUseAptanaThemes());
        final Label labelReUseAptanaThemes = this.addLabel(parent, "");
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PydevRedCorePreferencesInitializer.setUseAptanaThemes(checkBox.getSelection());
                labelReUseAptanaThemes.setText("Restart required!\nMeanwhile, new and existing editors (or other widgets) may not function properly.\n\n");
                labelReUseAptanaThemes.setForeground(labelReUseAptanaThemes.getDisplay().getSystemColor(3));
                parent.layout();
            }
        });
        return checkBox;
    }

    protected Label addLabel(Composite parent, String label) {
        Label labelWidget = new Label(parent, 0);
        labelWidget.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalSpan = 2;
        labelWidget.setLayoutData((Object)gd);
        return labelWidget;
    }

    public boolean createColorOptions(Composite appearanceComposite, final PydevEditorPrefs prefs) {
        if (!AddRedCoreThemeAvailable.isRedCoreAvailable()) {
            return false;
        }
        this.addUseAptanaThemesCheckbox(appearanceComposite, "Use aptana themes? (restart required)");
        if (!PydevRedCorePreferencesInitializer.getUseAptanaThemes()) {
            return false;
        }
        LinkFieldEditor colorsAndFontsLinkFieldEditor = new LinkFieldEditor("UNUSED", "Colors handled through <a>Aptana Themes</a>\n", appearanceComposite, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String id = "com.aptana.theme.preferencePage";
                IWorkbenchPreferenceContainer workbenchPreferenceContainer = (IWorkbenchPreferenceContainer)prefs.getContainer();
                workbenchPreferenceContainer.openPage(id, null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        colorsAndFontsLinkFieldEditor.getLinkControl(appearanceComposite);
        LabelFieldEditor labelFieldEditor = new LabelFieldEditor("UNUSED", "Scopes used in Aptana Themes:\n\nCode:          source                   Backquotes: support.type\nKeywords:      keyword                  {}, [], (): source.parens\nSelf:          keyword.other.self       Comments:   comment\nDecorators:    storage.type.annotation  Strings:    string\nNumbers:       constant.numeric         Stderr:     console.error\nClass name:    entity.name.class        Stdout:     console.output\nFunction name: entity.name.function     Input:      console.input\nOperators:     source.operators         Prompt:     console.prompt\n", appearanceComposite);
        Label labelControl = labelFieldEditor.getLabelControl(appearanceComposite);
        try {
            FontData labelFontData = new FontData("Courier New", 8, 0);
            labelControl.setFont(new Font((Device)labelControl.getDisplay(), labelFontData));
        }
        catch (Throwable throwable) {}
        prefs.setUpdateLabelExampleOnPrefsChanges();
        return true;
    }
}

