/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.ui;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.console.IHyperlink;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.ui.ILinkContainer;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.model.Location;
import org.python.pydev.plugin.PydevPlugin;

public class PythonConsoleLineTracker
implements IConsoleLineTracker {
    private ILinkContainer linkContainer;
    private boolean onlyCreateLinksForExistingFiles = true;
    static Pattern linePattern = Pattern.compile("\\s*(File) \\\"([^\\\"]*)\\\", line (\\d*).*");

    public void init(final IConsole console) {
        this.linkContainer = new ILinkContainer(){

            public void addLink(IHyperlink link, int offset, int length) {
                console.addLink(link, offset, length);
            }

            public String getContents(int offset, int length) throws BadLocationException {
                return console.getDocument().get(offset, length);
            }
        };
    }

    public void init(ILinkContainer linkContainer) {
        this.linkContainer = linkContainer;
    }

    public void lineAppended(IRegion line) {
        String text;
        int lineOffset = line.getOffset();
        int lineLength = line.getLength();
        try {
            text = this.linkContainer.getContents(lineOffset, lineLength);
        }
        catch (BadLocationException e) {
            PydevDebugPlugin.log(4, "unexpected error", e);
            return;
        }
        Matcher m = linePattern.matcher(text);
        String fileName = null;
        String lineNumber = null;
        int fileStart = -1;
        if (m.matches()) {
            fileName = m.group(2);
            lineNumber = m.group(3);
            fileStart = m.start(1);
        }
        if (fileName != null) {
            Object link = null;
            int num = -1;
            try {
                num = lineNumber != null ? Integer.parseInt(lineNumber) : 0;
            }
            catch (NumberFormatException numberFormatException) {
                num = 0;
            }
            IFile[] files = PydevPlugin.getDefault() == null ? (IFile[])null : ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new File(fileName).toURI());
            if (files != null && files.length > 0 && files[0].exists()) {
                link = new FileLink(files[0], null, -1, -1, num);
            } else {
                File realFile = new File(fileName);
                if (!this.onlyCreateLinksForExistingFiles || realFile.exists()) {
                    ItemPointer p = new ItemPointer((Object)realFile, new Location(num - 1, 0), null);
                    link = new ConsoleLink(p);
                }
            }
            if (link != null) {
                this.linkContainer.addLink((IHyperlink)link, lineOffset + fileStart, lineLength - fileStart);
            }
        }
    }

    public void dispose() {
    }

    public void setOnlyCreateLinksForExistingFiles(boolean b) {
        this.onlyCreateLinksForExistingFiles = b;
    }

    public void splitInLinesAndAppendToLineTracker(String string) {
        int len = string.length();
        int last = 0;
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c == '\r') {
                this.lineAppended((IRegion)new Region(last, i - last - 1));
                if (i < len - 1 && string.charAt(i + 1) == '\n') {
                    ++i;
                }
                last = i + 1;
            }
            if (c == '\n') {
                this.lineAppended((IRegion)new Region(last, i - last - 1));
                last = i + 1;
            }
            ++i;
        }
        this.lineAppended((IRegion)new Region(last, len - last));
    }

    public class ConsoleLink
    implements IHyperlink {
        ItemPointer pointer;

        public ConsoleLink(ItemPointer pointer) {
            this.pointer = pointer;
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }

        public void linkActivated() {
            PyOpenAction open = new PyOpenAction();
            open.run(this.pointer);
        }
    }
}

