/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.jython;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.python.core.PyException;
import org.python.core.PyJavaClass;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.bundle.BundleInfo;
import org.python.pydev.core.bundle.IBundleInfo;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.jython.ExitScriptException;
import org.python.pydev.jython.IInteractiveConsole;
import org.python.pydev.jython.IPythonInterpreter;
import org.python.pydev.jython.InteractiveConsoleWrapper;
import org.python.pydev.jython.PythonInterpreterWrapper;
import org.python.pydev.jython.PythonInterpreterWrapperNotShared;
import org.python.pydev.jython.ScriptOutput;
import org.python.pydev.jython.ui.JyScriptingPreferencesPage;
import org.python.util.PythonInterpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JythonPlugin
extends AbstractUIPlugin {
    private static final boolean DEBUG = false;
    public static boolean DEBUG_RELOAD = true;
    public static boolean IN_TESTS = false;
    private static String LOAD_FILE_SCRIPT = "print '--->  reloading', r'%s'\nimport sys                    \nf = open(r'%s')               \ntry:                          \n    toExec = f.read()         \nfinally:                      \n    f.close()                 \n%s                            \n";
    public static IBundleInfo info;
    private static JythonPlugin plugin;
    AllBundleClassLoader allBundleClassLoader;
    private static Map<File, Tuple<Long, Object>> codeCache;
    private static MessageConsole fConsole;
    private static IOConsoleOutputStream fOutputStream;
    private static IOConsoleOutputStream fErrorStream;

    static {
        codeCache = new HashMap<File, Tuple<Long, Object>>();
    }

    public static synchronized void setDebugReload(boolean b) {
        if (b != DEBUG_RELOAD) {
            LOAD_FILE_SCRIPT = !b ? "#" + LOAD_FILE_SCRIPT : LOAD_FILE_SCRIPT.substring(1);
            DEBUG_RELOAD = b;
        }
    }

    public static IBundleInfo getBundleInfo() {
        if (info == null) {
            info = new BundleInfo(JythonPlugin.getDefault().getBundle());
        }
        return info;
    }

    public static void setBundleInfo(IBundleInfo b) {
        info = b;
    }

    public JythonPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Properties prop2 = new Properties();
        prop2.put("python.home", REF.getFileAbsolutePath((File)this.getPluginRootDir()));
        prop2.put("python.path", REF.getFileAbsolutePath((File)JythonPlugin.getJySrcDirFile()));
        prop2.put("python.security.respectJavaAccessibility", "false");
        try {
            this.allBundleClassLoader = new AllBundleClassLoader(context.getBundles(), ((Object)((Object)this)).getClass().getClassLoader());
            PySystemState.initialize((Properties)System.getProperties(), (Properties)prop2, (String[])new String[0], (ClassLoader)this.allBundleClassLoader);
            String[] packageNames = JythonPlugin.getDefault().allBundleClassLoader.getPackageNames();
            int i = 0;
            while (i < packageNames.length) {
                PySystemState.add_package((String)packageNames[i]);
                ++i;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    private File getPluginRootDir() {
        try {
            Path relative = new Path(".");
            return JythonPlugin.getBundleInfo().getRelativePath((IPath)relative);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static JythonPlugin getDefault() {
        return plugin;
    }

    public static File getJythonLibDir() {
        try {
            Path relative = new Path("Lib");
            return JythonPlugin.getBundleInfo().getRelativePath((IPath)relative);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static File getFileWithinJySrc(String f) {
        try {
            IPath relative = new Path("jysrc").addTrailingSeparator().append(f);
            return JythonPlugin.getBundleInfo().getRelativePath(relative);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static File getJySrcDirFile() {
        try {
            Path relative = new Path("jysrc");
            return JythonPlugin.getBundleInfo().getRelativePath((IPath)relative);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Throwable exec(HashMap<String, Object> locals, String fileToExec, IPythonInterpreter interpreter) {
        File fileWithinJySrc = JythonPlugin.getFileWithinJySrc(fileToExec);
        return JythonPlugin.exec(locals, interpreter, fileWithinJySrc, new File[]{fileWithinJySrc.getParentFile()}, new String[0]);
    }

    public static List<Throwable> execAll(HashMap<String, Object> locals, String startingWith, IPythonInterpreter interpreter) {
        File jySrc = JythonPlugin.getJySrcDirFile();
        File additionalScriptingLocation = JyScriptingPreferencesPage.getAdditionalScriptingLocation();
        return JythonPlugin.execAll(locals, startingWith, interpreter, new File[]{jySrc, additionalScriptingLocation}, null);
    }

    public static List<Throwable> execAll(HashMap<String, Object> locals, String startingWith, IPythonInterpreter interpreter, File[] beneathFolders, File[] additionalPythonpathFolders) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        ArrayList<File> pythonpath = new ArrayList<File>();
        pythonpath.addAll(Arrays.asList(beneathFolders));
        if (additionalPythonpathFolders != null) {
            pythonpath.addAll(Arrays.asList(additionalPythonpathFolders));
        }
        File[] pythonpathFolders = pythonpath.toArray(new File[pythonpath.size()]);
        File[] fileArray = beneathFolders;
        int n = beneathFolders.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file != null) {
                File[] files;
                if (!file.exists()) {
                    String msg = "The folder:" + file + " does not exist and therefore cannot be used to " + "find scripts to run starting with:" + startingWith;
                    Log.log((int)4, (String)msg, null);
                    errors.add(new RuntimeException(msg));
                }
                if ((files = JythonPlugin.getFilesBeneathFolder(startingWith, file)) != null) {
                    File[] fileArray2 = files;
                    int n3 = files.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File f = fileArray2[n4];
                        Throwable throwable = JythonPlugin.exec(locals, interpreter, f, pythonpathFolders, new String[0]);
                        if (throwable != null) {
                            errors.add(throwable);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return errors;
    }

    public static File[] getFilesBeneathFolder(final String startingWith, File jySrc) {
        File[] files = jySrc.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String name = pathname.getName();
                return name.startsWith(startingWith) && name.endsWith(".py");
            }
        });
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Throwable exec(HashMap<String, Object> locals, IPythonInterpreter interpreter, File fileToExec, File[] pythonpathFolders, String ... argv) {
        if (locals == null) {
            locals = new HashMap();
        }
        if (interpreter == null) {
            return null;
        }
        locals.put("__file__", fileToExec.toString());
        try {
            String codeObjName;
            Map<File, Tuple<Long, Object>> map = codeCache;
            synchronized (map) {
                String fileName = fileToExec.getName();
                if (!fileName.endsWith(".py")) {
                    throw new RuntimeException("The script to be executed must be a python file. Name:" + fileName);
                }
                codeObjName = "code" + fileName.substring(0, fileName.indexOf(46));
                String codeObjTimestampName = String.valueOf(codeObjName) + "Timestamp";
                for (Map.Entry<String, Object> entry : locals.entrySet()) {
                    interpreter.set(entry.getKey(), entry.getValue());
                }
                boolean regenerate = false;
                if (interpreter instanceof PythonInterpreterWrapperNotShared) {
                    regenerate = true;
                }
                Tuple<Long, Object> timestamp = codeCache.get(fileToExec);
                long lastModified = fileToExec.lastModified();
                if (timestamp == null || (Long)timestamp.o1 != lastModified) {
                    regenerate = true;
                }
                if (!regenerate) {
                    PyObject obj = interpreter.get(codeObjName);
                    PyObject pyTime = interpreter.get(codeObjTimestampName);
                    if (obj == null || pyTime == null || !pyTime.__tojava__(Long.class).equals(timestamp.o1)) {
                        interpreter.set(codeObjName, timestamp.o2);
                        interpreter.set(codeObjTimestampName, timestamp.o1);
                    }
                }
                if (regenerate) {
                    String path = REF.getFileAbsolutePath((File)fileToExec);
                    StringBuffer strPythonPathFolders = new StringBuffer();
                    strPythonPathFolders.append("[");
                    File[] fileArray = pythonpathFolders;
                    int n = pythonpathFolders.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if (file != null) {
                            strPythonPathFolders.append("r'");
                            strPythonPathFolders.append(REF.getFileAbsolutePath((File)file));
                            strPythonPathFolders.append("',");
                        }
                        ++n2;
                    }
                    strPythonPathFolders.append("]");
                    StringBuffer addToSysPath = new StringBuffer();
                    addToSysPath.append("if not hasattr(sys, 'PYDEV_PYTHONPATH_SET') or sys.PYDEV_PYTHONPATH_SET != ");
                    addToSysPath.append(strPythonPathFolders);
                    addToSysPath.append(":\n");
                    addToSysPath.append("    sys.PYDEV_PYTHONPATH_SET = ");
                    addToSysPath.append(strPythonPathFolders);
                    addToSysPath.append("\n");
                    addToSysPath.append("    sys.path += ");
                    addToSysPath.append(strPythonPathFolders);
                    addToSysPath.append("\n");
                    if (argv.length > 0) {
                        addToSysPath.append("sys.argv = [");
                        String[] stringArray = argv;
                        int n3 = argv.length;
                        n = 0;
                        while (n < n3) {
                            String s = stringArray[n];
                            addToSysPath.append(s);
                            addToSysPath.append(",");
                            ++n;
                        }
                        addToSysPath.append("];");
                        addToSysPath.append("\n");
                    }
                    String toExec = StringUtils.format((String)LOAD_FILE_SCRIPT, (Object[])new Object[]{path, path, addToSysPath.toString()});
                    interpreter.exec(toExec);
                    String exec = StringUtils.format((String)"%s = compile(toExec, r'%s', 'exec')", (Object[])new Object[]{codeObjName, path});
                    interpreter.exec(exec);
                    interpreter.set(codeObjTimestampName, lastModified);
                    PyObject codeObj = interpreter.get(codeObjName);
                    codeCache.put(fileToExec, (Tuple<Long, Object>)new Tuple((Object)lastModified, (Object)codeObj));
                }
            }
            interpreter.exec(StringUtils.format((String)"exec(%s)", (Object[])new Object[]{codeObjName}));
        }
        catch (Throwable e) {
            if (!IN_TESTS && JythonPlugin.getDefault() == null) {
                return null;
            }
            if (e instanceof ExitScriptException) {
                return null;
            }
            if (e instanceof PyException) {
                PyException pE = (PyException)e;
                if (pE.type instanceof PyJavaClass) {
                    PyJavaClass t = (PyJavaClass)pE.type;
                    if (t.__name__ != null && t.__name__.equals("org.python.pydev.jython.ExitScriptException")) {
                        return null;
                    }
                }
            }
            if (JyScriptingPreferencesPage.getShowScriptingOutput()) {
                Log.log((int)4, (String)("Error while executing:" + fileToExec), (Throwable)e);
            }
            return e;
        }
        return null;
    }

    private static MessageConsole getConsole() {
        try {
            if (fConsole == null) {
                fConsole = new MessageConsole("PyDev Scripting", JythonPlugin.getBundleInfo().getImageCache().getDescriptor("icons/python_scripting.png"));
                fOutputStream = fConsole.newOutputStream();
                fErrorStream = fConsole.newOutputStream();
                HashMap<IOConsoleOutputStream, String> themeConsoleStreamToColor = new HashMap<IOConsoleOutputStream, String>();
                themeConsoleStreamToColor.put(fOutputStream, "console.output");
                themeConsoleStreamToColor.put(fErrorStream, "console.error");
                fConsole.setAttribute("themeConsoleStreamToColor", themeConsoleStreamToColor);
                ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{fConsole});
            }
            return fConsole;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IPythonInterpreter newPythonInterpreter() {
        return JythonPlugin.newPythonInterpreter(true, true);
    }

    public static IPythonInterpreter newPythonInterpreter(boolean redirect, boolean shareSys) {
        PythonInterpreter interpreter = shareSys ? new PythonInterpreterWrapper() : new PythonInterpreterWrapperNotShared();
        if (redirect) {
            MessageConsole console = JythonPlugin.getConsole();
            interpreter.setOut(new ScriptOutput((IOConsole)console, fOutputStream));
            interpreter.setErr(new ScriptOutput((IOConsole)console, fErrorStream));
        }
        interpreter.set("False", 0);
        interpreter.set("True", 1);
        return interpreter;
    }

    public static IInteractiveConsole newInteractiveConsole() {
        return new InteractiveConsoleWrapper();
    }

    public static class AllBundleClassLoader
    extends ClassLoader {
        private Bundle[] bundles;
        private String[] packageNames;

        public AllBundleClassLoader(Bundle[] bundles, ClassLoader parent) {
            super(parent);
            this.bundles = bundles;
            this.setPackageNames(bundles);
        }

        /*
         * Unable to fully structure code
         */
        public Class loadClass(String className) throws ClassNotFoundException {
            try {
                return super.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                i = 0;
                ** while (i < this.bundles.length)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    if (this.bundles[i].getState() == 32) {
                        return this.bundles[i].loadClass(className);
                    }
                }
                catch (Throwable v0) {}
                ++i;
                continue;
            }
lbl13:
            // 1 sources

            throw e;
        }

        private void setPackageNames(Bundle[] bundles) {
            ArrayList<String> names = new ArrayList<String>();
            int i = 0;
            while (i < bundles.length) {
                int j;
                String[] pnames;
                String packages = (String)bundles[i].getHeaders().get("Provide-Package");
                if (packages != null) {
                    pnames = packages.split(",");
                    j = 0;
                    while (j < pnames.length) {
                        names.add(pnames[j].trim());
                        ++j;
                    }
                }
                if ((packages = (String)bundles[i].getHeaders().get("Export-Package")) != null) {
                    pnames = packages.split(",");
                    j = 0;
                    while (j < pnames.length) {
                        names.add(pnames[j].trim());
                        ++j;
                    }
                }
                ++i;
            }
            this.packageNames = names.toArray(new String[names.size()]);
        }

        public String[] getPackageNames() {
            return this.packageNames;
        }
    }
}

