/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.utils;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.uiutils.AsynchronousProgressMonitorDialog;
import org.python.pydev.utils.ProgressAction;

public class ProgressOperation
extends WorkspaceModifyOperation {
    private final ProgressAction action;
    public IProgressMonitor monitor;
    public int estimatedTaskUnits = 10000;

    public ProgressOperation(ProgressAction action) {
        this.action = action;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            this.monitor = monitor;
            this.action.monitor = monitor;
            monitor.beginTask("Action being executed...", this.estimatedTaskUnits);
            this.action.run();
            monitor.done();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public static void startAction(Shell shell, ProgressAction action, boolean cancelable) {
        AsynchronousProgressMonitorDialog monitorDialog = new AsynchronousProgressMonitorDialog(shell);
        monitorDialog.setCancelable(cancelable);
        monitorDialog.setBlockOnOpen(false);
        try {
            ProgressOperation operation = new ProgressOperation(action);
            monitorDialog.run(false, false, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            Log.log((Throwable)e);
        }
        catch (InterruptedException e) {
            Log.log((Throwable)e);
        }
    }
}

