/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.python.pydev.core.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractKeyValueDialog
extends Dialog {
    protected String title;
    protected String message;
    protected Button okButton;
    protected Text errorMessageText;
    protected Text keyField;
    protected Text valueField;
    protected String finalKeyValue = null;
    protected String finalValueValue = null;
    public int BROWSER_ID = 64;
    public String BROWSER_LABEL = "Brows&e...";
    protected Button browserButton;
    protected Listener changesValidator;

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.finalKeyValue = this.keyField.getText().trim();
            this.finalValueValue = this.valueField.getText().trim();
        } else {
            this.finalKeyValue = null;
            this.finalValueValue = null;
        }
        super.buttonPressed(buttonId);
    }

    public AbstractKeyValueDialog(Shell shell, String dialogTitle, String dialogMessage) {
        super(shell);
        this.title = dialogTitle;
        this.message = dialogMessage;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessageText.setText(errorMessage == null ? "" : errorMessage);
        this.okButton.setEnabled(errorMessage == null);
        this.errorMessageText.getParent().update();
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(768));
        GridData data = new GridData(768);
        if (this.message != null) {
            Label messageLabel = new Label(main, 64);
            messageLabel.setText(this.message);
            data = new GridData(768);
            data.horizontalSpan = 3;
            data.widthHint = 150;
            messageLabel.setLayoutData((Object)data);
        }
        Label separator = new Label(main, 0);
        data = new GridData(768);
        data.horizontalSpan = 4;
        separator.setText("");
        separator.setLayoutData((Object)data);
        this.createFields(main);
        this.errorMessageText = new Text(main, 8);
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.errorMessageText.setForeground(this.errorMessageText.getDisplay().getSystemColor(3));
        data = new GridData(768);
        data.horizontalSpan = 3;
        data.widthHint = 150;
        this.errorMessageText.setLayoutData((Object)data);
        AbstractKeyValueDialog.applyDialogFont((Control)main);
        return main;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.setErrorMessage(this.getInitialMessage());
    }

    protected void createFields(Composite parent) {
        this.changesValidator = this.createChangesValidator();
        new Label(parent, 0).setText(this.getKeyLabelText());
        this.keyField = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.keyField.setLayoutData((Object)data);
        this.keyField.addListener(2, this.changesValidator);
        this.keyField.addListener(1, this.changesValidator);
        this.keyField.addListener(2, this.changesValidator);
        new Label(parent, 0).setText(this.getValueLabelText());
        this.valueField = new Text(parent, 2048);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.valueField.setLayoutData((Object)data);
        this.valueField.addListener(2, this.changesValidator);
        this.valueField.addListener(1, this.changesValidator);
        this.valueField.addListener(2, this.changesValidator);
        this.browserButton = this.createButton(parent, this.BROWSER_ID, this.BROWSER_LABEL, true);
        data = new GridData(768);
        data.horizontalSpan = 1;
        data.widthHint = this.convertHorizontalDLUsToPixels(61);
        this.browserButton.setLayoutData((Object)data);
        this.browserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String file = AbstractKeyValueDialog.this.handleBrowseButton();
                if (file != null) {
                    file = file.trim();
                    AbstractKeyValueDialog.this.setValueField(file);
                }
                AbstractKeyValueDialog.this.changesValidator.handleEvent(null);
            }
        });
    }

    protected void setValueField(String value) {
        this.valueField.setText(value);
    }

    public Tuple<String, String> getKeyAndValueEntered() {
        if (this.finalKeyValue == null || this.finalValueValue == null || this.finalKeyValue.trim().length() == 0 || this.finalValueValue.trim().length() == 0) {
            return null;
        }
        return new Tuple((Object)this.finalKeyValue.trim(), (Object)this.finalValueValue.trim());
    }

    protected abstract String handleBrowseButton();

    protected abstract String getValueLabelText();

    protected abstract String getKeyLabelText();

    protected abstract Listener createChangesValidator();

    protected abstract String getInitialMessage();
}

