/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.runners;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.python.pydev.core.Tuple;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.runners.SimpleRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePythonRunner
extends SimpleRunner {
    public Tuple<String, String> runAndGetOutputFromPythonScript(String interpreter, String script, String[] args, File workingDir, IProject project) {
        String[] parameters = SimplePythonRunner.addInterpreterToArgs(interpreter, script, args);
        return this.runAndGetOutput(parameters, workingDir, PythonNature.getPythonNature(project), (IProgressMonitor)new NullProgressMonitor());
    }

    public static String[] makeExecutableCommandStr(String interpreter, String script, String[] args) {
        String[] s = SimplePythonRunner.addInterpreterToArgs(interpreter, script, args);
        ArrayList<String> asList = new ArrayList<String>(Arrays.asList(s));
        asList.addAll(Arrays.asList(args));
        return asList.toArray(new String[0]);
    }

    private static String[] addInterpreterToArgs(String interpreter, String script, String[] args) {
        return SimplePythonRunner.preparePythonCallParameters(interpreter, script, args);
    }

    public Tuple<String, String> runAndGetOutputWithInterpreter(String interpreter, String script, String[] args, File workingDir, IProject project, IProgressMonitor monitor) {
        monitor.setTaskName("Mounting executable string...");
        monitor.worked(5);
        String[] s = SimplePythonRunner.preparePythonCallParameters(interpreter, script, args);
        monitor.worked(1);
        return this.runAndGetOutput(s, workingDir, PythonNature.getPythonNature(project), monitor);
    }

    public static String[] preparePythonCallParameters(String interpreter, String script, String[] args) {
        File file = new File(script);
        if (!file.exists()) {
            throw new RuntimeException("The script passed for execution (" + script + ") does not exist.");
        }
        if (args == null) {
            args = new String[]{};
        }
        String[] s = new String[3 + args.length];
        s[0] = interpreter;
        s[1] = "-u";
        s[2] = script;
        System.arraycopy(args, 0, s, 3, args.length);
        return s;
    }
}

