/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.RenameResourceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.python.pydev.navigator.actions.Helpers;

public class PyRenameResourceAction
extends RenameResourceAction {
    private ISelectionProvider provider;
    private ArrayList<IResource> selected;
    private Shell shell;

    public PyRenameResourceAction(Shell shell, ISelectionProvider selectionProvider) {
        super(shell);
        this.shell = shell;
        this.provider = selectionProvider;
    }

    protected String queryNewResourceName(final IResource resource) {
        final IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        final IPath prefix = resource.getFullPath().removeLastSegments(1);
        IInputValidator validator = new IInputValidator(){

            public String isValid(String string) {
                if (resource.getName().equals(string)) {
                    return IDEWorkbenchMessages.RenameResourceAction_nameMustBeDifferent;
                }
                IStatus status = workspace.validateName(string, resource.getType());
                if (!status.isOK()) {
                    return status.getMessage();
                }
                if (workspace.getRoot().exists(prefix.append(string))) {
                    return IDEWorkbenchMessages.RenameResourceAction_nameExists;
                }
                return null;
            }
        };
        InputDialog dialog = new InputDialog(this.shell, IDEWorkbenchMessages.RenameResourceAction_inputDialogTitle, IDEWorkbenchMessages.RenameResourceAction_inputDialogMessage, resource.getName(), validator);
        dialog.setBlockOnOpen(true);
        if (dialog.open() == 0) {
            return dialog.getValue();
        }
        return null;
    }

    public boolean isEnabled() {
        IStructuredSelection sSelection;
        this.selected = new ArrayList();
        ISelection selection = this.provider.getSelection();
        if (!selection.isEmpty() && (sSelection = (IStructuredSelection)selection).size() >= 1) {
            for (Object element : sSelection) {
                IAdaptable adaptable;
                IResource resource;
                if (element instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)element).getAdapter(IResource.class)) != null) {
                    this.selected.add(resource);
                    continue;
                }
                this.selected = null;
                return false;
            }
        }
        return true;
    }

    protected List getSelectedResources() {
        return this.selected;
    }

    public IStructuredSelection getStructuredSelection() {
        return new StructuredSelection(this.selected);
    }

    public void run() {
        IResource r;
        if (!this.isEnabled()) {
            return;
        }
        IEditorPart[] dirtyEditors = Helpers.checkValidateState();
        List resources = this.getSelectedResources();
        if (resources.size() == 1 && (r = (IResource)resources.get(0)) instanceof IFile) {
            IFile cfr_ignored_0 = (IFile)r;
            IEditorPart[] iEditorPartArray = dirtyEditors;
            int n = dirtyEditors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorPart iEditorPart = iEditorPartArray[n2];
                IEditorInput editorInput = iEditorPart.getEditorInput();
                Object input = editorInput.getAdapter(IResource.class);
                if (r.equals(input)) {
                    iEditorPart.doSave(null);
                }
                ++n2;
            }
        }
        super.run();
    }
}

