/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited.visitors;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IToken;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.GlobalModelVisitor;
import org.python.pydev.editor.codecompletion.revisited.visitors.InnerModelVisitor;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.VisitorBase;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.visitors.NodeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVisitor
extends VisitorBase {
    public static final int GLOBAL_TOKENS = 1;
    public static final int WILD_MODULES = 2;
    public static final int ALIAS_MODULES = 4;
    public static final int MODULE_DOCSTRING = 8;
    public static final int INNER_DEFS = 16;
    protected final List<IToken> tokens = new ArrayList<IToken>();
    protected String moduleName;

    protected SourceToken addToken(SimpleNode node) {
        SourceToken t = AbstractVisitor.makeToken(node, this.moduleName);
        this.tokens.add(t);
        return t;
    }

    public static SourceToken makeToken(SimpleNode node, String moduleName) {
        return new SourceToken(node, NodeUtils.getRepresentationString((SimpleNode)node), NodeUtils.getNodeArgs((SimpleNode)node), NodeUtils.getNodeDocString((SimpleNode)node), moduleName);
    }

    public static SourceToken makeFullNameToken(SimpleNode node, String moduleName) {
        return new SourceToken(node, NodeUtils.getFullRepresentationString((SimpleNode)node), NodeUtils.getNodeArgs((SimpleNode)node), NodeUtils.getNodeDocString((SimpleNode)node), moduleName);
    }

    public static IToken makeWildImportToken(ImportFrom node, List<IToken> tokens, String moduleName) {
        if (tokens == null) {
            tokens = new ArrayList<IToken>();
        }
        SourceToken sourceToken = null;
        if (AbstractVisitor.isWildImport(node)) {
            sourceToken = new SourceToken((SimpleNode)node, ((NameTok)node.module).id, "", "", moduleName);
            tokens.add(sourceToken);
        }
        return sourceToken;
    }

    public static List<IToken> makeImportToken(SimpleNode node, List<IToken> tokens, String moduleName, boolean allowForMultiple) {
        if (node instanceof Import) {
            return AbstractVisitor.makeImportToken((Import)node, tokens, moduleName, allowForMultiple);
        }
        if (node instanceof ImportFrom) {
            ImportFrom i = (ImportFrom)node;
            if (AbstractVisitor.isWildImport(i)) {
                AbstractVisitor.makeWildImportToken(i, tokens, moduleName);
                return tokens;
            }
            return AbstractVisitor.makeImportToken((ImportFrom)node, tokens, moduleName, allowForMultiple);
        }
        throw new RuntimeException("Unable to create token for the passed import (" + node + ")");
    }

    public static List<IToken> makeImportToken(Import node, List<IToken> tokens, String moduleName, boolean allowForMultiple) {
        aliasType[] names = node.names;
        return AbstractVisitor.makeImportToken((SimpleNode)node, tokens, names, moduleName, "", allowForMultiple);
    }

    public static List<IToken> makeImportToken(ImportFrom node, List<IToken> tokens, String moduleName, boolean allowForMultiple) {
        aliasType[] names = node.names;
        String importName = ((NameTok)node.module).id;
        return AbstractVisitor.makeImportToken((SimpleNode)node, tokens, names, moduleName, importName, allowForMultiple);
    }

    private static List<IToken> makeImportToken(SimpleNode node, List<IToken> tokens, aliasType[] names, String module, String initialImportName, boolean allowForMultiple) {
        if (tokens == null) {
            tokens = new ArrayList<IToken>();
        }
        if (initialImportName.length() > 0) {
            initialImportName = String.valueOf(initialImportName) + ".";
        }
        int i = 0;
        while (i < names.length) {
            aliasType aliasType2 = names[i];
            String name = null;
            String original = ((NameTok)aliasType2.name).id;
            if (aliasType2.asname != null) {
                name = ((NameTok)aliasType2.asname).id;
            }
            if (name == null) {
                FullRepIterable iterator = new FullRepIterable(original);
                Iterator it = iterator.iterator();
                while (it.hasNext()) {
                    String rep = (String)it.next();
                    SourceToken sourceToken = it.hasNext() ? new ImportPartSourceToken(node, rep, "", "", module, String.valueOf(initialImportName) + rep, true) : new SourceToken(node, rep, "", "", module, String.valueOf(initialImportName) + rep, true);
                    tokens.add(sourceToken);
                }
            } else {
                SourceToken sourceToken = new SourceToken(node, name, "", "", module, String.valueOf(initialImportName) + original, false);
                tokens.add(sourceToken);
            }
            ++i;
        }
        return tokens;
    }

    public static boolean isString(SimpleNode ast) {
        return ast instanceof Str;
    }

    public static boolean isWildImport(ImportFrom node) {
        return node.names.length == 0;
    }

    public static boolean isAliasImport(ImportFrom node) {
        return node.names.length > 0;
    }

    public List<IToken> getTokens() {
        return this.tokens;
    }

    public static List<IToken> getTokens(SimpleNode ast, int which, String moduleName, ICompletionState state, boolean onlyAllowTokensIn__all__) {
        AbstractVisitor modelVisitor = which == 16 ? new InnerModelVisitor(moduleName, state) : new GlobalModelVisitor(which, moduleName, onlyAllowTokensIn__all__);
        if (ast != null) {
            try {
                ast.accept((VisitorIF)modelVisitor);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            modelVisitor.finishVisit();
            return modelVisitor.tokens;
        }
        return new ArrayList<IToken>();
    }

    public static GlobalModelVisitor getGlobalModuleVisitorWithTokens(SimpleNode ast, int which, String moduleName, ICompletionState state, boolean onlyAllowTokensIn__all__) {
        if (which == 16) {
            throw new RuntimeException("Only globals for getting the GlobalModelVisitor");
        }
        GlobalModelVisitor modelVisitor = new GlobalModelVisitor(which, moduleName, onlyAllowTokensIn__all__);
        if (ast != null) {
            try {
                ast.accept((VisitorIF)modelVisitor);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            modelVisitor.finishVisit();
            return modelVisitor;
        }
        return modelVisitor;
    }

    protected void finishVisit() {
    }

    public static class ImportPartSourceToken
    extends SourceToken {
        private static final long serialVersionUID = 1L;

        public ImportPartSourceToken(SimpleNode node, String rep, String doc, String args, String parentPackage, String originalRep, boolean originalHasRep) {
            super(node, rep, doc, args, parentPackage, originalRep, originalHasRep);
        }
    }
}

