/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited.javaintegration;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.AbstractJavaClassModule;
import org.python.pydev.editor.codecompletion.revisited.modules.EmptyModuleForZip;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaZipModule
extends AbstractJavaClassModule {
    public static final boolean DEBUG_JARS = false;
    private File file;
    private boolean isFileInZip;
    private static HashMap<String, IClasspathEntry[]> classpathEntries = new HashMap();

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isPackage() {
        return !this.isFileInZip;
    }

    protected synchronized IClasspathEntry[] getClasspathEntries() {
        return JavaZipModule.getClasspathEntries(this.file.getAbsolutePath());
    }

    private static synchronized IClasspathEntry[] getClasspathEntries(String path) {
        IClasspathEntry[] entry = classpathEntries.get(path);
        if (entry == null) {
            entry = new IClasspathEntry[]{JavaCore.newLibraryEntry((IPath)Path.fromOSString((String)path), null, null, (boolean)true)};
            classpathEntries.put(path, entry);
        }
        return entry;
    }

    public JavaZipModule(EmptyModuleForZip emptyModuleForZip) {
        super(emptyModuleForZip.getName());
        this.file = emptyModuleForZip.f;
        this.isFileInZip = emptyModuleForZip.isFile;
        this.tokens = this.isFileInZip ? this.createTokens(this.name) : EMPTY_ITOKEN;
    }

    @Override
    protected IJavaElement findJavaElement(String javaClassModuleName) throws Exception {
        String contents = "import %s.;";
        contents = StringUtils.format((String)contents, (Object[])new Object[]{FullRepIterable.getWithoutLastPart((String)javaClassModuleName)});
        String lookingForClass = FullRepIterable.getLastPart((String)javaClassModuleName);
        List<Tuple<IJavaElement, CompletionProposal>> javaCompletionProposals = this.getJavaCompletionProposals(contents, contents.length() - 1, lookingForClass);
        if (javaCompletionProposals.size() > 0) {
            return (IJavaElement)javaCompletionProposals.get((int)0).o1;
        }
        return null;
    }

    @Override
    protected List<Tuple<IJavaElement, CompletionProposal>> getJavaCompletionProposals(String completeClassDesc, String filterCompletionName) throws JavaModelException {
        String contents;
        if (filterCompletionName != null) {
            contents = "class CompletionClass {void main(){new %s().%s}}";
            contents = StringUtils.format((String)contents, (Object[])new Object[]{completeClassDesc, filterCompletionName});
        } else {
            contents = "class CompletionClass {void main(){new %s().}}";
            contents = StringUtils.format((String)contents, (Object[])new Object[]{completeClassDesc});
        }
        List<Tuple<IJavaElement, CompletionProposal>> javaCompletionProposals = this.getJavaCompletionProposals(contents, contents.length() - 2, filterCompletionName);
        if (javaCompletionProposals.size() == 0) {
            if (filterCompletionName != null) {
                contents = "class CompletionClass {void main(){%s.%s}}";
                contents = StringUtils.format((String)contents, (Object[])new Object[]{completeClassDesc, filterCompletionName});
            } else {
                contents = "class CompletionClass {void main(){%s.}}";
                contents = StringUtils.format((String)contents, (Object[])new Object[]{completeClassDesc});
            }
            javaCompletionProposals = this.getJavaCompletionProposals(contents, contents.length() - 2, filterCompletionName);
        }
        return javaCompletionProposals;
    }

    @Override
    protected List<Tuple<IJavaElement, CompletionProposal>> getJavaCompletionProposals(String contents, int completionOffset, String filterCompletionName) throws JavaModelException {
        ArrayList<Tuple<IJavaElement, CompletionProposal>> ret = new ArrayList<Tuple<IJavaElement, CompletionProposal>>();
        IClasspathEntry[] entries = this.getClasspathEntries();
        ICompilationUnit unit = new WorkingCopyOwner(){}.newWorkingCopy(this.name, entries, null, (IProgressMonitor)new NullProgressMonitor());
        unit.getBuffer().setContents(contents);
        CompletionProposalCollector collector = this.createCollector(filterCompletionName, ret, unit);
        unit.codeComplete(completionOffset, (CompletionRequestor)collector);
        return ret;
    }
}

