/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.python.pydev.core.DeltaSaver;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IDeltaProcessor;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IProjectModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.ModulesManagerWithBuild;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.JavaProjectModulesManagerCreator;
import org.python.pydev.plugin.nature.PythonNature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectModulesManager
extends ModulesManagerWithBuild
implements IProjectModulesManager {
    private static final boolean DEBUG_MODULES = false;
    private volatile IProject project;
    private volatile IPythonNature nature;

    public void setProject(IProject project, IPythonNature nature, boolean restoreDeltas) {
        this.project = project;
        this.nature = nature;
        File completionsCacheDir = this.nature.getCompletionsCacheDir();
        if (completionsCacheDir == null) {
            return;
        }
        this.deltaSaver = new DeltaSaver(completionsCacheDir, "v1_astdelta", readFromFileMethod, toFileMethod);
        if (!restoreDeltas) {
            this.deltaSaver.clearAll();
        } else {
            this.deltaSaver.processDeltas((IDeltaProcessor)this);
        }
    }

    public void endProcessing() {
        this.nature.saveAstManager();
    }

    public void setPythonNature(IPythonNature nature) {
        this.nature = nature;
    }

    public IPythonNature getNature() {
        return this.nature;
    }

    public ISystemModulesManager getSystemModulesManager() {
        if (this.nature == null) {
            Log.log((String)"Nature still not set");
            return null;
        }
        try {
            return this.nature.getProjectInterpreter().getModulesManager();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Set<String> getAllModuleNames(boolean addDependencies, String partStartingWithLowerCase) {
        if (addDependencies) {
            HashSet<String> s = new HashSet<String>();
            IModulesManager[] managersInvolved = this.getManagersInvolved(true);
            int i = 0;
            while (i < managersInvolved.length) {
                s.addAll(managersInvolved[i].getAllModuleNames(false, partStartingWithLowerCase));
                ++i;
            }
            return s;
        }
        return super.getAllModuleNames(addDependencies, partStartingWithLowerCase);
    }

    @Override
    public SortedMap<ModulesKey, ModulesKey> getAllModulesStartingWith(String strStartingWith) {
        TreeMap<ModulesKey, ModulesKey> ret = new TreeMap<ModulesKey, ModulesKey>();
        IModulesManager[] managersInvolved = this.getManagersInvolved(true);
        int i = 0;
        while (i < managersInvolved.length) {
            ret.putAll(managersInvolved[i].getAllDirectModulesStartingWith(strStartingWith));
            ++i;
        }
        return ret;
    }

    @Override
    public IModule getModule(String name, IPythonNature nature, boolean dontSearchInit) {
        return this.getModule(name, nature, true, dontSearchInit);
    }

    public IModule getRelativeModule(String name, IPythonNature nature) {
        return super.getModule(false, name, nature, true);
    }

    public IModule getModule(String name, IPythonNature nature, boolean checkSystemManager, boolean dontSearchInit) {
        Tuple<IModule, IModulesManager> ret = this.getModuleAndRelatedModulesManager(name, nature, checkSystemManager, dontSearchInit);
        if (ret != null) {
            return (IModule)ret.o1;
        }
        return null;
    }

    public Tuple<IModule, IModulesManager> getModuleAndRelatedModulesManager(String name, IPythonNature nature, boolean checkSystemManager, boolean dontSearchInit) {
        IModulesManager m;
        IModulesManager[] managersInvolved;
        IModule module = null;
        IModulesManager[] iModulesManagerArray = managersInvolved = this.getManagersInvolved(true);
        int n = managersInvolved.length;
        int n2 = 0;
        while (n2 < n) {
            m = iModulesManagerArray[n2];
            if (m instanceof ISystemModulesManager && (module = ((ISystemModulesManager)m).getBuiltinModule(name, dontSearchInit)) != null) {
                return new Tuple((Object)module, (Object)m);
            }
            ++n2;
        }
        iModulesManagerArray = managersInvolved;
        n = managersInvolved.length;
        n2 = 0;
        while (n2 < n) {
            m = iModulesManagerArray[n2];
            if (m instanceof IProjectModulesManager) {
                IProjectModulesManager pM = (IProjectModulesManager)m;
                module = pM.getModuleInDirectManager(name, nature, dontSearchInit);
            } else if (m instanceof ISystemModulesManager) {
                ISystemModulesManager systemModulesManager = (ISystemModulesManager)m;
                module = systemModulesManager.getModuleWithoutBuiltins(name, nature, dontSearchInit);
            } else {
                throw new RuntimeException("Unexpected: " + m);
            }
            if (module != null) {
                return new Tuple((Object)module, (Object)m);
            }
            ++n2;
        }
        return null;
    }

    public IModule getModuleInDirectManager(String name, IPythonNature nature, boolean dontSearchInit) {
        return super.getModule(name, nature, dontSearchInit);
    }

    @Override
    protected String getResolveModuleErr(IResource member) {
        return "Unable to find the path " + member + " in the project were it\n" + "is added as a source folder for pydev (project: " + this.project.getName() + ")";
    }

    public String resolveModuleOnlyInProjectSources(String fileAbsolutePath, boolean addExternal) throws CoreException {
        String onlyProjectPythonPathStr = this.nature.getPythonPathNature().getOnlyProjectPythonPathStr(addExternal);
        HashSet projectSourcePath = new HashSet(StringUtils.splitAndRemoveEmptyTrimmed((String)onlyProjectPythonPathStr, (char)'|'));
        return this.pythonPathHelper.resolveModule(fileAbsolutePath, new ArrayList<String>(projectSourcePath));
    }

    @Override
    public String resolveModule(String full) {
        return this.resolveModule(full, true);
    }

    public String resolveModule(String full, boolean checkSystemManager) {
        IModulesManager[] managersInvolved;
        IModulesManager[] iModulesManagerArray = managersInvolved = this.getManagersInvolved(checkSystemManager);
        int n = managersInvolved.length;
        int n2 = 0;
        while (n2 < n) {
            String mod;
            IModulesManager m = iModulesManagerArray[n2];
            if (m instanceof IProjectModulesManager) {
                IProjectModulesManager pM = (IProjectModulesManager)m;
                mod = pM.resolveModuleInDirectManager(full);
            } else {
                mod = m.resolveModule(full);
            }
            if (mod != null) {
                return mod;
            }
            ++n2;
        }
        return null;
    }

    public String resolveModuleInDirectManager(String full) {
        return super.resolveModule(full);
    }

    public String resolveModuleInDirectManager(IFile member) {
        File inOs = member.getRawLocation().toFile();
        return this.resolveModuleInDirectManager(REF.getFileAbsolutePath((File)inOs));
    }

    @Override
    public int getSize(boolean addDependenciesSize) {
        if (addDependenciesSize) {
            int size = 0;
            IModulesManager[] managersInvolved = this.getManagersInvolved(true);
            int i = 0;
            while (i < managersInvolved.length) {
                size += managersInvolved[i].getSize(false);
                ++i;
            }
            return size;
        }
        return super.getSize(addDependenciesSize);
    }

    public String[] getBuiltins() {
        String[] builtins = null;
        ISystemModulesManager systemModulesManager = this.getSystemModulesManager();
        if (systemModulesManager != null) {
            builtins = systemModulesManager.getBuiltins();
        }
        return builtins;
    }

    private synchronized IModulesManager[] getManagers(boolean checkSystemManager, boolean referenced) {
        IModulesManager[] ret;
        if (this.completionCache != null && (ret = this.completionCache.getManagers(referenced)) != null) {
            return ret;
        }
        ArrayList<IModulesManager> list = new ArrayList<IModulesManager>();
        ISystemModulesManager systemModulesManager = this.getSystemModulesManager();
        list.add(this);
        if (this.project != null) {
            IModulesManager javaModulesManagerForProject = JavaProjectModulesManagerCreator.createJavaProjectModulesManagerIfPossible(this.project);
            if (javaModulesManagerForProject != null) {
                list.add(javaModulesManagerForProject);
            }
            Set<IProject> projs = referenced ? ProjectModulesManager.getReferencedProjects(this.project) : ProjectModulesManager.getReferencingProjects(this.project);
            this.addModuleManagers(list, projs);
        }
        if (checkSystemManager && systemModulesManager != null) {
            list.add((IModulesManager)systemModulesManager);
        }
        IModulesManager[] ret2 = list.toArray(new IModulesManager[list.size()]);
        if (this.completionCache != null) {
            this.completionCache.setManagers(ret2, referenced);
        }
        return ret2;
    }

    public static Set<IProject> getReferencingProjects(IProject project) {
        HashSet<IProject> memo = new HashSet<IProject>();
        ProjectModulesManager.getProjectsRecursively(project, false, memo);
        memo.remove(project);
        return memo;
    }

    public static Set<IProject> getReferencedProjects(IProject project) {
        HashSet<IProject> memo = new HashSet<IProject>();
        ProjectModulesManager.getProjectsRecursively(project, true, memo);
        memo.remove(project);
        return memo;
    }

    private static void getProjectsRecursively(IProject project, boolean referenced, HashSet<IProject> memo) {
        IProject[] projects = null;
        try {
            if (project == null || !project.isOpen() || !project.exists() || memo.contains(projects)) {
                return;
            }
            projects = referenced ? project.getReferencedProjects() : project.getReferencingProjects();
        }
        catch (CoreException coreException) {}
        if (projects != null) {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject p = iProjectArray[n2];
                if (!memo.contains(p)) {
                    memo.add(p);
                    ProjectModulesManager.getProjectsRecursively(p, referenced, memo);
                }
                ++n2;
            }
        }
    }

    private void addModuleManagers(ArrayList<IModulesManager> list, Collection<IProject> projects) {
        for (IProject project : projects) {
            IModulesManager javaModulesManagerForProject;
            PythonNature nature = PythonNature.getPythonNature(project);
            if (nature != null) {
                ICodeCompletionASTManager otherProjectAstManager = nature.getAstManager();
                if (otherProjectAstManager != null) {
                    IModulesManager projectModulesManager = otherProjectAstManager.getModulesManager();
                    if (projectModulesManager != null) {
                        list.add(projectModulesManager);
                    }
                } else {
                    String msg = "No ast manager configured for :" + project.getName();
                    Log.log((int)2, (String)msg, (Throwable)new RuntimeException(msg));
                }
            }
            if ((javaModulesManagerForProject = JavaProjectModulesManagerCreator.createJavaProjectModulesManagerIfPossible(project)) == null) continue;
            list.add(javaModulesManagerForProject);
        }
    }

    public IModulesManager[] getManagersInvolved(boolean checkSystemManager) {
        return this.getManagers(checkSystemManager, true);
    }

    public IModulesManager[] getRefencingManagersInvolved(boolean checkSystemManager) {
        return this.getManagers(checkSystemManager, false);
    }

    public List<String> getCompletePythonPath(IInterpreterInfo interpreter, IInterpreterManager manager) {
        IModulesManager[] managersInvolved;
        ArrayList<String> l = new ArrayList<String>();
        IModulesManager[] iModulesManagerArray = managersInvolved = this.getManagersInvolved(true);
        int n = managersInvolved.length;
        int n2 = 0;
        while (n2 < n) {
            IModulesManager m = iModulesManagerArray[n2];
            if (m instanceof ISystemModulesManager) {
                ISystemModulesManager systemModulesManager = (ISystemModulesManager)m;
                l.addAll(systemModulesManager.getCompletePythonPath(interpreter, manager));
            } else {
                PythonPathHelper h = (PythonPathHelper)m.getPythonPathHelper();
                if (h != null) {
                    l.addAll(h.getPythonpath());
                }
            }
            ++n2;
        }
        return l;
    }
}

