/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.Tuple3;
import org.python.pydev.core.docutils.ImportHandle;
import org.python.pydev.core.docutils.PyImportsHandling;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.actions.IOrganizeImports;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.ui.importsconf.ImportsPreferencesPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyOrganizeImports
extends PyAction {
    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IAction action) {
        block9: {
            try {
                block8: {
                    if (!this.canModifyEditor()) {
                        return;
                    }
                    pyEdit = this.getPyEdit();
                    ps = new PySelection((ITextEditor)pyEdit);
                    endLineDelim = ps.getEndLineDelim();
                    doc = ps.getDoc();
                    session = null;
                    try {
                        if (ps.getStartLineIndex() != ps.getEndLineIndex()) break block8;
                        participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_organize_imports");
                        for (IOrganizeImports organizeImports : participants) {
                            if (organizeImports.beforePerformArrangeImports(ps, pyEdit)) continue;
                            if (session == null) return;
                            this.endWrite(doc, session);
                            return;
                        }
                        session = this.startWrite(doc);
                        PyOrganizeImports.performArrangeImports(doc, endLineDelim, pyEdit.getIndentPrefs().getIndentationString());
                        var9_9 = participants.iterator();
                        if (true) ** GOTO lbl37
                    }
                    catch (Throwable var10_11) {
                        if (session == null) throw var10_11;
                        this.endWrite(doc, session);
                        throw var10_11;
                    }
                }
                session = this.startWrite(doc);
                PyOrganizeImports.performSimpleSort(doc, endLineDelim, ps.getStartLineIndex(), ps.getEndLineIndex());
                break block9;
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                PyOrganizeImports.beep(e);
            }
            return;
            do {
                organizeImports = (IOrganizeImports)var9_9.next();
                organizeImports.afterPerformArrangeImports(ps, pyEdit);
lbl37:
                // 2 sources

            } while (var9_9.hasNext());
        }
        if (session == null) return;
        this.endWrite(doc, session);
    }

    private void endWrite(IDocument doc, DocumentRewriteSession session) {
        if (doc instanceof IDocumentExtension4) {
            IDocumentExtension4 d = (IDocumentExtension4)doc;
            d.stopRewriteSession(session);
        }
    }

    private DocumentRewriteSession startWrite(IDocument doc) {
        if (doc instanceof IDocumentExtension4) {
            IDocumentExtension4 d = (IDocumentExtension4)doc;
            return d.startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
        }
        return null;
    }

    public static void performArrangeImports(IDocument doc, String endLineDelim, String indentStr) {
        ArrayList<Tuple3<Integer, String, ImportHandle>> list = new ArrayList<Tuple3<Integer, String, ImportHandle>>();
        PyImportsHandling pyImportsHandling = new PyImportsHandling(doc);
        int firstImport = -1;
        for (ImportHandle imp : pyImportsHandling) {
            list.add(new Tuple3((Object)imp.startFoundLine, (Object)imp.importFound, (Object)imp));
            if (firstImport != -1) continue;
            firstImport = imp.startFoundLine;
        }
        if (firstImport == -1) {
            return;
        }
        Collections.sort(list, new Comparator<Tuple3<Integer, String, ImportHandle>>(){

            @Override
            public int compare(Tuple3<Integer, String, ImportHandle> o1, Tuple3<Integer, String, ImportHandle> o2) {
                return ((Integer)o2.o1).compareTo((Integer)o1.o1);
            }
        });
        for (Tuple3 tuple3 : list) {
            String string = (String)tuple3.o2;
            int i = StringUtils.countLineBreaks((String)string);
            while (i >= 0) {
                PySelection.deleteLine((IDocument)doc, (int)((Integer)tuple3.o1));
                --i;
            }
        }
        Collections.sort(list, new Comparator<Tuple3<Integer, String, ImportHandle>>(){

            @Override
            public int compare(Tuple3<Integer, String, ImportHandle> o1, Tuple3<Integer, String, ImportHandle> o2) {
                List info1 = ((ImportHandle)o1.o3).getImportInfo();
                List info2 = ((ImportHandle)o2.o3).getImportInfo();
                boolean isFuture1 = this.getIsFuture(info1);
                boolean isFuture2 = this.getIsFuture(info2);
                if (isFuture1 && !isFuture2) {
                    return -1;
                }
                if (!isFuture1 && isFuture2) {
                    return 1;
                }
                return ((String)o1.o2).compareTo((String)o2.o2);
            }

            private boolean getIsFuture(List<ImportHandle.ImportHandleInfo> info1) {
                String from1 = null;
                if (info1.size() > 0) {
                    from1 = info1.get(0).getFromImportStr();
                }
                boolean isFuture = from1 != null && from1.equals("__future__");
                return isFuture;
            }
        });
        --firstImport;
        FastStringBuffer all = new FastStringBuffer();
        if (!ImportsPreferencesPage.getGroupImports()) {
            for (Tuple3 tuple3 : list) {
                all.append((String)tuple3.o2);
                all.append(endLineDelim);
            }
        } else {
            TreeMap<String, List<ImportHandle.ImportHandleInfo>> treeMap = new TreeMap<String, List<ImportHandle.ImportHandleInfo>>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    boolean isFuture2;
                    Tuple splitted1 = StringUtils.splitOnFirst((String)o1, (char)'.');
                    Tuple splitted2 = StringUtils.splitOnFirst((String)o2, (char)'.');
                    boolean isFuture1 = ((String)splitted1.o1).equals("__future__");
                    if (isFuture1 != (isFuture2 = ((String)splitted2.o1).equals("__future__"))) {
                        if (isFuture1) {
                            return -1;
                        }
                        return 1;
                    }
                    return o1.compareTo(o2);
                }
            });
            ArrayList<ImportHandle.ImportHandleInfo> arrayList = new ArrayList<ImportHandle.ImportHandleInfo>();
            PyOrganizeImports.fillImportStructures(list, treeMap, arrayList);
            boolean multilineImports = ImportsPreferencesPage.getMultilineImports();
            int maxCols = PyOrganizeImports.getMaxCols(multilineImports);
            boolean breakWithParenthesis = PyOrganizeImports.getBreakImportsWithParenthesis();
            Set<Map.Entry<String, List<ImportHandle.ImportHandleInfo>>> entrySet = treeMap.entrySet();
            FastStringBuffer lastFromXXXImportWritten = new FastStringBuffer();
            FastStringBuffer line = new FastStringBuffer();
            for (Map.Entry<String, List<ImportHandle.ImportHandleInfo>> entry : entrySet) {
                ArrayList<Tuple<String, String>> importsAndComments = new ArrayList<Tuple<String, String>>();
                ArrayList<Tuple<String, String>> importsAndNoComments = new ArrayList<Tuple<String, String>>();
                PyOrganizeImports.fillImportFromInfo(entry, importsAndComments, importsAndNoComments);
                boolean firstInLine = true;
                line.clear();
                boolean addedParenForLine = false;
                importsAndNoComments.addAll(importsAndComments);
                int i = 0;
                while (i < importsAndNoComments.size()) {
                    Tuple<String, String> tuple = importsAndNoComments.get(i);
                    if (firstInLine) {
                        lastFromXXXImportWritten.clear();
                        lastFromXXXImportWritten.append("from ");
                        lastFromXXXImportWritten.append(entry.getKey());
                        lastFromXXXImportWritten.append(" import ");
                        line.append(lastFromXXXImportWritten);
                    } else {
                        line.append(", ");
                    }
                    if (multilineImports && line.length() + ((String)tuple.o1).length() + ((String)tuple.o2).length() > maxCols) {
                        if (breakWithParenthesis) {
                            if (!addedParenForLine) {
                                line.insert(lastFromXXXImportWritten.length(), '(');
                                addedParenForLine = true;
                            }
                            line.append(endLineDelim);
                            line.append(indentStr);
                        } else {
                            line.append('\\');
                            line.append(endLineDelim);
                            line.append(indentStr);
                        }
                        all.append(line);
                        line.clear();
                    }
                    line.append((String)tuple.o1);
                    if (addedParenForLine && i == importsAndNoComments.size()) {
                        addedParenForLine = false;
                        line.append(')');
                    }
                    firstInLine = false;
                    if (((String)tuple.o2).length() > 0) {
                        if (addedParenForLine) {
                            addedParenForLine = false;
                            line.append(')');
                        }
                        line.append(' ');
                        line.append((String)tuple.o2);
                        line.append(endLineDelim);
                        all.append(line);
                        line.clear();
                        firstInLine = true;
                    }
                    ++i;
                }
                if (firstInLine) continue;
                if (addedParenForLine) {
                    addedParenForLine = false;
                    line.append(')');
                }
                line.append(endLineDelim);
                all.append(line);
                line.clear();
            }
            PyOrganizeImports.writeImportsWithoutFrom(endLineDelim, all, arrayList);
        }
        PySelection.addLine((IDocument)doc, (String)endLineDelim, (String)all.toString(), (int)firstImport);
    }

    private static void writeImportsWithoutFrom(String endLineDelim, FastStringBuffer all, List<ImportHandle.ImportHandleInfo> importsWithoutFrom) {
        for (ImportHandle.ImportHandleInfo info : importsWithoutFrom) {
            List importedStr = info.getImportedStr();
            List commentsForImports = info.getCommentsForImports();
            int i = 0;
            while (i < importedStr.size()) {
                all.append("import ");
                String importedString = (String)importedStr.get(i);
                String comment = (String)commentsForImports.get(i);
                all.append(importedString);
                if (comment.length() > 0) {
                    all.append(' ');
                    all.append(comment);
                }
                all.append(endLineDelim);
                ++i;
            }
        }
    }

    private static void fillImportFromInfo(Map.Entry<String, List<ImportHandle.ImportHandleInfo>> entry, ArrayList<Tuple<String, String>> importsAndComments, ArrayList<Tuple<String, String>> importsAndNoComments) {
        for (ImportHandle.ImportHandleInfo v : entry.getValue()) {
            List importedStr = v.getImportedStr();
            List commentsForImports = v.getCommentsForImports();
            int i = 0;
            while (i < importedStr.size()) {
                String importedString = ((String)importedStr.get(i)).trim();
                String comment = ((String)commentsForImports.get(i)).trim();
                boolean isWildImport = importedString.equals("*");
                if (isWildImport) {
                    importsAndComments.clear();
                    importsAndNoComments.clear();
                }
                if (comment.length() > 0) {
                    importsAndComments.add((Tuple<String, String>)new Tuple((Object)importedString, (Object)comment));
                } else {
                    importsAndNoComments.add((Tuple<String, String>)new Tuple((Object)importedString, (Object)comment));
                }
                if (isWildImport) {
                    return;
                }
                ++i;
            }
        }
    }

    private static boolean getBreakImportsWithParenthesis() {
        String breakIportMode = ImportsPreferencesPage.getBreakIportMode();
        boolean breakWithParenthesis = true;
        if (!breakIportMode.equals("PARENTHESIS")) {
            breakWithParenthesis = false;
        }
        return breakWithParenthesis;
    }

    private static int getMaxCols(boolean multilineImports) {
        int maxCols = 80;
        if (multilineImports) {
            if (PydevPlugin.getDefault() != null) {
                IPreferenceStore chainedPrefStore = PydevPrefs.getChainedPrefStore();
                maxCols = chainedPrefStore.getInt("printMarginColumn");
            }
        } else {
            maxCols = Integer.MAX_VALUE;
        }
        return maxCols;
    }

    private static void fillImportStructures(List<Tuple3<Integer, String, ImportHandle>> list, TreeMap<String, List<ImportHandle.ImportHandleInfo>> importsWithFrom, List<ImportHandle.ImportHandleInfo> importsWithoutFrom) {
        for (Tuple3<Integer, String, ImportHandle> element : list) {
            List importInfo = ((ImportHandle)element.o3).getImportInfo();
            for (ImportHandle.ImportHandleInfo importHandleInfo : importInfo) {
                String fromImportStr = importHandleInfo.getFromImportStr();
                if (fromImportStr == null) {
                    importsWithoutFrom.add(importHandleInfo);
                    continue;
                }
                List<ImportHandle.ImportHandleInfo> lst = importsWithFrom.get(fromImportStr);
                if (lst == null) {
                    lst = new ArrayList<ImportHandle.ImportHandleInfo>();
                    importsWithFrom.put(fromImportStr, lst);
                }
                lst.add(importHandleInfo);
            }
        }
    }

    public static void performSimpleSort(IDocument doc, String endLineDelim, int startLine, int endLine) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            StringBuffer lastLine = null;
            int i = startLine;
            while (i <= endLine) {
                String line = PySelection.getLine((IDocument)doc, (int)i);
                if (lastLine != null) {
                    int len = lastLine.length();
                    if (len > 0 && lastLine.charAt(len - 1) == '\\') {
                        lastLine.append(endLineDelim);
                        lastLine.append(line);
                    } else {
                        list.add(lastLine.toString());
                        lastLine = new StringBuffer(line);
                    }
                } else {
                    lastLine = new StringBuffer(line);
                }
                ++i;
            }
            if (lastLine != null) {
                list.add(lastLine.toString());
            }
            Collections.sort(list);
            StringBuffer all = new StringBuffer();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String element = (String)iter.next();
                all.append(element);
                if (!iter.hasNext()) continue;
                all.append(endLineDelim);
            }
            int length = doc.getLineInformation(endLine).getLength();
            int endOffset = doc.getLineInformation(endLine).getOffset() + length;
            int startOffset = doc.getLineInformation(startLine).getOffset();
            doc.replace(startOffset, endOffset - startOffset, all.toString());
        }
        catch (BadLocationException e) {
            Log.log((Throwable)e);
        }
    }
}

