/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.io.File;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.parser.fastparser.FastParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;

public class PyCopyQualifiedName
extends PyAction {
    public void run(IAction action) {
        FastStringBuffer buf = new FastStringBuffer();
        try {
            PyEdit pyEdit = this.getPyEdit();
            PySelection pySelection = new PySelection((ITextEditor)pyEdit);
            IPythonNature nature = pyEdit.getPythonNature();
            File editorFile = pyEdit.getEditorFile();
            buf.append(nature.resolveModule(editorFile));
            List path = FastParser.parseToKnowGloballyAccessiblePath((IDocument)pySelection.getDoc(), (int)pySelection.getStartLineIndex());
            for (stmtType stmtType2 : path) {
                if (buf.length() > 0) {
                    buf.append('.');
                }
                buf.append(NodeUtils.getRepresentationString((SimpleNode)stmtType2));
            }
        }
        catch (MisconfigurationException e1) {
            Log.log((Throwable)e1);
            return;
        }
        Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance()};
        Object[] data = new Object[]{buf.toString()};
        Clipboard clipboard = new Clipboard(PyCopyQualifiedName.getShell().getDisplay());
        try {
            try {
                clipboard.setContents(data, dataTypes);
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                MessageDialog.openError((Shell)PyCopyQualifiedName.getShell(), (String)"Error copying to clipboard.", (String)e.getMessage());
                clipboard.dispose();
            }
        }
        finally {
            clipboard.dispose();
        }
    }
}

