/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.python.pydev.ui.ColorAndStyleCache;

public class PyColoredScanner
extends RuleBasedScanner {
    private ColorAndStyleCache colorCache;
    private String name;

    public PyColoredScanner(ColorAndStyleCache colorCache, String name) {
        Assert.isNotNull((Object)colorCache);
        this.colorCache = colorCache;
        this.name = name;
        this.updateColorAndStyle();
    }

    public void updateColorAndStyle() {
        TextAttribute attr;
        if ("COMMENT_COLOR".equals(this.name)) {
            attr = this.colorCache.getCommentTextAttribute();
        } else if ("BACKQUOTES_COLOR".equals(this.name)) {
            attr = this.colorCache.getBackquotesTextAttribute();
        } else if ("STRING_COLOR".equals(this.name)) {
            attr = this.colorCache.getStringTextAttribute();
        } else {
            throw new RuntimeException("Unexpected: " + this.name);
        }
        this.setDefaultReturnToken((IToken)new Token((Object)attr));
    }
}

