/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.actions;

import com.python.pydev.refactoring.markoccurrences.MarkOccurrencesJob;
import com.python.pydev.refactoring.wizards.rename.PyRenameEntryPoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.parser.IParserObserver;
import org.python.pydev.core.parser.ISimpleNode;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.PyParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;

public class PyRenameInFileAction
extends Action {
    private PyEdit pyEdit;

    public PyRenameInFileAction(PyEdit edit) {
        this.pyEdit = edit;
    }

    public void run() {
        RenameInFileJob j = new RenameInFileJob("Rename In File");
        j.setPriority(10);
        j.schedule();
    }

    private boolean fillWithOccurrences(IDocument document, LinkedPositionGroup group, IProgressMonitor monitor, PySelection ps) throws BadLocationException, OperationCanceledException, CoreException, MisconfigurationException {
        RefactoringRequest req = MarkOccurrencesJob.getRefactoringRequest(this.pyEdit, MarkOccurrencesJob.getRefactorAction(this.pyEdit), ps);
        if (monitor.isCanceled()) {
            return false;
        }
        PyRenameEntryPoint processor = new PyRenameEntryPoint(req);
        processor.checkInitialConditions(monitor);
        processor.checkFinalConditions(monitor, null);
        HashSet<ASTEntry> occurrences = processor.getOccurrences();
        if (monitor.isCanceled()) {
            return false;
        }
        HashSet<Tuple> found = new HashSet<Tuple>();
        ArrayList<ProposalPosition> groupPositions = new ArrayList<ProposalPosition>();
        if (occurrences != null) {
            ArrayList<ASTEntry> sortedOccurrences = new ArrayList<ASTEntry>(occurrences);
            Collections.sort(sortedOccurrences, new Comparator<ASTEntry>(){

                @Override
                public int compare(ASTEntry o1, ASTEntry o2) {
                    int thisVal = o1.node.beginLine;
                    int anotherVal = o2.node.beginLine;
                    int ret = thisVal == anotherVal ? ((thisVal = o1.node.beginColumn) < (anotherVal = o2.node.beginColumn) ? -1 : (thisVal == anotherVal ? 0 : 1)) : (thisVal < anotherVal ? -1 : 1);
                    return ret;
                }
            });
            int i = 0;
            int firstPosition = -1;
            int absoluteCursorOffset = ps.getAbsoluteCursorOffset();
            for (ASTEntry entry : sortedOccurrences) {
                try {
                    IRegion lineInformation = document.getLineInformation(entry.node.beginLine - 1);
                    int colDef = NodeUtils.getClassOrFuncColDefinition((SimpleNode)entry.node) - 1;
                    int offset = lineInformation.getOffset() + colDef;
                    int len = req.initialName.length();
                    Tuple foundAt = new Tuple((Object)offset, (Object)len);
                    if (found.contains(foundAt)) continue;
                    ProposalPosition proposalPosition = new ProposalPosition(document, offset, len, ++i, new ICompletionProposal[0]);
                    found.add(foundAt);
                    groupPositions.add(proposalPosition);
                    if (offset > absoluteCursorOffset || absoluteCursorOffset >= offset + len) continue;
                    firstPosition = i;
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                    return false;
                }
            }
            if (firstPosition != -1) {
                ArrayList<ProposalPosition> newGroupPositions = new ArrayList<ProposalPosition>();
                i = firstPosition - 1;
                while (i < groupPositions.size()) {
                    newGroupPositions.add((ProposalPosition)groupPositions.get(i));
                    ++i;
                }
                i = 0;
                while (i < firstPosition - 1) {
                    newGroupPositions.add((ProposalPosition)groupPositions.get(i));
                    ++i;
                }
                groupPositions = newGroupPositions;
            }
            for (ProposalPosition proposalPosition : groupPositions) {
                group.addPosition((LinkedPosition)proposalPosition);
            }
        }
        return groupPositions.size() > 0;
    }

    private class RenameInFileJob
    extends Job {
        private RenameInFileJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            RenameInFileParserObserver observer = new RenameInFileParserObserver();
            PyParser parser = PyRenameInFileAction.this.pyEdit.getParser();
            parser.addParseListener((IParserObserver)observer);
            parser.forceReparse(new Object[0]);
            return Status.OK_STATUS;
        }
    }

    private class RenameInFileParserObserver
    implements IParserObserver {
        private RenameInFileParserObserver() {
        }

        public void parserChanged(ISimpleNode root, IAdaptable file, IDocument doc) {
            PyRenameInFileAction.this.pyEdit.getParser().removeParseListener((IParserObserver)this);
            UIJob job = new UIJob("Rename"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        PySourceViewer viewer = PyRenameInFileAction.this.pyEdit.getPySourceViewer();
                        IDocument document = viewer.getDocument();
                        PySelection ps = new PySelection((ITextEditor)PyRenameInFileAction.this.pyEdit);
                        LinkedPositionGroup group = new LinkedPositionGroup();
                        if (!PyRenameInFileAction.this.fillWithOccurrences(document, group, (IProgressMonitor)new NullProgressMonitor(), ps)) {
                            return Status.OK_STATUS;
                        }
                        if (group.isEmpty()) {
                            return Status.OK_STATUS;
                        }
                        LinkedModeModel model = new LinkedModeModel();
                        model.addGroup(group);
                        if (model.tryInstall() && model.getTabStopSequence().size() > 0) {
                            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, (ITextViewer)viewer);
                            Tuple currToken = ps.getCurrToken();
                            ui.setCyclingMode(LinkedModeUI.CYCLE_ALWAYS);
                            ui.setExitPosition((ITextViewer)viewer, (Integer)currToken.o2 + ((String)currToken.o1).length(), 0, 0);
                            ui.enter();
                        }
                    }
                    catch (BadLocationException e) {
                        Log.log((Throwable)e);
                    }
                    catch (Throwable e) {
                        Log.log((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(10);
            job.schedule();
        }

        public void parserError(Throwable error, IAdaptable file, IDocument doc) {
            PyRenameInFileAction.this.pyEdit.getParser().removeParseListener((IParserObserver)this);
        }
    }
}

