/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.codecompletion.ctxinsensitive;

import com.python.pydev.analysis.AnalysisPlugin;
import com.python.pydev.analysis.CtxInsensitiveImportComplProposal;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalSystemInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.IInfo;
import com.python.pydev.analysis.ui.AutoImportsPreferencesPage;
import com.python.pydev.codecompletion.ctxinsensitive.PyConsoleCompletion;
import com.python.pydev.codecompletion.ui.CodeCompletionPreferencesPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.dltk.console.ui.IScriptConsoleViewer;
import org.python.pydev.editor.codecompletion.CompletionRequest;
import org.python.pydev.editor.codecompletion.IPyDevCompletionParticipant;
import org.python.pydev.editor.codecompletion.IPyDevCompletionParticipant2;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtxParticipant
implements IPyDevCompletionParticipant,
IPyDevCompletionParticipant2 {
    public Collection<ICompletionProposal> computeConsoleCompletions(PySelection.ActivationTokenAndQual tokenAndQual, List<IPythonNature> naturesUsed, IScriptConsoleViewer viewer, int requestOffset) {
        ArrayList<ICompletionProposal> completions = new ArrayList<ICompletionProposal>();
        if (tokenAndQual.activationToken != null && tokenAndQual.activationToken.length() > 0) {
            return completions;
        }
        String qual = tokenAndQual.qualifier;
        if (qual.length() >= CodeCompletionPreferencesPage.getCharsForContextInsensitiveGlobalTokensCompletion() && naturesUsed != null && naturesUsed.size() > 0) {
            boolean addAutoImport = AutoImportsPreferencesPage.doAutoImport();
            int qlen = qual.length();
            String lowerQual = qual.toLowerCase();
            for (IPythonNature nature : naturesUsed) {
                this.fillNatureCompletionsForConsole(viewer, requestOffset, completions, qual, addAutoImport, qlen, lowerQual, nature, false);
            }
            this.fillNatureCompletionsForConsole(viewer, requestOffset, completions, qual, addAutoImport, qlen, lowerQual, naturesUsed.get(0), true);
        }
        return completions;
    }

    private void fillNatureCompletionsForConsole(IScriptConsoleViewer viewer, int requestOffset, List<ICompletionProposal> completions, String qual, boolean addAutoImport, int qlen, String lowerQual, IPythonNature nature, boolean getSystem) {
        AbstractAdditionalDependencyInfo additionalInfoForProject;
        if (getSystem) {
            try {
                additionalInfoForProject = AdditionalSystemInterpreterInfo.getAdditionalSystemInfo((IInterpreterManager)PydevPlugin.getInterpreterManager((IPythonNature)nature), (String)nature.getProjectInterpreter().getExecutableOrJar());
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                return;
            }
        }
        try {
            additionalInfoForProject = AdditionalProjectInterpreterInfo.getAdditionalInfoForProject((IPythonNature)nature);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return;
        }
        Collection tokensStartingWith = additionalInfoForProject.getTokensStartingWith(qual, 1);
        FastStringBuffer realImportRep = new FastStringBuffer();
        FastStringBuffer displayString = new FastStringBuffer();
        FastStringBuffer tempBuf = new FastStringBuffer();
        boolean doIgnoreImportsStartingWithUnder = AutoImportsPreferencesPage.doIgnoreImportsStartingWithUnder();
        for (IInfo info : tokensStartingWith) {
            String rep;
            String lowerRep;
            String declaringModuleName = info.getDeclaringModuleName();
            boolean hasInit = false;
            if (declaringModuleName.endsWith(".__init__")) {
                declaringModuleName = declaringModuleName.substring(0, declaringModuleName.length() - 9);
                hasInit = true;
            }
            if (!(lowerRep = (rep = info.getName()).toLowerCase()).startsWith(lowerQual)) continue;
            if (addAutoImport) {
                realImportRep.clear();
                realImportRep.append("from ");
                realImportRep.append(AutoImportsPreferencesPage.removeImportsStartingWithUnderIfNeeded((String)declaringModuleName, (FastStringBuffer)tempBuf, (boolean)doIgnoreImportsStartingWithUnder));
                realImportRep.append(" import ");
                realImportRep.append(rep);
            }
            displayString.clear();
            displayString.append(rep);
            displayString.append(" - ");
            displayString.append(declaringModuleName);
            if (hasInit) {
                displayString.append(".__init__");
            }
            PyConsoleCompletion proposal = new PyConsoleCompletion(rep, requestOffset - qlen, qlen, realImportRep.length(), AnalysisPlugin.getImageForAutoImportTypeInfo((IInfo)info), displayString.toString(), null, "", lowerRep.equals(lowerQual) ? 0 : 50, realImportRep.toString(), viewer);
            completions.add((ICompletionProposal)proposal);
        }
    }

    private Collection<CtxInsensitiveImportComplProposal> getThem(CompletionRequest request, ICompletionState state, boolean addAutoImport) throws MisconfigurationException {
        ArrayList<CtxInsensitiveImportComplProposal> completions = new ArrayList<CtxInsensitiveImportComplProposal>();
        if (request.isInCalltip) {
            return completions;
        }
        HashSet<String> importedNames = this.getImportedNames(state);
        String qual = request.qualifier;
        if (qual.length() >= CodeCompletionPreferencesPage.getCharsForContextInsensitiveGlobalTokensCompletion()) {
            String lowerQual = qual.toLowerCase();
            String initialModule = request.resolveModule();
            List tokensStartingWith = AdditionalProjectInterpreterInfo.getTokensStartingWith((String)qual, (IPythonNature)request.nature, (int)1);
            FastStringBuffer realImportRep = new FastStringBuffer();
            FastStringBuffer displayString = new FastStringBuffer();
            FastStringBuffer tempBuf = new FastStringBuffer();
            boolean doIgnoreImportsStartingWithUnder = AutoImportsPreferencesPage.doIgnoreImportsStartingWithUnder();
            for (IInfo info : tokensStartingWith) {
                String rep;
                String lowerRep;
                String declaringModuleName = info.getDeclaringModuleName();
                if (initialModule != null && declaringModuleName != null && initialModule.equals(declaringModuleName)) continue;
                boolean hasInit = false;
                if (declaringModuleName.endsWith(".__init__")) {
                    declaringModuleName = declaringModuleName.substring(0, declaringModuleName.length() - 9);
                    hasInit = true;
                }
                if (!(lowerRep = (rep = info.getName()).toLowerCase()).startsWith(lowerQual) || importedNames.contains(rep)) continue;
                if (addAutoImport) {
                    realImportRep.clear();
                    realImportRep.append("from ");
                    realImportRep.append(AutoImportsPreferencesPage.removeImportsStartingWithUnderIfNeeded((String)declaringModuleName, (FastStringBuffer)tempBuf, (boolean)doIgnoreImportsStartingWithUnder));
                    realImportRep.append(" import ");
                    realImportRep.append(rep);
                }
                displayString.clear();
                displayString.append(rep);
                displayString.append(" - ");
                displayString.append(declaringModuleName);
                if (hasInit) {
                    displayString.append(".__init__");
                }
                CtxInsensitiveImportComplProposal proposal = new CtxInsensitiveImportComplProposal(rep, request.documentOffset - request.qlen, request.qlen, realImportRep.length(), AnalysisPlugin.getImageForAutoImportTypeInfo((IInfo)info), displayString.toString(), null, "", lowerRep.equals(lowerQual) ? 0 : 50, realImportRep.toString());
                completions.add(proposal);
            }
        }
        return completions;
    }

    private HashSet<String> getImportedNames(ICompletionState state) {
        List tokenImportedModules = state.getTokenImportedModules();
        HashSet<String> importedNames = new HashSet<String>();
        if (tokenImportedModules != null) {
            for (IToken token : tokenImportedModules) {
                importedNames.add(token.getRepresentation());
            }
        }
        return importedNames;
    }

    public Collection getGlobalCompletions(CompletionRequest request, ICompletionState state) throws MisconfigurationException {
        return this.getThem(request, state, AutoImportsPreferencesPage.doAutoImport());
    }

    public Collection getCompletionsForMethodParameter(ICompletionState state, ILocalScope localScope, Collection<IToken> interfaceForLocal) {
        ArrayList<SourceToken> ret = new ArrayList<SourceToken>();
        String qual = state.getQualifier();
        if (qual.length() >= CodeCompletionPreferencesPage.getCharsForContextInsensitiveGlobalTokensCompletion()) {
            List tokensStartingWith;
            try {
                tokensStartingWith = AdditionalProjectInterpreterInfo.getTokensStartingWith((String)qual, (IPythonNature)state.getNature(), (int)2);
            }
            catch (MisconfigurationException e) {
                Log.log((Throwable)e);
                return ret;
            }
            for (IInfo info : tokensStartingWith) {
                ret.add(new SourceToken(null, info.getName(), null, null, info.getDeclaringModuleName(), info.getType()));
            }
        }
        return ret;
    }

    public Collection getStringGlobalCompletions(CompletionRequest request, ICompletionState state) throws MisconfigurationException {
        return this.getThem(request, state, false);
    }

    public Collection<Object> getArgsCompletion(ICompletionState state, ILocalScope localScope, Collection<IToken> interfaceForLocal) {
        throw new RuntimeException("Deprecated");
    }

    public Collection<IToken> getCompletionsForTokenWithUndefinedType(ICompletionState state, ILocalScope localScope, Collection<IToken> interfaceForLocal) {
        return this.getCompletionsForMethodParameter(state, localScope, interfaceForLocal);
    }
}

